/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.channel.packet;

import com.tuya.sdk.blelib.channel.packet.Packet;
import com.tuya.sdk.blelib.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DataPacket
extends Packet {
    public int seq;
    public Packet.Bytes bytes;
    public byte[] crc;

    public DataPacket(int n, Packet.Bytes bytes) {
        this.seq = n;
        this.bytes = bytes;
    }

    public DataPacket(int n, byte[] byArray, int n2, int n3) {
        Packet.Bytes bytes;
        DataPacket dataPacket = bytes2;
        Packet.Bytes bytes2 = bytes;
        bytes = new Packet.Bytes(byArray, n2, n3);
        dataPacket(n, bytes2);
    }

    public int getSeq() {
        return this.seq;
    }

    public int getDataLength() {
        return this.bytes.getSize();
    }

    @Override
    public String getName() {
        return "data";
    }

    public void setLastFrame() {
        int n;
        Packet.Bytes bytes = this.bytes;
        bytes.end = n = bytes.end - 2;
        this.crc = ByteUtils.get(bytes.value, n, 2);
    }

    public byte[] getCrc() {
        return this.crc;
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer byteBuffer;
        int n = this.getDataLength() + 2;
        if (n == 20) {
            Arrays.fill(Packet.BUFFER, (byte)0);
            byteBuffer = ByteBuffer.wrap(Packet.BUFFER);
        } else {
            byteBuffer = ByteBuffer.allocate(n);
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.putShort((short)this.seq);
        this.fillByteBuffer(byteBuffer2);
        return byteBuffer.array();
    }

    public void fillByteBuffer(ByteBuffer byteBuffer) {
        DataPacket dataPacket = object;
        Packet.Bytes bytes = dataPacket.bytes;
        Object object = bytes.value;
        int n = bytes.start;
        int n2 = dataPacket.getDataLength();
        byteBuffer.put((byte[])object, n, n2);
    }

    public String toString() {
        return "DataPacket{seq=" + this.seq + ", size=" + this.bytes.getSize() + '}';
    }
}

