/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.channel.packet;

import com.tuya.sdk.blelib.channel.packet.Packet;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ACKPacket
extends Packet {
    public static final int SUCCESS = 0;
    public static final int READY = 1;
    public static final int BUSY = 2;
    public static final int TIMEOUT = 3;
    public static final int CANCEL = 4;
    public static final int SYNC = 5;
    public int status;
    public int seq;

    public ACKPacket(int n) {
        this(n, 0);
    }

    public ACKPacket(int n, int n2) {
        this.status = n;
        this.seq = n2;
    }

    private String getStatusDesc(int n) {
        for (Field field : ACKPacket.class.getDeclaredFields()) {
            if ((field.getModifiers() & 0x18) <= 0) continue;
            if (field.get(null) != Integer.valueOf(n)) continue;
            try {
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return n + "";
    }

    @Override
    public String getName() {
        return "ack";
    }

    public int getStatus() {
        return this.status;
    }

    public int getSeq() {
        return this.seq;
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.wrap(Packet.BUFFER);
        byteBuffer2.putShort((short)0);
        byteBuffer2.put((byte)1);
        byteBuffer2.put((byte)0);
        byteBuffer.putShort((short)this.status);
        byteBuffer.putShort((short)this.seq);
        return byteBuffer.array();
    }

    public String toString() {
        ACKPacket aCKPacket = this;
        return "ACKPacket{status=" + aCKPacket.getStatusDesc(aCKPacket.status) + ", seq=" + this.seq + '}';
    }
}

