/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.channel;

import android.os.Handler;
import android.os.Looper;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.concurrent.TimeoutException;

public class Timer {
    public static Handler mHandler = new Handler(Looper.getMainLooper());
    public static TimerCallback mCallback;

    public static synchronized void stop() {
        mHandler.removeCallbacksAndMessages(null);
        mCallback = null;
    }

    public static synchronized boolean isRunning() {
        return mCallback != null;
    }

    public static synchronized String getName() {
        return Timer.isRunning() ? mCallback.getName() : "";
    }

    public static synchronized void start(TimerCallback timerCallback, long l) {
        mHandler.removeCallbacksAndMessages(null);
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        mHandler = new Handler(looper);
        mHandler.postDelayed((Runnable)timerCallback, l);
        mCallback = timerCallback;
    }

    public static abstract class TimerCallback
    implements Runnable {
        public String name;

        public TimerCallback(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public final void run() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.name;
            BluetoothLog.e(WtUtil.format("%s: Timer expired!!!", objectArray2));
            try {
                this.onTimerCallback();
            }
            catch (TimeoutException timeoutException) {
                BluetoothLog.e(timeoutException);
            }
            mCallback = null;
        }

        public abstract void onTimerCallback() throws TimeoutException;
    }
}

