/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.channel;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.SparseArray;
import com.tuya.sdk.blelib.BluetoothContext;
import com.tuya.sdk.blelib.channel.CRC16;
import com.tuya.sdk.blelib.channel.ChannelCallback;
import com.tuya.sdk.blelib.channel.ChannelEvent;
import com.tuya.sdk.blelib.channel.ChannelState;
import com.tuya.sdk.blelib.channel.ChannelStateBlock;
import com.tuya.sdk.blelib.channel.IChannel;
import com.tuya.sdk.blelib.channel.IChannelStateHandler;
import com.tuya.sdk.blelib.channel.Timer;
import com.tuya.sdk.blelib.channel.packet.ACKPacket;
import com.tuya.sdk.blelib.channel.packet.CTRPacket;
import com.tuya.sdk.blelib.channel.packet.DataPacket;
import com.tuya.sdk.blelib.channel.packet.Packet;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.ByteUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import com.tuya.sdk.blelib.utils.proxy.ProxyBulk;
import com.tuya.sdk.blelib.utils.proxy.ProxyInterceptor;
import com.tuya.sdk.blelib.utils.proxy.ProxyUtils;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;

public abstract class Channel
implements IChannel,
ProxyInterceptor {
    public static final long TIMEOUT = 5000L;
    public static final int MSG_WRITE_CALLBACK = 1;
    public static final String TIMER_EXCEPTION = "exception";
    public ChannelState mCurrentState;
    public byte[] mBytesToWrite;
    public SparseArray<Packet> mPacketRecv;
    public int mCurrentSync;
    public int mTotalBytes;
    public int mFrameCount;
    public ChannelCallback mChannelCallback;
    public Handler mWorkerHandler;
    public IChannel mChannel;
    public int mLastSync;
    public final IChannelStateHandler mSyncPacketHandler;
    public final IChannelStateHandler mRecvDataHandler;
    public final IChannelStateHandler mRecvCTRHandler;
    public final IChannelStateHandler mWaitStartACKHandler;
    public final Timer.TimerCallback mTimeoutHandler;
    public final IChannelStateHandler mRecvACKHandler;
    public final ChannelStateBlock[] STATE_MACHINE;
    public final IChannel mChannelImpl;
    public final Handler.Callback mCallback;

    public Channel() {
        HandlerThread handlerThread;
        ChannelStateBlock channelStateBlock;
        ChannelStateBlock channelStateBlock2;
        ChannelStateBlock channelStateBlock3;
        ChannelStateBlock channelStateBlock4;
        ChannelStateBlock channelStateBlock5;
        ChannelStateBlock channelStateBlock6;
        Channel channel = channel3;
        channel.mCurrentState = ChannelState.IDLE;
        channel.mSyncPacketHandler = new IChannelStateHandler(){

            @Override
            public void handleState(Object ... object) {
                Channel.this.assertRuntime(false);
                object = (DataPacket)object[0];
                if (object.getSeq() != Channel.this.mCurrentSync) {
                    BluetoothLog.w(WtUtil.format("sync packet not matched!!", new Object[0]));
                    return;
                }
                if (!Channel.this.onDataPacketRecvd((DataPacket)object)) {
                    BluetoothLog.w(WtUtil.format("sync packet repeated!!", new Object[0]));
                    return;
                }
                1 v0 = this;
                Channel channel = v0.Channel.this;
                Channel.access$302(channel, channel.mCurrentSync);
                Channel.access$102(v0.Channel.this, 0);
                v0.Channel.this.startSyncPacket();
            }
        };
        channel.mRecvDataHandler = new IChannelStateHandler(){

            @Override
            public void handleState(Object ... object) {
                Channel.this.assertRuntime(false);
                object = (DataPacket)object[0];
                if (!Channel.this.onDataPacketRecvd((DataPacket)object)) {
                    BluetoothLog.w(WtUtil.format("dataPacket repeated!!", new Object[0]));
                    return;
                }
                if (((DataPacket)object).getSeq() == Channel.this.mFrameCount) {
                    Channel.this.startSyncPacket();
                } else {
                    Timer.TimerCallback timerCallback;
                    object = timerCallback;
                    timerCallback = new Timer.TimerCallback("WaitData"){

                        @Override
                        public void onTimerCallback() {
                            Channel.this.startSyncPacket();
                        }
                    };
                    Channel.this.startTimer(5000L, (Timer.TimerCallback)object);
                }
            }
        };
        channel.mRecvCTRHandler = new IChannelStateHandler(){

            @Override
            public void handleState(Object ... object) {
                ChannelCallback channelCallback;
                ACKPacket aCKPacket;
                3 v0 = this;
                Channel.this.assertRuntime(false);
                object = (CTRPacket)object[0];
                Channel.access$502(v0.Channel.this, ((CTRPacket)object).getFrameCount());
                object = aCKPacket;
                aCKPacket = new ACKPacket(1);
                v0.Channel.this.setCurrentState(ChannelState.READY);
                Object object2 = object;
                object = channelCallback;
                channelCallback = new ChannelCallback(){

                    @Override
                    public void onCallback(int n) {
                        Channel.this.assertRuntime(false);
                        if (n == 0) {
                            1 v0 = this;
                            v0.Channel.this.setCurrentState(ChannelState.READING);
                            v0.Channel.this.startTimer();
                        } else {
                            Channel.this.resetChannelStatus();
                        }
                    }
                };
                v0.Channel.this.performWrite((Packet)object2, (ChannelCallback)object);
            }
        };
        channel.mWaitStartACKHandler = new IChannelStateHandler(){

            @Override
            public void handleState(Object ... objectArray) {
                4 v0 = this;
                v0.Channel.this.assertRuntime(false);
                v0.Channel.this.setCurrentState(ChannelState.WAIT_START_ACK);
                v0.Channel.this.startTimer();
            }
        };
        channel.mTimeoutHandler = new Timer.TimerCallback(Channel.class.getSimpleName()){

            @Override
            public void onTimerCallback() {
                5 v0 = this;
                v0.Channel.this.assertRuntime(false);
                v0.Channel.this.onSendCallback(-2);
                v0.Channel.this.resetChannelStatus();
            }
        };
        channel.mRecvACKHandler = new IChannelStateHandler(){

            @Override
            public void handleState(Object ... object) {
                Channel.this.assertRuntime(false);
                object = (ACKPacket)object[0];
                int n = ((ACKPacket)object).getStatus();
                if (n != 0) {
                    if (n != 1) {
                        if (n != 5) {
                            6 v0 = this;
                            v0.Channel.this.onSendCallback(-1);
                            v0.Channel.this.resetChannelStatus();
                        } else {
                            int n2 = ((ACKPacket)object).getSeq();
                            if (n2 >= 1 && n2 <= Channel.this.mFrameCount) {
                                6 v1 = this;
                                v1.Channel.this.sendDataPacket(n2 - 1, false);
                                v1.Channel.this.startTimer();
                            }
                        }
                    } else {
                        6 v2 = this;
                        v2.Channel.this.stopTimer();
                        v2.Channel.this.setCurrentState(ChannelState.WRITING);
                        v2.Channel.this.sendDataPacket(0, true);
                    }
                } else {
                    6 v3 = this;
                    v3.Channel.this.onSendCallback(0);
                    v3.Channel.this.resetChannelStatus();
                }
            }
        };
        ChannelStateBlock[] channelStateBlockArray = new ChannelStateBlock[6];
        ChannelStateBlock channelStateBlock7 = channelStateBlock6;
        ChannelState channelState = ChannelState.READY;
        ChannelEvent channelEvent = ChannelEvent.SEND_CTR;
        IChannelStateHandler iChannelStateHandler = channel3.mWaitStartACKHandler;
        channelStateBlock6 = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[0] = channelStateBlock7;
        channelStateBlock7 = channelStateBlock5;
        channelState = ChannelState.WAIT_START_ACK;
        channelEvent = ChannelEvent.RECV_ACK;
        iChannelStateHandler = channel3.mRecvACKHandler;
        channelStateBlock5 = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[1] = channelStateBlock7;
        channelStateBlock7 = channelStateBlock4;
        channelState = ChannelState.SYNC;
        channelEvent = ChannelEvent.RECV_ACK;
        iChannelStateHandler = channel3.mRecvACKHandler;
        channelStateBlock4 = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[2] = channelStateBlock7;
        channelStateBlock7 = channelStateBlock3;
        channelState = ChannelState.IDLE;
        channelEvent = ChannelEvent.RECV_CTR;
        iChannelStateHandler = channel3.mRecvCTRHandler;
        channelStateBlock3 = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[3] = channelStateBlock7;
        channelStateBlock7 = channelStateBlock2;
        channelState = ChannelState.READING;
        channelEvent = ChannelEvent.RECV_DATA;
        iChannelStateHandler = channel3.mRecvDataHandler;
        channelStateBlock2 = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[4] = channelStateBlock7;
        channelStateBlock7 = channelStateBlock;
        channelState = ChannelState.SYNC_ACK;
        channelEvent = ChannelEvent.RECV_DATA;
        iChannelStateHandler = channel3.mSyncPacketHandler;
        channelStateBlock = new ChannelStateBlock(channelState, channelEvent, iChannelStateHandler);
        channelStateBlockArray[5] = channelStateBlock7;
        channel.STATE_MACHINE = channelStateBlockArray;
        channel.mChannelImpl = new IChannel(){

            @Override
            public void write(byte[] byArray, ChannelCallback channelCallback) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onRead(byte[] byArray) {
                Channel.this.performOnRead(byArray);
            }

            @Override
            public void onRecv(byte[] byArray) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void send(byte[] byArray, ChannelCallback channelCallback) {
                Channel.this.performSend(byArray, channelCallback);
            }
        };
        channel.mCallback = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what != 1) {
                    ProxyBulk.safeInvoke(message.obj);
                } else {
                    ((ChannelCallback)message.obj).onCallback(message.arg1);
                }
                return false;
            }
        };
        channel.mPacketRecv = new SparseArray();
        channel.mChannel = (IChannel)ProxyUtils.getProxy(channel.mChannelImpl, channel3);
        channelStateBlock7 = handlerThread;
        new HandlerThread(Channel.class.getSimpleName()).start();
        Channel channel2 = channel3;
        Channel channel3 = channelStateBlock7.getLooper();
        channel.mWorkerHandler = new Handler((Looper)channel3, channel2.mCallback);
    }

    private void performWrite(Packet packet, final ChannelCallback channelCallback) {
        this.assertRuntime(false);
        if (channelCallback != null) {
            if (!this.isTimerOn()) {
                this.startExceptionTimer();
            }
            final byte[] byArray = packet.toBytes();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getLogTag();
            objectArray[1] = packet;
            BluetoothLog.w(WtUtil.format("%s: %s", objectArray2));
            BluetoothContext.post(new Runnable(){

                @Override
                public void run() {
                    WriteCallback writeCallback;
                    Channel channel = Channel.this;
                    byte[] byArray2 = byArray;
                    WriteCallback writeCallback2 = writeCallback;
                    writeCallback = channel.new WriteCallback(channelCallback);
                    channel.write(byArray2, writeCallback2);
                }
            });
            return;
        }
        throw new NullPointerException("callback can't be null");
    }

    private void sendStartFlowPacket() {
        ChannelCallback channelCallback;
        Channel channel = this;
        channel.assertRuntime(false);
        ChannelCallback channelCallback2 = channelCallback;
        channelCallback = new ChannelCallback(){

            @Override
            public void onCallback(int n) {
                Channel.this.assertRuntime(false);
                if (n == 0) {
                    Channel.this.onPostState(ChannelEvent.SEND_CTR, new Object[0]);
                } else {
                    8 v0 = this;
                    v0.Channel.this.onSendCallback(-1);
                    v0.Channel.this.resetChannelStatus();
                }
            }
        };
        channel.performWrite(new CTRPacket(this.mFrameCount), channelCallback2);
    }

    private void onSendCallback(int n) {
        Channel channel = channelCallback;
        channel.assertRuntime(false);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((Channel)((Object)channelCallback)).getLogTag();
        objectArray[1] = n;
        BluetoothLog.v(WtUtil.format("%s: code = %d", objectArray2));
        ChannelCallback channelCallback = channel.mChannelCallback;
        if (channelCallback != null) {
            channelCallback.onCallback(n);
        }
    }

    private boolean onDataPacketRecvd(DataPacket dataPacket) {
        Channel channel = this;
        channel.assertRuntime(false);
        if (channel.mPacketRecv.get(dataPacket.getSeq()) != null) {
            return false;
        }
        if (dataPacket.getSeq() == this.mFrameCount) {
            dataPacket.setLastFrame();
        }
        Channel channel2 = this;
        channel2.mPacketRecv.put(dataPacket.getSeq(), (Object)dataPacket);
        channel2.mTotalBytes += dataPacket.getDataLength();
        channel2.stopTimer();
        return true;
    }

    private void startSyncPacket() {
        Channel channel = this;
        channel.assertRuntime(false);
        BluetoothLog.v(channel.getLogTag());
        channel.startTimer();
        channel.setCurrentState(ChannelState.SYNC);
        if (!channel.syncLostPacket()) {
            final byte[] byArray = this.getTotalRecvdBytes();
            if (!ByteUtils.isEmpty(byArray)) {
                ChannelCallback channelCallback;
                ACKPacket aCKPacket;
                ACKPacket aCKPacket2 = aCKPacket;
                aCKPacket = new ACKPacket(0);
                ChannelCallback channelCallback2 = channelCallback;
                channelCallback = new ChannelCallback(){

                    @Override
                    public void onCallback(int n) {
                        9 v0 = this;
                        v0.Channel.this.assertRuntime(false);
                        v0.Channel.this.resetChannelStatus();
                        if (n == 0) {
                            Channel.this.dispatchOnReceive(byArray);
                        }
                    }
                };
                this.performWrite(aCKPacket2, channelCallback2);
            } else {
                this.resetChannelStatus();
            }
        }
    }

    private void dispatchOnReceive(byte[] byArray) {
        String string;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        String string2 = string;
        string = new String(byArray);
        objectArray[0] = string2;
        BluetoothLog.e(WtUtil.format(">>> receive: %s", objectArray2));
        BluetoothContext.post(new RecvCallback(byArray));
    }

    private byte[] getTotalRecvdBytes() {
        Channel channel = this;
        channel.assertRuntime(false);
        if (channel.mPacketRecv.size() == this.mFrameCount) {
            Object[] objectArray = new Object[2];
            Object object = objectArray;
            object[0] = this.getLogTag();
            objectArray[1] = this.mTotalBytes;
            BluetoothLog.v(WtUtil.format("%s: totalBytes = %d", (Object[])object));
            object = ByteBuffer.allocate(this.mTotalBytes);
            for (int i = 1; i <= this.mFrameCount; ++i) {
                Channel channel2 = this;
                Object object2 = (DataPacket)channel2.mPacketRecv.get(i);
                ((DataPacket)object2).fillByteBuffer((ByteBuffer)object);
                if (i != channel2.mFrameCount || this.checkCRC((byte[])(object2 = (Object)((ByteBuffer)object).array()), ((DataPacket)object2).getCrc())) continue;
                BluetoothLog.e(WtUtil.format("check crc failed!!", new Object[0]));
                return ByteUtils.EMPTY_BYTES;
            }
            return ((ByteBuffer)object).array();
        }
        throw new IllegalStateException();
    }

    private boolean syncLostPacket() {
        int n;
        Channel channel = this;
        channel.assertRuntime(false);
        BluetoothLog.v(channel.getLogTag());
        for (n = (v104138).mLastSync + 1; n <= this.mFrameCount && this.mPacketRecv.get(n) != null; ++n) {
        }
        if (n <= this.mFrameCount) {
            ChannelCallback channelCallback;
            ACKPacket aCKPacket;
            this.mCurrentSync = n;
            ACKPacket aCKPacket2 = aCKPacket;
            aCKPacket = new ACKPacket(5, n);
            ChannelCallback channelCallback2 = channelCallback;
            channelCallback = new ChannelCallback(){

                @Override
                public void onCallback(int n) {
                    Channel.this.assertRuntime(false);
                    if (n == 0) {
                        10 v0 = this;
                        v0.Channel.this.setCurrentState(ChannelState.SYNC_ACK);
                        v0.Channel.this.startTimer();
                    } else {
                        Channel.this.resetChannelStatus();
                    }
                }
            };
            this.performWrite(aCKPacket2, channelCallback2);
            return true;
        }
        return false;
    }

    private void resetChannelStatus() {
        Channel channel = this;
        channel.assertRuntime(false);
        BluetoothLog.v(channel.getLogTag());
        channel.stopTimer();
        channel.setCurrentState(ChannelState.IDLE);
        channel.mBytesToWrite = null;
        channel.mFrameCount = 0;
        channel.mChannelCallback = null;
        channel.mPacketRecv.clear();
        channel.mCurrentSync = 0;
        channel.mLastSync = 0;
        channel.mTotalBytes = 0;
    }

    private void sendDataPacket(final int n, final boolean bl) {
        Channel channel = this;
        channel.assertRuntime(false);
        if (n >= channel.mFrameCount) {
            Channel channel2 = this;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getLogTag();
            BluetoothLog.v(WtUtil.format("%s: all packets sended!!", objectArray2));
            channel2.setCurrentState(ChannelState.SYNC);
            channel2.startTimer(15000L);
            return;
        }
        Channel channel3 = this;
        Object[] objectArray = new Object[3];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = this.getLogTag();
        int n2 = n + 1;
        objectArray3[1] = n2;
        objectArray[2] = bl;
        BluetoothLog.v(WtUtil.format("%s: index = %d, looped = %b", objectArray3));
        int n3 = n * 18;
        int n4 = Math.min(channel3.mBytesToWrite.length, n2 * 18);
        channel3.performWrite(new DataPacket(n2, this.mBytesToWrite, n3, n4), new ChannelCallback(){

            @Override
            public void onCallback(int n2) {
                Channel.this.assertRuntime(false);
                if (n2 != 0) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = n;
                    BluetoothLog.w(WtUtil.format(">>> packet %d write failed", objectArray2));
                }
                boolean bl2 = bl;
                n2 = bl2 ? 1 : 0;
                if (bl2) {
                    Channel.this.sendDataPacket(n + 1, n2 != 0);
                }
            }
        });
    }

    private void setCurrentState(ChannelState channelState) {
        this.assertRuntime(false);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getLogTag();
        objectArray[1] = channelState;
        BluetoothLog.v(WtUtil.format("%s: state = %s", objectArray2));
        this.mCurrentState = channelState;
    }

    private void onPostState(ChannelEvent channelEvent, Object ... objectArray) {
        Channel channel = this;
        channel.assertRuntime(false);
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = this.getLogTag();
        objectArray2[1] = this.mCurrentState;
        objectArray2[2] = channelEvent;
        BluetoothLog.v(WtUtil.format("%s: state = %s, event = %s", objectArray3));
        objectArray3 = channel.STATE_MACHINE;
        int n = channel.STATE_MACHINE.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray3[i];
            if (((ChannelStateBlock)object).state != this.mCurrentState || ((ChannelStateBlock)object).event != channelEvent) continue;
            ((ChannelStateBlock)object).handler.handleState(objectArray);
            break;
        }
    }

    private void assertRuntime(boolean bl) {
        Channel channel = bl ? Looper.getMainLooper() : channel.mWorkerHandler.getLooper();
        if (Looper.myLooper() == channel) {
            return;
        }
        throw new RuntimeException();
    }

    private void performOnRead(byte[] object) {
        Object object2;
        object2.assertRuntime(false);
        Packet packet = Packet.getPacket(object);
        object = packet;
        Object[] objectArray = new Object[2];
        Object object3 = objectArray;
        objectArray[0] = object2.getLogTag();
        objectArray[1] = object;
        BluetoothLog.w(WtUtil.format("%s: %s", (Object[])object3));
        object3 = packet.getName();
        int n = -1;
        int n2 = ((String)object3).hashCode();
        if (n2 != 96393) {
            if (n2 != 98849) {
                if (n2 == 3076010 && ((String)object3).equals("data")) {
                    n = 1;
                }
            } else if (((String)object3).equals("ctr")) {
                n = 2;
            }
        } else if (((String)object3).equals("ack")) {
            n = 0;
        }
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    Channel channel = object2;
                    object2 = ChannelEvent.RECV_CTR;
                    Object[] objectArray2 = new Object[1];
                    object3 = objectArray2;
                    objectArray2[0] = object;
                    channel.onPostState((ChannelEvent)((Object)object2), (Object[])object3);
                }
            } else {
                Channel channel = object2;
                object2 = ChannelEvent.RECV_DATA;
                Object[] objectArray3 = new Object[1];
                object3 = objectArray3;
                objectArray3[0] = object;
                channel.onPostState((ChannelEvent)((Object)object2), (Object[])object3);
            }
        } else {
            Channel channel = object2;
            object2 = ChannelEvent.RECV_ACK;
            Object[] objectArray4 = new Object[1];
            object3 = objectArray4;
            objectArray4[0] = object;
            channel.onPostState((ChannelEvent)((Object)object2), (Object[])object3);
        }
    }

    private void performSend(byte[] byArray, ChannelCallback channelCallback) {
        int n;
        Channel channel = object;
        channel.assertRuntime(false);
        if (channel.mCurrentState != ChannelState.IDLE) {
            channelCallback.onCallback(-3);
            return;
        }
        Channel channel2 = object;
        ((Channel)object).mCurrentState = ChannelState.READY;
        ((Channel)object).mChannelCallback = (ChannelCallback)ProxyUtils.getUIProxy(channelCallback);
        ((Channel)object).mTotalBytes = n = byArray.length;
        ((Channel)object).mFrameCount = ((Channel)object).getFrameCount(n);
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((Channel)object).getLogTag();
        objectArray2[1] = ((Channel)object).mTotalBytes;
        objectArray[2] = ((Channel)object).mFrameCount;
        BluetoothLog.v(WtUtil.format("%s: totalBytes = %d, frameCount = %d", objectArray2));
        ((Channel)object).mBytesToWrite = Arrays.copyOf(byArray, byArray.length + 2);
        Object object = ((Channel)object).mBytesToWrite;
        int n2 = byArray.length;
        System.arraycopy(CRC16.get(byArray), 0, object, n2, 2);
        channel2.sendStartFlowPacket();
    }

    private String getLogTag() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Channel.class.getSimpleName();
        objectArray[1] = BluetoothContext.getCurrentMethodName();
        return WtUtil.format("%s.%s", objectArray2);
    }

    private int getFrameCount(int n) {
        return (n + 2 - 1) / 18 + 1;
    }

    private void startTimer() {
        this.startTimer(5000L);
    }

    private void startExceptionTimer() {
        Timer.TimerCallback timerCallback;
        Timer.TimerCallback timerCallback2 = timerCallback;
        timerCallback = new Timer.TimerCallback(TIMER_EXCEPTION){

            @Override
            public void onTimerCallback() throws TimeoutException {
                throw new TimeoutException();
            }
        };
        this.startTimer(5000L, timerCallback2);
    }

    private void startTimer(long l) {
        Channel channel = timerCallback;
        Timer.TimerCallback timerCallback = channel.mTimeoutHandler;
        channel.startTimer(l, timerCallback);
    }

    private void startTimer(long l, Timer.TimerCallback objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray[0] = this.getLogTag();
        objectArray3[1] = l;
        BluetoothLog.v(WtUtil.format("%s: duration = %d", objectArray));
        Timer.start((Timer.TimerCallback)objectArray2, l);
    }

    private void stopTimer() {
        BluetoothLog.v(this.getLogTag());
        Timer.stop();
    }

    private boolean isTimerOn() {
        return Timer.isRunning();
    }

    private boolean isExceptionTimerOn() {
        return TIMER_EXCEPTION.equals(Timer.getName());
    }

    private boolean checkCRC(byte[] byArray, byte[] byArray2) {
        return ByteUtils.equals(byArray2, CRC16.get(byArray));
    }

    public static /* synthetic */ int access$302(Channel channel, int n) {
        channel.mLastSync = n;
        return n;
    }

    public static /* synthetic */ int access$102(Channel channel, int n) {
        channel.mCurrentSync = n;
        return n;
    }

    public static /* synthetic */ int access$502(Channel channel, int n) {
        channel.mFrameCount = n;
        return n;
    }

    @Override
    public final void onRead(byte[] byArray) {
        this.mChannel.onRead(byArray);
    }

    @Override
    public final void send(byte[] byArray, ChannelCallback channelCallback) {
        String string;
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        String string2 = string;
        string = new String(byArray);
        objectArray2[0] = string2;
        BluetoothLog.e(WtUtil.format(">>> send %s", objectArray3));
        objectArray.mChannel.send(byArray, channelCallback);
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] objectArray) {
        ProxyBulk proxyBulk;
        ProxyBulk proxyBulk2 = proxyBulk;
        proxyBulk = new ProxyBulk(object, method, objectArray);
        ((Channel)((Object)proxyBulk2)).mWorkerHandler.obtainMessage(0, (Object)proxyBulk2).sendToTarget();
        return true;
    }

    public class RecvCallback
    implements Runnable {
        public byte[] bytes;

        public RecvCallback(byte[] byArray) {
            this.bytes = byArray;
        }

        @Override
        public void run() {
            Channel.this.onRecv(this.bytes);
        }
    }

    public class WriteCallback
    implements ChannelCallback {
        public ChannelCallback callback;

        public WriteCallback(ChannelCallback channelCallback) {
            this.callback = channelCallback;
        }

        @Override
        public void onCallback(int n) {
            if (channelCallback.Channel.this.isExceptionTimerOn()) {
                channelCallback.Channel.this.stopTimer();
            }
            ChannelCallback channelCallback = channelCallback.callback;
            channelCallback.Channel.this.mWorkerHandler.obtainMessage(1, n, 0, (Object)channelCallback).sendToTarget();
        }
    }
}

