/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.beacon;

import com.tuya.sdk.blelib.beacon.BeaconItem;
import com.tuya.sdk.blelib.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class BeaconParser {
    public byte[] bytes;
    public ByteBuffer mByteBuffer;

    public BeaconParser(BeaconItem beaconItem) {
        this(beaconItem.bytes);
    }

    public BeaconParser(byte[] byArray) {
        this.bytes = byArray;
        this.mByteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static List<BeaconItem> parseBeacon(byte[] byArray) {
        BeaconItem beaconItem;
        ArrayList<BeaconItem> arrayList;
        ArrayList<BeaconItem> arrayList2 = arrayList;
        arrayList = new ArrayList<BeaconItem>();
        for (int i = 0; i < byArray.length && (beaconItem = BeaconParser.parse(byArray, i)) != null; i += beaconItem.len + 1) {
            arrayList2.add(beaconItem);
        }
        return arrayList2;
    }

    public static BeaconItem parse(byte[] byArray, int n) {
        int n2;
        BeaconItem beaconItem = null;
        if (byArray.length - n >= 2 && (n2 = byArray[n]) > 0) {
            byte by = byArray[n + 1];
            if ((n += 2) < byArray.length) {
                BeaconItem beaconItem2;
                beaconItem = beaconItem2;
                beaconItem2 = new BeaconItem();
                int n3 = n + n2 - 2;
                if (n3 >= byArray.length) {
                    n3 = byArray.length - 1;
                }
                beaconItem.type = by & 0xFF;
                beaconItem.len = n2;
                beaconItem.bytes = ByteUtils.getBytes(byArray, n, n3);
            }
        }
        return beaconItem;
    }

    public void setPosition(int n) {
        this.mByteBuffer.position(n);
    }

    public int readByte() {
        return this.mByteBuffer.get() & 0xFF;
    }

    public int readShort() {
        return this.mByteBuffer.getShort() & 0xFFFF;
    }

    public boolean getBit(int n, int n2) {
        return (n & 1 << n2) != 0;
    }
}

