/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib;

import android.app.PendingIntent;
import android.bluetooth.le.ScanSettings;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.tuya.sdk.blelib.IBluetoothService;
import com.tuya.sdk.blelib.IResponse;
import com.tuya.sdk.blelib.connect.BleConnectManager;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.search.BluetoothSearchManager;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import java.util.ArrayList;
import java.util.UUID;

public class BluetoothServiceImpl
extends IBluetoothService.Stub
implements Handler.Callback {
    public static volatile BluetoothServiceImpl sInstance;
    public Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothServiceImpl getInstance() {
        if (sInstance != null) return sInstance;
        Class<BluetoothServiceImpl> clazz = BluetoothServiceImpl.class;
        synchronized (BluetoothServiceImpl.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BluetoothServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void callBluetoothApi(int n, Bundle bundle, final IResponse iResponse) throws RemoteException {
        BleGeneralResponse bleGeneralResponse;
        BleGeneralResponse bleGeneralResponse2 = bleGeneralResponse;
        bleGeneralResponse = new BleGeneralResponse(){

            @Override
            public void onResponse(int n, Bundle bundle) {
                if (iResponse != null) {
                    if (bundle == null) {
                        Bundle bundle2;
                        bundle = bundle2;
                        bundle2 = new Bundle();
                    }
                    try {
                        iResponse.onResponse(n, bundle);
                    }
                    catch (Throwable throwable) {
                        BluetoothLog.e(throwable);
                    }
                }
            }
        };
        Message message = this.mHandler.obtainMessage(n, (Object)bleGeneralResponse2);
        Bundle bundle2 = bundle;
        bundle2.setClassLoader(BluetoothServiceImpl.class.getClassLoader());
        message.setData(bundle2);
        message.sendToTarget();
    }

    public boolean handleMessage(Message object) {
        Message message = object;
        BluetoothServiceImpl bluetoothServiceImpl = message.getData();
        object = bluetoothServiceImpl.getString("extra.mac");
        UUID uUID = (UUID)bluetoothServiceImpl.getSerializable("extra.service.uuid");
        UUID uUID2 = (UUID)bluetoothServiceImpl.getSerializable("extra.character.uuid");
        UUID uUID3 = (UUID)bluetoothServiceImpl.getSerializable("extra.descriptor.uuid");
        byte[] byArray = bluetoothServiceImpl.getByteArray("extra.byte.value");
        int n = bluetoothServiceImpl.getInt("extra.mtu", 0);
        BleGeneralResponse bleGeneralResponse = (BleGeneralResponse)message.obj;
        int n2 = message.what;
        block0 : switch (n2) {
            default: {
                switch (n2) {
                    default: {
                        break block0;
                    }
                    case 27: {
                        BluetoothSearchManager.stopScan((PendingIntent)bluetoothServiceImpl.getParcelable("extra.scan.intent"));
                        break block0;
                    }
                    case 26: {
                        ArrayList arrayList = bluetoothServiceImpl.getParcelableArrayList("extra.scan.filters");
                        BluetoothServiceImpl bluetoothServiceImpl2 = bluetoothServiceImpl;
                        bluetoothServiceImpl = (ScanSettings)bluetoothServiceImpl2.getParcelable("extra.scan.setting");
                        BluetoothSearchManager.startScan(arrayList, (ScanSettings)bluetoothServiceImpl, (PendingIntent)bluetoothServiceImpl2.getParcelable("extra.scan.intent"));
                        break block0;
                    }
                    case 25: {
                        BleConnectManager.requestPriority((String)object, bluetoothServiceImpl.getInt("extra.priority", 0));
                        break block0;
                    }
                    case 24: {
                        BleConnectManager.discoveryService((String)object, bleGeneralResponse);
                        break block0;
                    }
                    case 23: {
                        BleConnectManager.onlyDisconnect((String)object);
                        break block0;
                    }
                    case 22: {
                        BleConnectManager.notifyMesh((String)object, uUID, uUID2, bleGeneralResponse);
                        break block0;
                    }
                    case 21: {
                        BleConnectManager.refreshCache((String)object);
                        break block0;
                    }
                    case 20: 
                }
                BleConnectManager.clearRequest((String)object, bluetoothServiceImpl.getInt("extra.type", 0));
                break;
            }
            case 14: {
                BleConnectManager.writeDescriptor((String)object, uUID, uUID2, uUID3, byArray, bleGeneralResponse);
                break;
            }
            case 13: {
                BleConnectManager.readDescriptor((String)object, uUID, uUID2, uUID3, bleGeneralResponse);
                break;
            }
            case 12: {
                BluetoothSearchManager.stopSearch();
                break;
            }
            case 11: {
                BluetoothSearchManager.search((SearchRequest)bluetoothServiceImpl.getParcelable("extra.request"), bleGeneralResponse);
                break;
            }
            case 10: {
                BleConnectManager.indicate((String)object, uUID, uUID2, bleGeneralResponse);
                break;
            }
            case 9: {
                BleConnectManager.configMtu((String)object, n, bleGeneralResponse);
                break;
            }
            case 8: {
                BleConnectManager.readRssi((String)object, bleGeneralResponse);
                break;
            }
            case 7: {
                BleConnectManager.unnotify((String)object, uUID, uUID2, bleGeneralResponse);
                break;
            }
            case 6: {
                BleConnectManager.notify((String)object, uUID, uUID2, bleGeneralResponse);
                break;
            }
            case 5: {
                BleConnectManager.writeNoRsp((String)object, uUID, uUID2, byArray, bleGeneralResponse);
                break;
            }
            case 4: {
                BleConnectManager.write((String)object, uUID, uUID2, byArray, bleGeneralResponse);
                break;
            }
            case 3: {
                BleConnectManager.read((String)object, uUID, uUID2, bleGeneralResponse);
                break;
            }
            case 2: {
                BleConnectManager.disconnect((String)object);
                break;
            }
            case 1: {
                BleConnectManager.connect((String)object, (BleConnectOptions)bluetoothServiceImpl.getParcelable("extra.options"), bleGeneralResponse);
            }
        }
        return true;
    }
}

