/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib;

import android.app.PendingIntent;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import com.tuya.sdk.blelib.BluetoothService;
import com.tuya.sdk.blelib.BluetoothServiceImpl;
import com.tuya.sdk.blelib.ContextAgent;
import com.tuya.sdk.blelib.IBluetoothClient;
import com.tuya.sdk.blelib.IBluetoothService;
import com.tuya.sdk.blelib.SyncOperate;
import com.tuya.sdk.blelib.connect.BleConnectManager;
import com.tuya.sdk.blelib.connect.listener.BleConnectStatusListener;
import com.tuya.sdk.blelib.connect.listener.BluetoothStateListener;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.response.BleConnectResponse;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.connect.response.BleMtuResponse;
import com.tuya.sdk.blelib.connect.response.BleNotifyResponse;
import com.tuya.sdk.blelib.connect.response.BleReadResponse;
import com.tuya.sdk.blelib.connect.response.BleReadRssiResponse;
import com.tuya.sdk.blelib.connect.response.BleUnnotifyResponse;
import com.tuya.sdk.blelib.connect.response.BleWriteResponse;
import com.tuya.sdk.blelib.connect.response.BluetoothResponse;
import com.tuya.sdk.blelib.model.BleGattProfile;
import com.tuya.sdk.blelib.receiver.BluetoothReceiver;
import com.tuya.sdk.blelib.receiver.listener.BleCharacterChangeListener;
import com.tuya.sdk.blelib.receiver.listener.BleConnectStatusChangeListener;
import com.tuya.sdk.blelib.receiver.listener.BluetoothBondListener;
import com.tuya.sdk.blelib.receiver.listener.BluetoothBondStateChangeListener;
import com.tuya.sdk.blelib.receiver.listener.BluetoothStateChangeListener;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.response.SearchResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.ListUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import com.tuya.sdk.blelib.utils.proxy.ProxyBulk;
import com.tuya.sdk.blelib.utils.proxy.ProxyInterceptor;
import com.tuya.sdk.blelib.utils.proxy.ProxyUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

public class BluetoothClientImpl
implements IBluetoothClient,
ProxyInterceptor,
Handler.Callback {
    public static final int MSG_INVOKE_PROXY = 1;
    public static final int MSG_REG_RECEIVER = 2;
    public static final String TAG = BluetoothClientImpl.class.getSimpleName();
    public static volatile IBluetoothClient sInstance;
    public Context mContext;
    public volatile IBluetoothService mBluetoothService;
    public CountDownLatch mCountDownLatch;
    public final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            1 v0 = this;
            BluetoothLog.v(WtUtil.format("onServiceConnected", new Object[0]));
            BluetoothClientImpl.access$002(v0.BluetoothClientImpl.this, IBluetoothService.Stub.asInterface(iBinder));
            v0.BluetoothClientImpl.this.notifyBluetoothManagerReady();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            BluetoothLog.v(WtUtil.format("onServiceDisconnected", new Object[0]));
            BluetoothClientImpl.access$002(BluetoothClientImpl.this, null);
        }
    };
    public HandlerThread mWorkerThread;
    public Handler mWorkerHandler;
    public HashMap<String, HashMap<String, List<BleNotifyResponse>>> mNotifyResponses;
    public HashMap<String, List<BleConnectStatusListener>> mConnectStatusListeners;
    public List<BluetoothStateListener> mBluetoothStateListeners;
    public List<BluetoothBondListener> mBluetoothBondListeners;

    public BluetoothClientImpl(Context context) {
        this.mContext = context.getApplicationContext();
        ContextAgent.getInstance().setContext(this.mContext);
        this.mWorkerThread = new HandlerThread(TAG);
        this.mWorkerThread.start();
        this.mWorkerHandler = new Handler(this.mWorkerThread.getLooper(), (Handler.Callback)this);
        this.mNotifyResponses = new HashMap();
        this.mConnectStatusListeners = new HashMap();
        this.mBluetoothStateListeners = new LinkedList<BluetoothStateListener>();
        this.mBluetoothBondListeners = new LinkedList<BluetoothBondListener>();
        this.mWorkerHandler.obtainMessage(2).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothClient getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<BluetoothClientImpl> clazz = BluetoothClientImpl.class;
        synchronized (BluetoothClientImpl.class) {
            BluetoothClientImpl bluetoothClientImpl;
            if (sInstance != null) return sInstance;
            BluetoothClientImpl bluetoothClientImpl2 = bluetoothClientImpl;
            sInstance = (IBluetoothClient)ProxyUtils.getProxy((Object)new BluetoothClientImpl(context), IBluetoothClient.class, (ProxyInterceptor)bluetoothClientImpl2, true, false);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private IBluetoothService getBluetoothService() {
        if (this.mBluetoothService == null) {
            this.bindServiceSync();
        }
        return this.mBluetoothService;
    }

    private void bindServiceSync() {
        Intent intent;
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        BluetoothLog.v(WtUtil.format("bindServiceSync", new Object[0]));
        bluetoothClientImpl.mCountDownLatch = new CountDownLatch(1);
        Intent intent2 = intent;
        intent2();
        intent.setClass(this.mContext, BluetoothService.class);
        if (bluetoothClientImpl.mContext.bindService(intent2, this.mConnection, 1)) {
            BluetoothLog.v(WtUtil.format("BluetoothService registered", new Object[0]));
            this.waitBluetoothManagerReady();
        } else {
            BluetoothLog.v(WtUtil.format("BluetoothService not registered", new Object[0]));
            this.mBluetoothService = BluetoothServiceImpl.getInstance();
        }
    }

    private void saveNotifyListener(String object, UUID uUID, UUID uUID2, BleNotifyResponse bleNotifyResponse) {
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        HashMap<Object, Object> hashMap = bluetoothClientImpl.mNotifyResponses.get(object);
        if (hashMap == null) {
            HashMap<Object, Object> hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap<Object, Object>();
            ((BluetoothClientImpl)this).mNotifyResponses.put((String)object, hashMap);
        }
        if ((object = (List)hashMap.get(this = ((BluetoothClientImpl)this).generateCharacterKey(uUID, uUID2))) == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            hashMap.put(this, object);
        }
        object.add(bleNotifyResponse);
    }

    private void removeNotifyListener(String object, UUID uUID, UUID uUID2) {
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        object = bluetoothClientImpl.mNotifyResponses.get(object);
        if (object != null) {
            ((HashMap)object).remove(this.generateCharacterKey(uUID, uUID2));
        }
    }

    private void clearNotifyListener(String string) {
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        bluetoothClientImpl.mNotifyResponses.remove(string);
    }

    private String generateCharacterKey(UUID uUID, UUID uUID2) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = uUID;
        objectArray[1] = uUID2;
        return WtUtil.format("%s_%s", objectArray2);
    }

    /*
     * Unable to fully structure code
     */
    private void safeCallBluetoothApi(int var1_1, Bundle var2_2, BluetoothResponse var3_3) {
        block5: {
            v0 = this;
            v0.checkRuntime(true);
            this = v0.getBluetoothService();
            BluetoothLog.v(WtUtil.format("IBluetoothService = %s", new Object[]{this}));
            if (this == null) ** GOTO lbl14
            if (var2_2 != null) ** GOTO lbl12
            var2_2 = v1;
            try {
                v1 = new Bundle();
lbl12:
                // 2 sources

                this.callBluetoothApi(var1_1, var2_2, var3_3);
                break block5;
lbl14:
                // 1 sources

                var3_3.onResponse(-6, null);
            }
            catch (Throwable v2) {
                BluetoothLog.e(v2);
            }
        }
    }

    private void notifyBluetoothManagerReady() {
        CountDownLatch countDownLatch = this.mCountDownLatch;
        if (countDownLatch != null) {
            countDownLatch.countDown();
            this.mCountDownLatch = null;
        }
    }

    private void waitBluetoothManagerReady() {
        block3: {
            if (this.mCountDownLatch == null) break block3;
            try {
                this.mCountDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void registerBluetoothReceiver() {
        this.checkRuntime(true);
        BluetoothReceiver.getInstance().register(new BluetoothStateChangeListener(){

            @Override
            public void onBluetoothStateChanged(int n, int n2) {
                18 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                v0.BluetoothClientImpl.this.dispatchBluetoothStateChanged(n2);
            }
        });
        BluetoothReceiver.getInstance().register(new BluetoothBondStateChangeListener(){

            @Override
            public void onBondStateChanged(String string, int n) {
                19 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                v0.BluetoothClientImpl.this.dispatchBondStateChanged(string, n);
            }
        });
        BluetoothReceiver.getInstance().register(new BleConnectStatusChangeListener(){

            @Override
            public void onConnectStatusChanged(String string, int n) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (n == 32) {
                    BluetoothClientImpl.this.clearNotifyListener(string);
                }
                BluetoothClientImpl.this.dispatchConnectionStatus(string, n);
            }
        });
        BluetoothReceiver.getInstance().register(new BleCharacterChangeListener(){

            @Override
            public void onCharacterChanged(String string, UUID uUID, UUID uUID2, byte[] byArray) {
                21 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                v0.BluetoothClientImpl.this.dispatchCharacterNotify(string, uUID, uUID2, byArray);
            }
        });
    }

    private void dispatchCharacterNotify(String object, UUID uUID, UUID uUID2, byte[] byArray) {
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        object = bluetoothClientImpl.mNotifyResponses.get(object);
        if (object != null && (this = (List)((HashMap)object).get(((BluetoothClientImpl)this).generateCharacterKey(uUID, uUID2))) != null) {
            for (int i = 0; i < this.size(); ++i) {
                BleNotifyResponse bleNotifyResponse = (BleNotifyResponse)this.get(i);
                byte[] byArray2 = new byte[byArray.length];
                int n = byArray.length;
                System.arraycopy(byArray, 0, byArray2, 0, n);
                bleNotifyResponse.onNotify(uUID, uUID2, byArray2);
            }
        }
    }

    private void dispatchConnectionStatus(String string, int n) {
        BluetoothClientImpl bluetoothClientImpl = iterator;
        bluetoothClientImpl.checkRuntime(true);
        Iterator iterator = bluetoothClientImpl.mConnectStatusListeners.get(string);
        if (!ListUtils.isEmpty(iterator)) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((BleConnectStatusListener)iterator.next()).invokeSync(string, n);
            }
        }
    }

    private void dispatchBluetoothStateChanged(int n) {
        ((BluetoothClientImpl)this).checkRuntime(true);
        if (n == 10 || n == 12) {
            for (BluetoothStateListener bluetoothStateListener : ((BluetoothClientImpl)this).mBluetoothStateListeners) {
                Object[] objectArray = new Object[1];
                int n2 = 0;
                Boolean bl = n == 12;
                objectArray[n2] = bl;
                bluetoothStateListener.invokeSync(objectArray);
            }
        }
    }

    private void dispatchBondStateChanged(String string, int n) {
        BluetoothClientImpl bluetoothClientImpl = iterator;
        bluetoothClientImpl.checkRuntime(true);
        Iterator<BluetoothBondListener> iterator = bluetoothClientImpl.mBluetoothBondListeners.iterator();
        while (iterator.hasNext()) {
            ((BluetoothBondListener)iterator.next()).invokeSync(string, n);
        }
    }

    private void checkRuntime(boolean bl) {
        BluetoothClientImpl bluetoothClientImpl = bl ? bluetoothClientImpl.mWorkerHandler.getLooper() : Looper.getMainLooper();
        if (Looper.myLooper() == bluetoothClientImpl) {
            return;
        }
        throw new RuntimeException();
    }

    public static /* synthetic */ IBluetoothService access$002(BluetoothClientImpl bluetoothClientImpl, IBluetoothService iBluetoothService) {
        bluetoothClientImpl.mBluetoothService = iBluetoothService;
        return iBluetoothService;
    }

    @Override
    public void connect(String object, BleConnectOptions bleConnectOptions, final BleConnectResponse bleConnectResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putParcelable("extra.options", (Parcelable)bleConnectOptions);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                2 v0 = bleGattProfile;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                if (v0.bleConnectResponse != null) {
                    2 v1 = bleGattProfile;
                    Bundle bundle2 = bundle;
                    bundle2.setClassLoader(2.class.getClassLoader());
                    BleGattProfile bleGattProfile = (BleGattProfile)bundle2.getParcelable("extra.gatt.profile");
                    v1.bleConnectResponse.onResponse(n, bleGattProfile);
                }
            }
        };
        this.safeCallBluetoothApi(1, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void discoveryServices(String object, final BleConnectResponse bleConnectResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                3 v0 = bleGattProfile;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                if (v0.bleConnectResponse != null) {
                    3 v1 = bleGattProfile;
                    Bundle bundle2 = bundle;
                    bundle2.setClassLoader(3.class.getClassLoader());
                    BleGattProfile bleGattProfile = (BleGattProfile)bundle2.getParcelable("extra.gatt.profile");
                    v1.bleConnectResponse.onResponse(n, bleGattProfile);
                }
            }
        };
        this.safeCallBluetoothApi(24, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void requestConnectionPriority(int n, String string) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putString("extra.mac", string);
        bluetoothClientImpl2.putInt("extra.priority", n);
        bluetoothClientImpl.safeCallBluetoothApi(25, (Bundle)bluetoothClientImpl2, null);
    }

    @Override
    public void disconnect(String string) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putString("extra.mac", string);
        bluetoothClientImpl.safeCallBluetoothApi(2, (Bundle)bluetoothClientImpl2, null);
        bluetoothClientImpl.clearNotifyListener(string);
    }

    @Override
    public void onlyDisconnect(String string) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putString("extra.mac", string);
        bluetoothClientImpl.safeCallBluetoothApi(23, (Bundle)bluetoothClientImpl2, null);
        bluetoothClientImpl.clearNotifyListener(string);
    }

    @Override
    public void registerConnectStatusListener(String string, BleConnectStatusListener bleConnectStatusListener) {
        BluetoothClientImpl bluetoothClientImpl = this;
        bluetoothClientImpl.checkRuntime(true);
        ArrayList<BleConnectStatusListener> arrayList = bluetoothClientImpl.mConnectStatusListeners.get(string);
        if (arrayList == null) {
            ArrayList<BleConnectStatusListener> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<BleConnectStatusListener>();
            this.mConnectStatusListeners.put(string, arrayList);
        }
        if (bleConnectStatusListener != null && !arrayList.contains(bleConnectStatusListener)) {
            arrayList.add(bleConnectStatusListener);
        }
    }

    @Override
    public void unregisterConnectStatusListener(String string, BleConnectStatusListener bleConnectStatusListener) {
        BluetoothClientImpl bluetoothClientImpl = list;
        bluetoothClientImpl.checkRuntime(true);
        List<BleConnectStatusListener> list = bluetoothClientImpl.mConnectStatusListeners.get(string);
        if (bleConnectStatusListener != null && !ListUtils.isEmpty(list)) {
            list.remove(bleConnectStatusListener);
        }
    }

    @Override
    public void read(String object, UUID uUID, UUID uUID2, final BleReadResponse bleReadResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                4 v0 = bleReadResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleReadResponse bleReadResponse2 = v0.bleReadResponse;
                if (bleReadResponse2 != null) {
                    bleReadResponse2.onResponse(n, bundle.getByteArray("extra.byte.value"));
                }
            }
        };
        this.safeCallBluetoothApi(3, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void write(String object, UUID uUID, UUID uUID2, byte[] byArray, final BleWriteResponse bleWriteResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        bundle2.putByteArray("extra.byte.value", byArray);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                5 v0 = bleWriteResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleWriteResponse bleWriteResponse2 = v0.bleWriteResponse;
                if (bleWriteResponse2 != null) {
                    bleWriteResponse2.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(4, bundle2, (BluetoothResponse)object);
    }

    @Override
    public int write(String string, UUID uUID, UUID uUID2, byte[][] byArray, long l) {
        return new SyncOperate().withMac((String)string).withService((UUID)uUID).withCharacter((UUID)uUID2).withValue((byte[][])byArray).withPackTimeout((long)l).withAction((SyncOperate.OperateAction)new SyncOperate.OperateAction(){

            @Override
            public void action(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
                BleConnectManager.write(string, uUID, uUID2, byArray, bleGeneralResponse);
            }
        }).run().code;
    }

    @Override
    public int writeNoRsp(String string, UUID uUID, UUID uUID2, byte[][] byArray, int n) {
        return new SyncOperate().withMac((String)string).withService((UUID)uUID).withCharacter((UUID)uUID2).withValue((byte[][])byArray).withTryNum((int)3).withPackTimeout((long)((long)n)).withAction((SyncOperate.OperateAction)new SyncOperate.OperateAction(){

            @Override
            public void action(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
                BleConnectManager.writeNoRsp(string, uUID, uUID2, byArray, bleGeneralResponse);
            }
        }).run().code;
    }

    @Override
    public void readDescriptor(String object, UUID uUID, UUID uUID2, UUID uUID3, final BleReadResponse bleReadResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        bundle2.putSerializable("extra.descriptor.uuid", (Serializable)uUID3);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                8 v0 = bleReadResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleReadResponse bleReadResponse2 = v0.bleReadResponse;
                if (bleReadResponse2 != null) {
                    bleReadResponse2.onResponse(n, bundle.getByteArray("extra.byte.value"));
                }
            }
        };
        this.safeCallBluetoothApi(13, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void writeDescriptor(String object, UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray, final BleWriteResponse bleWriteResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        bundle2.putSerializable("extra.descriptor.uuid", (Serializable)uUID3);
        bundle2.putByteArray("extra.byte.value", byArray);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                9 v0 = bleWriteResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleWriteResponse bleWriteResponse2 = v0.bleWriteResponse;
                if (bleWriteResponse2 != null) {
                    bleWriteResponse2.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(14, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void writeNoRsp(String object, UUID uUID, UUID uUID2, byte[] byArray, final BleWriteResponse bleWriteResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        bundle2.putByteArray("extra.byte.value", byArray);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                10 v0 = bleWriteResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleWriteResponse bleWriteResponse2 = v0.bleWriteResponse;
                if (bleWriteResponse2 != null) {
                    bleWriteResponse2.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(5, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void notifyMesh(final String string, final UUID uUID, final UUID uUID2, final BleNotifyResponse bleNotifyResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", string);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        BluetoothResponse bluetoothResponse2 = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle object) {
                11 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                object = v0.bleNotifyResponse;
                if (object != null) {
                    if (n == 0) {
                        11 v1 = this;
                        String string2 = v1.string;
                        UUID uUID3 = v1.uUID;
                        UUID uUID22 = v1.uUID2;
                        BluetoothClientImpl.this.saveNotifyListener(string2, uUID3, uUID22, (BleNotifyResponse)object);
                    }
                    bleNotifyResponse.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(22, bundle2, bluetoothResponse2);
    }

    @Override
    public void notify(final String string, final UUID uUID, final UUID uUID2, final BleNotifyResponse bleNotifyResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", string);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        BluetoothResponse bluetoothResponse2 = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle object) {
                12 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                object = v0.bleNotifyResponse;
                if (object != null) {
                    if (n == 0) {
                        12 v1 = this;
                        String string2 = v1.string;
                        UUID uUID3 = v1.uUID;
                        UUID uUID22 = v1.uUID2;
                        BluetoothClientImpl.this.saveNotifyListener(string2, uUID3, uUID22, (BleNotifyResponse)object);
                    }
                    bleNotifyResponse.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(6, bundle2, bluetoothResponse2);
    }

    @Override
    public void unnotify(final String string, final UUID uUID, final UUID uUID2, final BleUnnotifyResponse bleUnnotifyResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", string);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        BluetoothResponse bluetoothResponse2 = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle object) {
                13 v0 = object2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                13 v1 = object2;
                Object object2 = v1.string;
                object = v1.uUID;
                UUID uUID3 = v1.uUID2;
                v0.BluetoothClientImpl.this.removeNotifyListener((String)object2, (UUID)object, uUID3);
                object2 = v0.bleUnnotifyResponse;
                if (object2 != null) {
                    object2.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(7, bundle2, bluetoothResponse2);
    }

    @Override
    public void indicate(final String string, final UUID uUID, final UUID uUID2, final BleNotifyResponse bleNotifyResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", string);
        bundle2.putSerializable("extra.service.uuid", (Serializable)uUID);
        bundle2.putSerializable("extra.character.uuid", (Serializable)uUID2);
        BluetoothResponse bluetoothResponse2 = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle object) {
                14 v0 = this;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                object = v0.bleNotifyResponse;
                if (object != null) {
                    if (n == 0) {
                        14 v1 = this;
                        String string2 = v1.string;
                        UUID uUID3 = v1.uUID;
                        UUID uUID22 = v1.uUID2;
                        BluetoothClientImpl.this.saveNotifyListener(string2, uUID3, uUID22, (BleNotifyResponse)object);
                    }
                    bleNotifyResponse.onResponse(n);
                }
            }
        };
        this.safeCallBluetoothApi(10, bundle2, bluetoothResponse2);
    }

    @Override
    public void unindicate(String string, UUID uUID, UUID uUID2, BleUnnotifyResponse bleUnnotifyResponse) {
        this.unnotify(string, uUID, uUID2, bleUnnotifyResponse);
    }

    @Override
    public void readRssi(String object, final BleReadRssiResponse bleReadRssiResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                15 v0 = bleReadRssiResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleReadRssiResponse bleReadRssiResponse2 = v0.bleReadRssiResponse;
                if (bleReadRssiResponse2 != null) {
                    bleReadRssiResponse2.onResponse(n, bundle.getInt("extra.rssi", 0));
                }
            }
        };
        this.safeCallBluetoothApi(8, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void configMtu(String object, int n, final BleMtuResponse bleMtuResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("extra.mac", (String)object);
        bundle2.putInt("extra.mtu", n);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                16 v0 = bleMtuResponse2;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                BleMtuResponse bleMtuResponse2 = v0.bleMtuResponse;
                if (bleMtuResponse2 != null) {
                    bleMtuResponse2.onResponse(n, bundle.getInt("extra.mtu"));
                }
            }
        };
        this.safeCallBluetoothApi(9, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void search(SearchRequest object, final SearchResponse searchResponse) {
        BluetoothResponse bluetoothResponse;
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putParcelable("extra.request", (Parcelable)object);
        object = bluetoothResponse;
        bluetoothResponse = new BluetoothResponse(){

            @Override
            public void onAsyncResponse(int n, Bundle bundle) {
                17 v0 = searchResult;
                v0.BluetoothClientImpl.this.checkRuntime(true);
                if (v0.searchResponse == null) {
                    return;
                }
                bundle.setClassLoader(17.class.getClassLoader());
                switch (n) {
                    default: {
                        throw new IllegalStateException("unknown code");
                    }
                    case 4: {
                        17 v1 = searchResult;
                        SearchResult searchResult = (SearchResult)bundle.getParcelable("extra.search.result");
                        v1.searchResponse.onDeviceFounded(searchResult);
                        break;
                    }
                    case 3: {
                        searchResult.searchResponse.onSearchCanceled();
                        break;
                    }
                    case 2: {
                        searchResult.searchResponse.onSearchStopped();
                        break;
                    }
                    case 1: {
                        searchResult.searchResponse.onSearchStarted();
                    }
                }
            }
        };
        this.safeCallBluetoothApi(11, bundle2, (BluetoothResponse)object);
    }

    @Override
    public void startScan(List<ScanFilter> list, ScanSettings scanSettings, PendingIntent pendingIntent) {
        ArrayList<ScanFilter> arrayList;
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        ArrayList<ScanFilter> arrayList2 = arrayList;
        arrayList = new ArrayList<ScanFilter>(list);
        new Bundle().putParcelableArrayList("extra.scan.filters", arrayList2);
        bluetoothClientImpl2.putParcelable("extra.scan.setting", (Parcelable)scanSettings);
        bluetoothClientImpl2.putParcelable("extra.scan.intent", (Parcelable)pendingIntent);
        bluetoothClientImpl.safeCallBluetoothApi(26, (Bundle)bluetoothClientImpl2, null);
    }

    @Override
    public void stopScan(PendingIntent pendingIntent) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putParcelable("extra.scan.intent", (Parcelable)pendingIntent);
        bluetoothClientImpl.safeCallBluetoothApi(27, (Bundle)bluetoothClientImpl2, null);
    }

    @Override
    public void stopSearch() {
        this.safeCallBluetoothApi(12, null, null);
    }

    @Override
    public void registerBluetoothStateListener(BluetoothStateListener bluetoothStateListener) {
        this.checkRuntime(true);
        if (bluetoothStateListener != null && !this.mBluetoothStateListeners.contains(bluetoothStateListener)) {
            this.mBluetoothStateListeners.add(bluetoothStateListener);
        }
    }

    @Override
    public void unregisterBluetoothStateListener(BluetoothStateListener bluetoothStateListener) {
        this.checkRuntime(true);
        if (bluetoothStateListener != null) {
            this.mBluetoothStateListeners.remove(bluetoothStateListener);
        }
    }

    @Override
    public void registerBluetoothBondListener(BluetoothBondListener bluetoothBondListener) {
        this.checkRuntime(true);
        if (bluetoothBondListener != null && !this.mBluetoothBondListeners.contains(bluetoothBondListener)) {
            this.mBluetoothBondListeners.add(bluetoothBondListener);
        }
    }

    @Override
    public void unregisterBluetoothBondListener(BluetoothBondListener bluetoothBondListener) {
        this.checkRuntime(true);
        if (bluetoothBondListener != null) {
            this.mBluetoothBondListeners.remove(bluetoothBondListener);
        }
    }

    @Override
    public void clearRequest(String string, int n) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putString("extra.mac", string);
        bluetoothClientImpl2.putInt("extra.type", n);
        bluetoothClientImpl.safeCallBluetoothApi(20, (Bundle)bluetoothClientImpl2, null);
    }

    @Override
    public void refreshCache(String string) {
        Bundle bundle;
        BluetoothClientImpl bluetoothClientImpl = bluetoothClientImpl2;
        bluetoothClientImpl.checkRuntime(true);
        BluetoothClientImpl bluetoothClientImpl2 = bundle;
        new Bundle().putString("extra.mac", string);
        bluetoothClientImpl.safeCallBluetoothApi(21, (Bundle)bluetoothClientImpl2, null);
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] objectArray) {
        ProxyBulk proxyBulk;
        ProxyBulk proxyBulk2 = proxyBulk;
        proxyBulk = new ProxyBulk(object, method, objectArray);
        ((BluetoothClientImpl)((Object)proxyBulk2)).mWorkerHandler.obtainMessage(1, (Object)proxyBulk2).sendToTarget();
        return true;
    }

    public boolean handleMessage(Message message) {
        int n = message.what;
        if (n != 1) {
            if (n == 2) {
                this.registerBluetoothReceiver();
            }
        } else {
            ProxyBulk.safeInvoke(message.obj);
        }
        return true;
    }
}

