/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib;

import android.app.PendingIntent;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import com.tuya.sdk.blelib.BluetoothClientImpl;
import com.tuya.sdk.blelib.IBluetoothClient;
import com.tuya.sdk.blelib.SyncOperate;
import com.tuya.sdk.blelib.connect.BleConnectManager;
import com.tuya.sdk.blelib.connect.listener.BleConnectStatusListener;
import com.tuya.sdk.blelib.connect.listener.BluetoothStateListener;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.response.BleConnectResponse;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.connect.response.BleMtuResponse;
import com.tuya.sdk.blelib.connect.response.BleNotifyResponse;
import com.tuya.sdk.blelib.connect.response.BleReadResponse;
import com.tuya.sdk.blelib.connect.response.BleReadRssiResponse;
import com.tuya.sdk.blelib.connect.response.BleUnnotifyResponse;
import com.tuya.sdk.blelib.connect.response.BleWriteResponse;
import com.tuya.sdk.blelib.receiver.listener.BluetoothBondListener;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blelib.search.response.SearchResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.ByteUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import com.tuya.sdk.blelib.utils.proxy.ProxyUtils;
import java.util.List;
import java.util.UUID;

public class BluetoothClient
implements IBluetoothClient {
    public IBluetoothClient mClient;

    public BluetoothClient(Context context) {
        if (context != null) {
            this.mClient = BluetoothClientImpl.getInstance(context);
            return;
        }
        throw new NullPointerException("Context null");
    }

    public void connect(String string, BleConnectResponse bleConnectResponse) {
        this.connect(string, null, bleConnectResponse);
    }

    @Override
    public void connect(String string, BleConnectOptions bleConnectOptions, BleConnectResponse bleConnectResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[1];
        Object object = objectArray2;
        objectArray2[0] = string;
        BluetoothLog.v(WtUtil.format("connect %s", object));
        object = (BleConnectResponse)ProxyUtils.getUIProxy(bleConnectResponse);
        objectArray.mClient.connect(string, bleConnectOptions, (BleConnectResponse)object);
    }

    @Override
    public void disconnect(String string) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        BluetoothLog.v(WtUtil.format("disconnect %s", objectArray3));
        objectArray.mClient.disconnect(string);
    }

    @Override
    public void onlyDisconnect(String string) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        BluetoothLog.v(WtUtil.format("close %s", objectArray3));
        objectArray.mClient.onlyDisconnect(string);
    }

    @Override
    public void discoveryServices(String string, BleConnectResponse bleConnectResponse) {
        this.mClient.discoveryServices(string, bleConnectResponse);
    }

    @Override
    public void requestConnectionPriority(int n, String string) {
        this.mClient.requestConnectionPriority(n, string);
    }

    @Override
    public void read(String string, UUID uUID, UUID uUID2, BleReadResponse bleReadResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("read character for %s: service = %s, character = %s", object));
        object = (BleReadResponse)ProxyUtils.getUIProxy(bleReadResponse);
        objectArray.mClient.read(string, uUID, uUID2, (BleReadResponse)object);
    }

    @Override
    public void write(String string, UUID uUID, UUID uUID2, byte[] byArray, BleWriteResponse bleWriteResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = object = objectArray2;
        objectArray3[0] = string;
        objectArray3[1] = uUID;
        object[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("write character for %s: service = %s, character = %s, value = %s", object));
        Object object = (BleWriteResponse)ProxyUtils.getUIProxy(bleWriteResponse);
        objectArray.mClient.write(string, uUID, uUID2, byArray, (BleWriteResponse)object);
    }

    @Override
    public int write(String string, UUID uUID, UUID uUID2, byte[][] byArray, long l) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = string;
        objectArray3[1] = uUID;
        objectArray[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("write character for %s: service = %s, character = %s, value = %s", objectArray));
        return new SyncOperate().withMac((String)string).withService((UUID)uUID).withCharacter((UUID)uUID2).withValue((byte[][])byArray).withPackTimeout((long)l).withAction((SyncOperate.OperateAction)new SyncOperate.OperateAction(){

            @Override
            public void action(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
                BleConnectManager.write(string, uUID, uUID2, byArray, bleGeneralResponse);
            }
        }).run().code;
    }

    @Override
    public int writeNoRsp(String string, UUID uUID, UUID uUID2, byte[][] byArray, int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = string;
        objectArray3[1] = uUID;
        objectArray[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("writeNoRsp %s: service = %s, character = %s, value = %s", objectArray));
        return new SyncOperate().withMac((String)string).withService((UUID)uUID).withCharacter((UUID)uUID2).withValue((byte[][])byArray).withTryNum((int)3).withPackTimeout((long)((long)n)).withAction((SyncOperate.OperateAction)new SyncOperate.OperateAction(){

            @Override
            public void action(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
                BleConnectManager.writeNoRsp(string, uUID, uUID2, byArray, bleGeneralResponse);
            }
        }).run().code;
    }

    @Override
    public void readDescriptor(String string, UUID uUID, UUID uUID2, UUID uUID3, BleReadResponse bleReadResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("readDescriptor for %s: service = %s, character = %s", object));
        object = (BleReadResponse)ProxyUtils.getUIProxy(bleReadResponse);
        objectArray.mClient.readDescriptor(string, uUID, uUID2, uUID3, (BleReadResponse)object);
    }

    @Override
    public void writeDescriptor(String string, UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray, BleWriteResponse bleWriteResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("writeDescriptor for %s: service = %s, character = %s", object));
        object = (BleWriteResponse)ProxyUtils.getUIProxy(bleWriteResponse);
        objectArray.mClient.writeDescriptor(string, uUID, uUID2, uUID3, byArray, (BleWriteResponse)object);
    }

    @Override
    public void writeNoRsp(String string, UUID uUID, UUID uUID2, byte[] byArray, BleWriteResponse bleWriteResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = object = objectArray2;
        objectArray3[0] = string;
        objectArray3[1] = uUID;
        object[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("writeNoRsp %s: service = %s, character = %s, value = %s", object));
        Object object = (BleWriteResponse)ProxyUtils.getUIProxy(bleWriteResponse);
        objectArray.mClient.writeNoRsp(string, uUID, uUID2, byArray, (BleWriteResponse)object);
    }

    @Override
    public void notify(String string, UUID uUID, UUID uUID2, BleNotifyResponse bleNotifyResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("notify %s: service = %s, character = %s", object));
        object = (BleNotifyResponse)ProxyUtils.getUIProxy(bleNotifyResponse);
        objectArray.mClient.notify(string, uUID, uUID2, (BleNotifyResponse)object);
    }

    @Override
    public void notifyMesh(String string, UUID uUID, UUID uUID2, BleNotifyResponse bleNotifyResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("notify %s: service = %s, character = %s", object));
        object = (BleNotifyResponse)ProxyUtils.getUIProxy(bleNotifyResponse);
        objectArray.mClient.notifyMesh(string, uUID, uUID2, (BleNotifyResponse)object);
    }

    @Override
    public void unnotify(String string, UUID uUID, UUID uUID2, BleUnnotifyResponse bleUnnotifyResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("unnotify %s: service = %s, character = %s", object));
        object = (BleUnnotifyResponse)ProxyUtils.getUIProxy(bleUnnotifyResponse);
        objectArray.mClient.unnotify(string, uUID, uUID2, (BleUnnotifyResponse)object);
    }

    @Override
    public void indicate(String string, UUID uUID, UUID uUID2, BleNotifyResponse bleNotifyResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("indicate %s: service = %s, character = %s", object));
        object = (BleNotifyResponse)ProxyUtils.getUIProxy(bleNotifyResponse);
        objectArray.mClient.indicate(string, uUID, uUID2, (BleNotifyResponse)object);
    }

    @Override
    public void unindicate(String string, UUID uUID, UUID uUID2, BleUnnotifyResponse bleUnnotifyResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = uUID;
        objectArray2[2] = uUID2;
        BluetoothLog.v(WtUtil.format("indicate %s: service = %s, character = %s", object));
        object = (BleUnnotifyResponse)ProxyUtils.getUIProxy(bleUnnotifyResponse);
        objectArray.mClient.unindicate(string, uUID, uUID2, (BleUnnotifyResponse)object);
    }

    @Override
    public void readRssi(String string, BleReadRssiResponse bleReadRssiResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[1];
        Object object = objectArray2;
        objectArray2[0] = string;
        BluetoothLog.v(WtUtil.format("readRssi %s", object));
        object = (BleReadRssiResponse)ProxyUtils.getUIProxy(bleReadRssiResponse);
        objectArray.mClient.readRssi(string, (BleReadRssiResponse)object);
    }

    @Override
    public void configMtu(String string, int n, BleMtuResponse bleMtuResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[2];
        Object object = objectArray2;
        object[0] = string;
        objectArray2[1] = n;
        BluetoothLog.v(WtUtil.format("configMtu %s: mtu = %s ", object));
        object = (BleMtuResponse)ProxyUtils.getUIProxy(bleMtuResponse);
        objectArray.mClient.configMtu(string, n, (BleMtuResponse)object);
    }

    @Override
    public void search(SearchRequest searchRequest, SearchResponse searchResponse) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[1];
        Object object = objectArray2;
        objectArray2[0] = searchRequest;
        BluetoothLog.v(WtUtil.format("search %s", object));
        object = (SearchResponse)ProxyUtils.getUIProxy(searchResponse);
        objectArray.mClient.search(searchRequest, (SearchResponse)object);
    }

    @Override
    public void stopSearch() {
        BluetoothLog.v(WtUtil.format("stopSearch", new Object[0]));
        this.mClient.stopSearch();
    }

    @Override
    public void startScan(List<ScanFilter> list, ScanSettings scanSettings, PendingIntent pendingIntent) {
        this.mClient.startScan(list, scanSettings, pendingIntent);
    }

    @Override
    public void stopScan(PendingIntent pendingIntent) {
        this.mClient.stopScan(pendingIntent);
    }

    @Override
    public void registerConnectStatusListener(String string, BleConnectStatusListener bleConnectStatusListener) {
        this.mClient.registerConnectStatusListener(string, bleConnectStatusListener);
    }

    @Override
    public void unregisterConnectStatusListener(String string, BleConnectStatusListener bleConnectStatusListener) {
        this.mClient.unregisterConnectStatusListener(string, bleConnectStatusListener);
    }

    @Override
    public void registerBluetoothStateListener(BluetoothStateListener bluetoothStateListener) {
        this.mClient.registerBluetoothStateListener(bluetoothStateListener);
    }

    @Override
    public void unregisterBluetoothStateListener(BluetoothStateListener bluetoothStateListener) {
        this.mClient.unregisterBluetoothStateListener(bluetoothStateListener);
    }

    @Override
    public void registerBluetoothBondListener(BluetoothBondListener bluetoothBondListener) {
        this.mClient.registerBluetoothBondListener(bluetoothBondListener);
    }

    @Override
    public void unregisterBluetoothBondListener(BluetoothBondListener bluetoothBondListener) {
        this.mClient.unregisterBluetoothBondListener(bluetoothBondListener);
    }

    public int getConnectStatus(String string) {
        return BluetoothUtils.getConnectStatus(string);
    }

    public boolean isBluetoothOpened() {
        return BluetoothUtils.isBluetoothEnabled();
    }

    public boolean openBluetooth() {
        return BluetoothUtils.openBluetooth();
    }

    public boolean closeBluetooth() {
        return BluetoothUtils.closeBluetooth();
    }

    public boolean isBleSupported() {
        return BluetoothUtils.isBleSupported();
    }

    public int getBondState(String string) {
        return BluetoothUtils.getBondState(string);
    }

    @Override
    public void clearRequest(String string, int n) {
        this.mClient.clearRequest(string, n);
    }

    @Override
    public void refreshCache(String string) {
        this.mClient.refreshCache(string);
    }
}

