/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.ble.core.manager;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.tuya.sdk.ble.core.bean.BLEScanDevBean;
import com.tuya.sdk.ble.core.connect.bean.AuthKeyBean;
import com.tuya.sdk.ble.core.packet.bean.Reps;
import com.tuya.sdk.ble.core.packet.bean.Ret;
import com.tuya.sdk.ble.core.packet.bean.UnbindForceRep;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.response.BleConnectResponse;
import com.tuya.sdk.blelib.connect.response.BleNotifyResponse;
import com.tuya.sdk.blelib.connect.response.BleWriteResponse;
import com.tuya.sdk.blelib.model.BleGattCharacter;
import com.tuya.sdk.blelib.model.BleGattProfile;
import com.tuya.sdk.blelib.model.BleGattService;
import com.tuya.sdk.bluetooth.OooO0o0;
import com.tuya.sdk.bluetooth.OooOOOo;
import com.tuya.sdk.bluetooth.Oooo0o;
import com.tuya.sdk.bluetooth.Oooo0oO;
import com.tuya.sdk.bluetooth.Oooo0oo;
import com.tuya.sdk.bluetooth.OoooOo0;
import com.tuya.sdk.bluetooth.OoooOoo;
import com.tuya.sdk.bluetooth.Ooooo00;
import com.tuya.sdk.bluetooth.o00000O0;
import com.tuya.sdk.bluetooth.o000OOo;
import com.tuya.sdk.bluetooth.o00oO0O;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.android.network.Business;
import com.tuya.smart.android.network.business.BusinessResult;
import com.tuya.smart.android.network.http.BusinessResponse;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

@RequiresApi(value=18)
public final class ResetDeviceManager
extends Enum<ResetDeviceManager>
implements Handler.Callback {
    public static final /* enum */ ResetDeviceManager INSTANCE;
    public static final String TAG = "ResetDeviceManager";
    public static final String CHARACTER_WRITE = "00002b11-0000-1000-8000-00805f9b34fb";
    public static final String CHARACTER_NOTIFY = "00002b10-0000-1000-8000-00805f9b34fb";
    public static final int MSG_TASK_SUCCESS = 101;
    public static final int MSG_TASK_ERROR = 102;
    public static final int MSG_RESET_DEVICE = 103;
    public static final int MSG_NOTIFY = 104;
    public static final /* synthetic */ ResetDeviceManager[] $VALUES;
    public final Semaphore mSemaphore;
    public ConcurrentHashMap<String, BLEScanDevBean> beanHashMap;
    public OooOOOo mBusiness;
    public UUID mWriteServiceUUid;
    public UUID mWriteCharacteristicUUid;
    public UUID mNotifyServiceUUid;
    public UUID mNotifyCharacteristicUUid;
    public Handler mHandler;
    public Oooo0oo mThread;
    public int receiveSize;
    public Ooooo00 unbindReceiver;
    public BleNotifyResponse mBleNotifyResponse;

    public static ResetDeviceManager[] values() {
        return (ResetDeviceManager[])$VALUES.clone();
    }

    public static ResetDeviceManager valueOf(String string) {
        return Enum.valueOf(ResetDeviceManager.class, string);
    }

    public ResetDeviceManager() {
        Oooo0oo oooo0oo;
        ResetDeviceManager resetDeviceManager = this;
        resetDeviceManager.mSemaphore = new Semaphore(1);
        resetDeviceManager.beanHashMap = new ConcurrentHashMap();
        resetDeviceManager.mBusiness = new OooOOOo();
        resetDeviceManager.mWriteServiceUUid = null;
        resetDeviceManager.mWriteCharacteristicUUid = null;
        resetDeviceManager.mNotifyServiceUUid = null;
        resetDeviceManager.mNotifyCharacteristicUUid = null;
        resetDeviceManager.receiveSize = 0;
        resetDeviceManager.mBleNotifyResponse = new BleNotifyResponse(){

            @Override
            public void onNotify(UUID uUID, UUID uUID2, byte[] byArray) {
                ResetDeviceManager.this.onNotificationReceived(byArray);
            }

            @Override
            public void onResponse(int n) {
                if (n == 0) {
                    ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(103, 200L);
                } else {
                    ResetDeviceManager.this.mHandler.sendEmptyMessage(102);
                }
            }
        };
        resetDeviceManager.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        Object object2 = object = oooo0oo;
        ((Oooo0oo)object2)();
        this.mThread = object2;
        oooo0oo.OooO00o(this);
        resetDeviceManager.mThread.start();
        resetDeviceManager.unbindReceiver = new Ooooo00();
    }

    private void requestDeviceBindStatus(final String string, final BLEScanDevBean bLEScanDevBean, final OooO0oO oooO0oO) {
        Business.ResultListener<Boolean> resultListener;
        L.d((String)TAG, (String)("requestDeviceBindStatus() called with: key = [" + string + "],  productId raw = " + o00oO0O.OooO0Oo(bLEScanDevBean.productIdRaw)));
        BLEScanDevBean bLEScanDevBean2 = bLEScanDevBean;
        Object object = bLEScanDevBean2.devUuId;
        String string2 = this.byteToString(bLEScanDevBean2.productIdRaw);
        String string3 = object;
        object = resultListener;
        resultListener = new Business.ResultListener<Boolean>(){

            public void OooO00o(BusinessResponse businessResponse, Boolean bl, String string2) {
                L.d((String)ResetDeviceManager.TAG, (String)(string + " onFailure() called with: businessResponse msg = [" + businessResponse.getErrorMsg() + "], code  = [" + businessResponse.getErrorCode()));
                OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "key=" + string + ",checkDeviceForReset: result  code = " + businessResponse.getErrorCode() + ",msg = " + businessResponse.getErrorMsg());
                ResetDeviceManager.this.beanHashMap.remove(string);
            }

            public void OooO0O0(BusinessResponse object, Boolean bl, String string2) {
                L.d((String)ResetDeviceManager.TAG, (String)("key=" + oooO0oO2.string + ",onSuccess() called with: businessResponse = [" + object + "], result = [" + bl + "], s2 = [" + string2 + "]"));
                OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForReset: success isReadyBind = " + bl);
                if (!bl.booleanValue()) {
                    OooO0O0 oooO0O0 = oooO0oO2;
                    object = oooO0O0.bLEScanDevBean;
                    oooO0oO2.ResetDeviceManager.this.mThread.OooO00o((BLEScanDevBean)object, oooO0O0.string);
                } else {
                    oooO0oO2.ResetDeviceManager.this.beanHashMap.remove(oooO0oO2.string);
                }
                OooO0oO oooO0oO2 = oooO0oO2.oooO0oO;
                if (oooO0oO2 != null) {
                    oooO0oO2.OooO00o(bl);
                }
            }
        };
        this.mBusiness.OooO00o(string3, string2, (Business.ResultListener<Boolean>)object);
    }

    private Boolean syncRequestDeviceBindStatus(String string, BLEScanDevBean bLEScanDevBean) {
        L.d((String)TAG, (String)("syncRequestDeviceBindStatus() called with: key = [" + string + "],  productId raw = " + o00oO0O.OooO0Oo(bLEScanDevBean.productIdRaw)));
        BLEScanDevBean bLEScanDevBean2 = bLEScanDevBean;
        BusinessResult<Boolean> businessResult = bLEScanDevBean2.devUuId;
        businessResult = this.mBusiness.OooO00o((String)businessResult, this.byteToString(bLEScanDevBean2.productIdRaw));
        if (businessResult.getBizResult() == null) {
            L.d((String)TAG, (String)(string + " onFailure() called with: businessResponse msg = [" + businessResult.getBizResponse().getErrorMsg() + "], code  = [" + businessResult.getBizResponse().getErrorCode()));
            OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "key=" + string + ",checkDeviceForReset: result  code = " + businessResult.getBizResponse().getErrorCode() + ",msg = " + businessResult.getBizResponse().getErrorMsg());
            this.beanHashMap.remove(string);
        } else {
            L.d((String)TAG, (String)("key=" + string + ",onSuccess() called with: businessResponse = [" + businessResult.getBizResponse() + "], result = [" + businessResult.getBizResult() + "], s2 = [" + businessResult.getApiName() + "]"));
            OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForReset: success isReadyBind = " + businessResult.getBizResult());
            if (!((Boolean)businessResult.getBizResult()).booleanValue()) {
                this.mThread.OooO00o(bLEScanDevBean, string);
            } else {
                this.beanHashMap.remove(string);
            }
        }
        return (Boolean)businessResult.getBizResult();
    }

    private void connectDevice() {
        BleConnectResponse bleConnectResponse;
        this.mSemaphore.tryAcquire();
        L.d((String)TAG, (String)("connectDevice() called address = " + this.mThread.OooO00o()));
        Object object = new BleConnectOptions.Builder().setConnectRetry(3).setConnectTimeout(10000).setServiceDiscoverRetry(3).setServiceDiscoverTimeout(3000).build();
        BleConnectOptions bleConnectOptions = object;
        object = bleConnectResponse;
        bleConnectResponse = new BleConnectResponse(){

            public void OooO00o(int n, BleGattProfile bleGattProfile) {
                L.d((String)ResetDeviceManager.TAG, (String)("connect onResponse code " + n));
                if (bleGattProfile == null) {
                    ResetDeviceManager.this.mHandler.sendEmptyMessage(102);
                } else {
                    ResetDeviceManager.this.initRemoteDeviceFrame(bleGattProfile.getServices());
                }
            }
        };
        Oooo0o.OooO0O0().OooO00o().connect(this.mThread.OooO00o(), bleConnectOptions, (BleConnectResponse)object);
    }

    private void initRemoteDeviceFrame(List<BleGattService> object) {
        L.d((String)TAG, (String)"initRemoteDeviceFrame...");
        object = object.iterator();
        while (object.hasNext()) {
            BleGattService bleGattService = (BleGattService)object.next();
            for (BleGattCharacter bleGattCharacter : bleGattService.getCharacters()) {
                if (bleGattCharacter.getUuid().toString().equals(CHARACTER_NOTIFY)) {
                    this.mNotifyServiceUUid = bleGattService.getUUID();
                    this.mNotifyCharacteristicUUid = bleGattCharacter.getUuid();
                    continue;
                }
                if (!bleGattCharacter.getUuid().toString().equals(CHARACTER_WRITE)) continue;
                this.mWriteServiceUUid = bleGattService.getUUID();
                this.mWriteCharacteristicUUid = bleGattCharacter.getUuid();
            }
        }
        if (this.mWriteServiceUUid != null && this.mWriteCharacteristicUUid != null && this.mNotifyServiceUUid != null && this.mNotifyCharacteristicUUid != null) {
            this.mHandler.sendEmptyMessageDelayed(104, 200L);
        } else {
            this.mHandler.sendEmptyMessage(102);
        }
    }

    private void notifyTaskError() {
        L.d((String)TAG, (String)"notifyTaskError() called");
        String string = this.mThread.OooO0Oo();
        if (string != null) {
            this.beanHashMap.remove(string);
        }
        ResetDeviceManager resetDeviceManager = this;
        resetDeviceManager.mSemaphore.release();
        resetDeviceManager.disconnectDevice();
        OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "\u3010ERROR\u3011reset unbind error");
    }

    private void notifyTaskSuccess() {
        L.d((String)TAG, (String)"notifyTaskSuccess() called");
        String string = this.mThread.OooO0Oo();
        if (string != null) {
            this.beanHashMap.remove(string);
        }
        ResetDeviceManager resetDeviceManager = this;
        resetDeviceManager.mSemaphore.release();
        resetDeviceManager.disconnectDevice();
        OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "\u3010SUCCESS\u3011reset unbind success");
    }

    private void disconnectDevice() {
        Oooo0o.OooO0O0().OooO00o().disconnect(this.mThread.OooO00o());
    }

    private void sendResetDeviceCode() {
        if (object.mThread.OooO0OO() != Oooo0oO.OooO0Oo && object.mThread.OooO0OO() != Oooo0oO.OooO0o0) {
            ResetDeviceManager resetDeviceManager = object;
            byte[] byArray = new byte[3];
            Object object = byArray;
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 99;
            resetDeviceManager.sendData((byte[])object);
        } else {
            object.getAuthKey();
        }
    }

    private void sendData(byte[] byArray) {
        BleWriteResponse bleWriteResponse;
        L.d((String)TAG, (String)("sendData... " + this.mThread.OooO00o() + ",code " + o000OOo.OooO00o(byArray)));
        ResetDeviceManager resetDeviceManager = this;
        Object object = resetDeviceManager.mThread.OooO00o();
        UUID uUID = resetDeviceManager.mWriteServiceUUid;
        UUID uUID2 = resetDeviceManager.mWriteCharacteristicUUid;
        String string = object;
        object = bleWriteResponse;
        bleWriteResponse = new BleWriteResponse(){

            @Override
            public void onResponse(int n) {
                L.d((String)ResetDeviceManager.TAG, (String)("sendData result code = [" + n + "]"));
                if (n == 0) {
                    ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(101, 1000L);
                } else {
                    ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(102, 100L);
                }
            }
        };
        Oooo0o.OooO0O0().OooO00o().write(string, uUID, uUID2, byArray, (BleWriteResponse)object);
    }

    private void getAuthKey() {
        this.mBusiness.OooO00o(this.mThread.OooO0O0(), new Business.ResultListener<AuthKeyBean>(){

            public void OooO00o(BusinessResponse businessResponse, AuthKeyBean authKeyBean, String string) {
                L.d((String)ResetDeviceManager.TAG, (String)("onFailure() called with: businessResponse = [" + businessResponse.getErrorCode() + "], s = [" + businessResponse.getErrorMsg() + "]"));
                ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(102, 100L);
            }

            public void OooO0O0(BusinessResponse businessResponse, AuthKeyBean authKeyBean, String string) {
                L.d((String)ResetDeviceManager.TAG, (String)("onSuccess() called with: businessResponse = [" + businessResponse + "], authKeyBean = [" + authKeyBean + "], s2 = [" + string + "]"));
                if (TextUtils.equals((CharSequence)authKeyBean.getErrorCode(), (CharSequence)"DEVICE_ALREADY_BIND")) {
                    string2.ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(102, 100L);
                } else {
                    AuthKeyBean authKeyBean2 = authKeyBean;
                    String string2 = authKeyBean2.encryptedAuthKey;
                    string2.ResetDeviceManager.this.sendUnBindCmd(string2, authKeyBean2.random);
                }
            }
        });
    }

    private void sendUnBindCmd(String object, String string) {
        byte[] byArray = o00000O0.OooO00o((String)object);
        object = byArray;
        this.unbindReceiver.OooO0OO((byte[])object);
        object = new byte[0];
        object = OoooOoo.OooO00o(1, 0, 20, (byte[])object, 0);
        byte[] byArray2 = OoooOoo.OooO00o(byArray, 1, o00000O0.OooO00o(string), (byte[])object);
        object = byArray2;
        int n = byArray2.length;
        byte[][] byArray3 = OoooOo0.OooO00o(2, (byte[])object, n);
        L.e((String)TAG, (String)("getDeviceInfo: send " + o000OOo.OooO00o((byte[])object)));
        this.receiveSize = 0;
        int n2 = byArray3.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray4 = byArray3[i];
            this.sendV2Data(byArray4, byArray3.length);
        }
    }

    private void sendV2Data(byte[] byArray, final int n) {
        BleWriteResponse bleWriteResponse;
        L.d((String)TAG, (String)("sendData... " + this.mThread.OooO00o() + ",code " + o000OOo.OooO00o(byArray)));
        ResetDeviceManager resetDeviceManager = this;
        Object object = resetDeviceManager.mThread.OooO00o();
        UUID uUID = resetDeviceManager.mWriteServiceUUid;
        UUID uUID2 = resetDeviceManager.mWriteCharacteristicUUid;
        String string = object;
        object = bleWriteResponse;
        bleWriteResponse = new BleWriteResponse(){

            @Override
            public void onResponse(int n2) {
                OooO0o oooO0o = this;
                L.d((String)ResetDeviceManager.TAG, (String)("sendData result code = [" + n2 + "]"));
                oooO0o.ResetDeviceManager.this.receiveSize++;
                if (oooO0o.n == ResetDeviceManager.this.receiveSize) {
                    if (n2 == 0) {
                        ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(101, 1000L);
                    } else {
                        ResetDeviceManager.this.mHandler.sendEmptyMessageDelayed(102, 100L);
                    }
                }
            }
        };
        Oooo0o.OooO0O0().OooO00o().write(string, uUID, uUID2, byArray, (BleWriteResponse)object);
    }

    private String byteToString(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (byArray != null && byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = byArray[i];
                stringBuilder2.append(String.format("%02X", objectArray2));
            }
        }
        return stringBuilder2.toString();
    }

    private void notifyCharacter() {
        ResetDeviceManager resetDeviceManager = object;
        Object object = resetDeviceManager.mThread.OooO00o();
        UUID uUID = resetDeviceManager.mNotifyServiceUUid;
        UUID uUID2 = resetDeviceManager.mNotifyCharacteristicUUid;
        BleNotifyResponse bleNotifyResponse = resetDeviceManager.mBleNotifyResponse;
        Oooo0o.OooO0O0().OooO00o().notify((String)object, uUID, uUID2, bleNotifyResponse);
    }

    /*
     * WARNING - void declaration
     */
    private void onNotificationReceived(byte[] byArray) {
        Ret ret;
        void var1_3;
        L.e((String)TAG, (String)("onNotificationReceived: " + o000OOo.OooO00o((byte[])var1_3)));
        if ((this.mThread.OooO0OO() == Oooo0oO.OooO0Oo || this.mThread.OooO0OO() == Oooo0oO.OooO0o0) && (ret = this.unbindReceiver.OooO00o((byte[])var1_3)) != null) {
            Reps reps;
            if (!ret.reps.success()) {
                L.e((String)TAG, (String)("onNotificationReceived: parse error " + ret));
            } else if (ret.code == 20 && (reps = ret.reps) instanceof UnbindForceRep) {
                if (((UnbindForceRep)reps).status) {
                    L.e((String)TAG, (String)"unbind success");
                } else {
                    L.e((String)TAG, (String)"unbind fail");
                }
            }
        }
    }

    static {
        ResetDeviceManager resetDeviceManager;
        ResetDeviceManager resetDeviceManager2 = resetDeviceManager;
        INSTANCE = new ResetDeviceManager();
        $VALUES = new ResetDeviceManager[]{resetDeviceManager2};
    }

    public synchronized void checkDeviceForReset(BLEScanDevBean bLEScanDevBean) {
        if (bLEScanDevBean != null && bLEScanDevBean.category == 100) {
            String string = bLEScanDevBean.address + this.byteToString(bLEScanDevBean.productIdRaw);
            if (this.beanHashMap.containsKey(string)) {
                OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForRest:  isChecking please wait. key = " + string);
                L.w((String)TAG, (String)("checkDeviceForRest:  already checked key = " + string));
                return;
            }
            this.beanHashMap.put(string, bLEScanDevBean);
            OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForReset: requestDeviceBindStatus= " + string);
            this.requestDeviceBindStatus(string, bLEScanDevBean, null);
            return;
        }
    }

    public synchronized void checkDeviceForReset(BLEScanDevBean bLEScanDevBean, OooO0oO oooO0oO) {
        if (bLEScanDevBean != null && bLEScanDevBean.category == 100) {
            String string = bLEScanDevBean.address + this.byteToString(bLEScanDevBean.productIdRaw);
            if (this.beanHashMap.containsKey(string)) {
                OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForRest:  isChecking please wait. key = " + string);
                L.w((String)TAG, (String)("checkDeviceForRest:  already checked key = " + string));
                return;
            }
            this.beanHashMap.put(string, bLEScanDevBean);
            OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "checkDeviceForReset: requestDeviceBindStatus= " + string);
            this.requestDeviceBindStatus(string, bLEScanDevBean, oooO0oO);
            return;
        }
    }

    public synchronized Boolean syncCheckDeviceForReset(BLEScanDevBean bLEScanDevBean) {
        if (bLEScanDevBean != null && bLEScanDevBean.category == 100) {
            String string = bLEScanDevBean.address + this.byteToString(bLEScanDevBean.productIdRaw);
            if (this.beanHashMap.containsKey(string)) {
                OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "syncCheckDeviceForReset:  isChecking please wait. key = " + string);
                L.w((String)TAG, (String)("checkDeviceForRest:  already checked key = " + string));
                return null;
            }
            this.beanHashMap.put(string, bLEScanDevBean);
            OooO0o0.OooO0Oo.OooO0O0("ble_unbind_info", "syncCheckDeviceForReset: requestDeviceBindStatus= " + string);
            return this.syncRequestDeviceBindStatus(string, bLEScanDevBean);
        }
        return null;
    }

    public void clear() {
        this.beanHashMap.clear();
    }

    public void resetDevice() throws InterruptedException {
        ResetDeviceManager resetDeviceManager = this;
        resetDeviceManager.connectDevice();
        resetDeviceManager.mSemaphore.acquire();
        resetDeviceManager.mSemaphore.release();
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            default: {
                break;
            }
            case 104: {
                this.notifyCharacter();
                break;
            }
            case 103: {
                this.sendResetDeviceCode();
                break;
            }
            case 102: {
                this.notifyTaskError();
                break;
            }
            case 101: {
                this.notifyTaskSuccess();
            }
        }
        return false;
    }

    public static interface OooO0oO {
        public void OooO00o(boolean var1);
    }
}

