/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rpc.data;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.facebook.rpc.data.ISerialize;
import com.facebook.rpc.data.SerializeParcelable;
import java.io.IOException;

public class SnapshotSerializer
extends SerializeParcelable
implements ISerialize {
    private int mFd = -1;
    private ParcelFileDescriptor mFileDescriptor;

    public SnapshotSerializer(String bundlePath, String dir, String serializeLevel, int fd) {
        super(bundlePath, dir, serializeLevel);
        this.mFd = fd;
    }

    public SnapshotSerializer(Parcel in) {
        super(in);
        this.mFileDescriptor = in.readFileDescriptor();
        if (this.mFileDescriptor != null) {
            try {
                this.mFd = this.mFileDescriptor.getFd();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToParcel(Parcel dest) {
        super.writeToParcel(dest);
        try {
            dest.writeFileDescriptor(ParcelFileDescriptor.fromFd((int)this.mFd).getFileDescriptor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getFd() {
        return this.mFd;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    @Override
    public int getActionType() {
        return 241;
    }
}

