/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.checkbox;

import android.content.Context;
import android.widget.CompoundButton;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.checkbox.ReactCheckBox;
import com.facebook.react.views.checkbox.ReactCheckBoxEvent;

public class ReactCheckBoxManager
extends SimpleViewManager<ReactCheckBox> {
    private static final String REACT_CLASS = "AndroidCheckBox";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = (ReactContext)buttonView.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactCheckBoxEvent(buttonView.getId(), isChecked));
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactCheckBox view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @Override
    protected ReactCheckBox createViewInstance(ThemedReactContext context) {
        ReactCheckBox view = new ReactCheckBox((Context)context);
        return view;
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactCheckBox view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="on")
    public void setOn(ReactCheckBox view, boolean on) {
        view.setOnCheckedChangeListener(null);
        view.setOn(on);
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }
}

