/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.toast;

import android.content.Context;
import android.widget.Toast;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="ToastAndroid")
public class ToastModule
extends ReactContextBaseJavaModule {
    private static final String DURATION_SHORT_KEY = "SHORT";
    private static final String DURATION_LONG_KEY = "LONG";
    private static final String GRAVITY_TOP_KEY = "TOP";
    private static final String GRAVITY_BOTTOM_KEY = "BOTTOM";
    private static final String GRAVITY_CENTER = "CENTER";

    public ToastModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "ToastAndroid";
    }

    @Override
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = MapBuilder.newHashMap();
        constants.put(DURATION_SHORT_KEY, 0);
        constants.put(DURATION_LONG_KEY, 1);
        constants.put(GRAVITY_TOP_KEY, 49);
        constants.put(GRAVITY_BOTTOM_KEY, 81);
        constants.put(GRAVITY_CENTER, 17);
        return constants;
    }

    @ReactMethod
    public void show(final String message, final int duration) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)ToastModule.this.getReactApplicationContext(), (CharSequence)message, (int)duration).show();
            }
        });
    }

    @ReactMethod
    public void showWithGravity(final String message, final int duration, final int gravity) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast toast = Toast.makeText((Context)ToastModule.this.getReactApplicationContext(), (CharSequence)message, (int)duration);
                toast.setGravity(gravity, 0, 0);
                toast.show();
            }
        });
    }

    @ReactMethod
    public void showWithGravityAndOffset(final String message, final int duration, final int gravity, final int xOffset, final int yOffset) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast toast = Toast.makeText((Context)ToastModule.this.getReactApplicationContext(), (CharSequence)message, (int)duration);
                toast.setGravity(gravity, xOffset, yOffset);
                toast.show();
            }
        });
    }
}

