/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.text.TextUtils;
import com.facebook.proguard.annotations.DoNotStrip;
import java.io.File;

@DoNotStrip
public class SerializeMetaInfo {
    private String mLevelTag;
    private String mSourcePath;

    public SerializeMetaInfo(String src, String levelTag) {
        this.mSourcePath = src;
        this.mLevelTag = levelTag;
    }

    String getSerializeLevel() {
        return "7.5.288." + this.mLevelTag;
    }

    String getSerializeDir() {
        File file = new File(this.mSourcePath);
        return file.getParent() + File.separator + "sz";
    }

    boolean requireInfoCheck() {
        if (TextUtils.isEmpty((CharSequence)this.mLevelTag)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mSourcePath)) {
            return false;
        }
        File file = new File(this.mSourcePath);
        return file.exists();
    }

    boolean isCodeCacheValidate() {
        File file;
        return this.requireInfoCheck() && (file = new File(this.getCodeCacheFile())).exists() && file.length() > 0L;
    }

    String getCodeCacheFile() {
        return this.getSerializeDir() + File.separator + this.getSerializeLevel() + "_cc";
    }

    String getSnapshotFile() {
        return this.getSerializeDir() + File.separator + this.getSerializeLevel() + "_ss";
    }

    boolean isSnapShotValidated() {
        File file;
        return this.requireInfoCheck() && (file = new File(this.getSnapshotFile())).exists() && file.length() > 0L;
    }
}

