/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rpc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.facebook.react.bridge.ReactContext;
import com.facebook.rpc.SerializeBinderProxy;
import com.facebook.rpc.data.ISerialize;
import com.facebook.rpc.data.SerializeParcelable;
import com.facebook.rpc.data.SnapshotSerializer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;

public class JSSerializeServiceProxy {
    private SerializeBinderProxy mProxy;
    private ServiceConnection mConnect;
    @Nullable
    private Activity mActivity;
    private ConcurrentLinkedQueue<ISerialize> mActionQueue = new ConcurrentLinkedQueue();

    void startService(final ReactContext context) {
        if (context.getCurrentActivity() != null && !context.getCurrentActivity().isFinishing()) {
            this.mActivity = context.getCurrentActivity();
            context.runOnUiQueueThread(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setClassName((Context)context.getCurrentActivity(), "com.facebook.rpc.JSSerializeServer");
                    if (JSSerializeServiceProxy.this.mConnect != null) {
                        context.getCurrentActivity().unbindService(JSSerializeServiceProxy.this.mConnect);
                    } else {
                        JSSerializeServiceProxy.this.mConnect = new ServiceConnection(){

                            public void onServiceConnected(ComponentName name, IBinder service) {
                                ArrayList actions = new ArrayList(JSSerializeServiceProxy.this.mActionQueue);
                                JSSerializeServiceProxy.this.mProxy = new SerializeBinderProxy(service);
                                for (int i = 0; i < actions.size(); ++i) {
                                    JSSerializeServiceProxy.this.dispatchAction((ISerialize)actions.get(i));
                                }
                                JSSerializeServiceProxy.this.mActionQueue.clear();
                            }

                            public void onServiceDisconnected(ComponentName name) {
                                JSSerializeServiceProxy.this.mProxy = null;
                            }
                        };
                        context.getCurrentActivity().bindService(intent, JSSerializeServiceProxy.this.mConnect, 1);
                    }
                }
            });
        }
    }

    public void unbindService() {
        if (this.mConnect != null && this.mActivity != null) {
            try {
                this.mActivity.unbindService(this.mConnect);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void dispatchAction(ISerialize actionData) {
        switch (actionData.getActionType()) {
            case 241: {
                this.mProxy.doSnapshot((SnapshotSerializer)actionData);
                break;
            }
            case 240: {
                this.mProxy.doCodeCache((SerializeParcelable)actionData);
            }
        }
    }

    public void doAction(ReactContext context, ISerialize data) {
        if (this.mProxy != null) {
            this.dispatchAction(data);
        } else if (context != null && context.hasActiveCatalystInstance() && context.hasCurrentActivity()) {
            this.mActionQueue.add(data);
            this.startService(context);
        }
    }
}

