/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.views.view.ReactDrawableHelper;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.yoga.YogaConstants;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="RCTView")
public class ReactViewManager
extends ViewGroupManager<ReactViewGroup> {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3, 4, 5};
    private static final int CMD_HOTSPOT_UPDATE = 1;
    private static final int CMD_SET_PRESSED = 2;

    @ReactProp(name="accessible")
    public void setAccessible(ReactViewGroup view, boolean accessible) {
        view.setFocusable(accessible);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius", "borderTopStartRadius", "borderTopEndRadius", "borderBottomStartRadius", "borderBottomEndRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactViewGroup view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius) && borderRadius < 0.0f) {
            borderRadius = Float.NaN;
        }
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactViewGroup view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactProp(name="hitSlop")
    public void setHitSlop(ReactViewGroup view, @Nullable ReadableMap hitSlop) {
        if (hitSlop == null) {
            view.setHitSlopRect(null);
        } else {
            view.setHitSlopRect(new Rect(hitSlop.hasKey("left") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("left")) : 0, hitSlop.hasKey("top") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("top")) : 0, hitSlop.hasKey("right") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("right")) : 0, hitSlop.hasKey("bottom") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("bottom")) : 0));
        }
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(ReactViewGroup view, @Nullable String pointerEventsStr) {
        if (pointerEventsStr == null) {
            view.setPointerEvents(PointerEvents.AUTO);
        } else {
            PointerEvents pointerEvents = PointerEvents.valueOf(pointerEventsStr.toUpperCase(Locale.US).replace("-", "_"));
            view.setPointerEvents(pointerEvents);
        }
    }

    @ReactProp(name="nativeBackgroundAndroid")
    public void setNativeBackground(ReactViewGroup view, @Nullable ReadableMap bg) {
        view.setTranslucentBackgroundDrawable(bg == null ? null : ReactDrawableHelper.createDrawableFromJSDescription(view.getContext(), bg));
    }

    @ReactProp(name="nativeForegroundAndroid")
    @TargetApi(value=23)
    public void setNativeForeground(ReactViewGroup view, @Nullable ReadableMap fg) {
        view.setForeground(fg == null ? null : ReactDrawableHelper.createDrawableFromJSDescription(view.getContext(), fg));
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactViewGroup view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="needsOffscreenAlphaCompositing")
    public void setNeedsOffscreenAlphaCompositing(ReactViewGroup view, boolean needsOffscreenAlphaCompositing) {
        view.setNeedsOffscreenAlphaCompositing(needsOffscreenAlphaCompositing);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactViewGroup view, int index, float width) {
        if (!YogaConstants.isUndefined(width) && width < 0.0f) {
            width = Float.NaN;
        }
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor", "borderStartColor", "borderEndColor"}, customType="Color")
    public void setBorderColor(ReactViewGroup view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @ReactProp(name="collapsable")
    public void setCollapsable(ReactViewGroup view, boolean collapsable) {
    }

    @ReactProp(name="overflow")
    public void setOverflow(ReactViewGroup view, String overflow) {
        view.setOverflow(overflow);
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactViewGroup createViewInstance(ThemedReactContext context) {
        return new ReactViewGroup((Context)context);
    }

    @Override
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("hotspotUpdate", 1, "setPressed", 2);
    }

    @Override
    public void receiveCommand(ReactViewGroup root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                if (args == null || args.size() != 2) {
                    throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'updateHotspot' command");
                }
                if (Build.VERSION.SDK_INT < 21) break;
                float x = PixelUtil.toPixelFromDIP(args.getDouble(0));
                float y = PixelUtil.toPixelFromDIP(args.getDouble(1));
                root.drawableHotspotChanged(x, y);
                break;
            }
            case 2: {
                if (args == null || args.size() != 1) {
                    throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'setPressed' command");
                }
                root.setPressed(args.getBoolean(0));
            }
        }
    }

    @Override
    public void addView(ReactViewGroup parent, View child, int index) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            parent.addViewWithSubviewClippingEnabled(child, index);
        } else if (parent != null && parent.getChildCount() >= index) {
            parent.addView(child, index);
        }
    }

    @Override
    public int getChildCount(ReactViewGroup parent) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return parent.getAllChildrenCount();
        }
        return parent.getChildCount();
    }

    @Override
    public View getChildAt(ReactViewGroup parent, int index) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return parent.getChildAtWithSubviewClippingEnabled(index);
        }
        return parent.getChildAt(index);
    }

    @Override
    public void removeViewAt(ReactViewGroup parent, int index) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            View child = this.getChildAt(parent, index);
            if (child.getParent() != null) {
                parent.removeView(child);
            }
            parent.removeViewWithSubviewClippingEnabled(child);
        } else {
            parent.removeViewAt(index);
        }
    }

    @Override
    public void removeAllViews(ReactViewGroup parent) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            parent.removeAllViewsWithSubviewClippingEnabled();
        } else {
            parent.removeAllViews();
        }
    }
}

