/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.YogaNodePool;
import com.facebook.react.uimanager.annotations.ReactPropertyHolder;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConfig;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

@ReactPropertyHolder
public class ReactShadowNodeImpl
implements ReactShadowNode<ReactShadowNodeImpl> {
    private int mReactTag;
    @Nullable
    private String mViewClassName;
    @Nullable
    private ReactShadowNodeImpl mRootNode;
    @Nullable
    private ThemedReactContext mThemedContext;
    private boolean mShouldNotifyOnLayout;
    private boolean mNodeUpdated = true;
    @Nullable
    private ArrayList<ReactShadowNodeImpl> mChildren;
    @Nullable
    private ReactShadowNodeImpl mParent;
    private boolean mIsLayoutOnly;
    private int mTotalNativeChildren = 0;
    @Nullable
    private ReactShadowNodeImpl mNativeParent;
    @Nullable
    private ArrayList<ReactShadowNodeImpl> mNativeChildren;
    private int mScreenX;
    private int mScreenY;
    private int mScreenWidth;
    private int mScreenHeight;
    private final Spacing mDefaultPadding = new Spacing(0.0f);
    private final float[] mPadding = new float[9];
    private final boolean[] mPaddingIsPercent = new boolean[9];
    private final YogaNode mYogaNode;
    private static YogaConfig sYogaConfig;

    public ReactShadowNodeImpl() {
        if (!this.isVirtual()) {
            YogaNode node = YogaNodePool.get().acquire();
            if (sYogaConfig == null) {
                sYogaConfig = new YogaConfig();
                sYogaConfig.setPointScaleFactor(0.0f);
                sYogaConfig.setUseLegacyStretchBehaviour(true);
            }
            if (node == null) {
                node = new YogaNode(sYogaConfig);
            }
            this.mYogaNode = node;
            Arrays.fill(this.mPadding, Float.NaN);
        } else {
            this.mYogaNode = null;
        }
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return false;
    }

    @Override
    public boolean isYogaLeafNode() {
        return this.isMeasureDefined();
    }

    @Override
    public final String getViewClass() {
        return (String)Assertions.assertNotNull((Object)this.mViewClassName);
    }

    @Override
    public final boolean hasUpdates() {
        return this.mNodeUpdated || this.hasNewLayout() || this.isDirty();
    }

    @Override
    public final void markUpdateSeen() {
        this.mNodeUpdated = false;
        if (this.hasNewLayout()) {
            this.markLayoutSeen();
        }
    }

    @Override
    public void markUpdated() {
        if (this.mNodeUpdated) {
            return;
        }
        this.mNodeUpdated = true;
        ReactShadowNodeImpl parent = this.getParent();
        if (parent != null) {
            parent.markUpdated();
        }
    }

    @Override
    public final boolean hasUnseenUpdates() {
        return this.mNodeUpdated;
    }

    @Override
    public void dirty() {
        if (!this.isVirtual()) {
            this.mYogaNode.dirty();
        }
    }

    @Override
    public final boolean isDirty() {
        return this.mYogaNode != null && this.mYogaNode.isDirty();
    }

    @Override
    public void addChildAt(ReactShadowNodeImpl child, int i) {
        if (child.getParent() != null) {
            throw new IllegalViewOperationException("Tried to add child that already has a parent! Remove it from its parent first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(4);
        }
        this.mChildren.add(i, child);
        child.mParent = this;
        if (this.mYogaNode != null && !this.isYogaLeafNode()) {
            YogaNode childYogaNode = child.mYogaNode;
            if (childYogaNode == null) {
                throw new RuntimeException("Cannot add a child that doesn't have a YogaNode to a parent without a measure function! (Trying to add a '" + child.getClass().getSimpleName() + "' to a '" + this.getClass().getSimpleName() + "')");
            }
            this.mYogaNode.addChildAt(childYogaNode, i);
        }
        this.markUpdated();
        int increase = child.isLayoutOnly() ? child.getTotalNativeChildren() : 1;
        this.mTotalNativeChildren += increase;
        this.updateNativeChildrenCountInParent(increase);
    }

    @Override
    public ReactShadowNodeImpl removeChildAt(int i) {
        if (this.mChildren == null) {
            throw new ArrayIndexOutOfBoundsException("Index " + i + " out of bounds: node has no children");
        }
        ReactShadowNodeImpl removed = this.mChildren.remove(i);
        removed.mParent = null;
        if (this.mYogaNode != null && !this.isYogaLeafNode()) {
            this.mYogaNode.removeChildAt(i);
        }
        this.markUpdated();
        int decrease = removed.isLayoutOnly() ? removed.getTotalNativeChildren() : 1;
        this.mTotalNativeChildren -= decrease;
        this.updateNativeChildrenCountInParent(-decrease);
        return removed;
    }

    @Override
    public final int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public final ReactShadowNodeImpl getChildAt(int i) {
        if (this.mChildren == null) {
            throw new ArrayIndexOutOfBoundsException("Index " + i + " out of bounds: node has no children");
        }
        return this.mChildren.get(i);
    }

    @Override
    public final int indexOf(ReactShadowNodeImpl child) {
        return this.mChildren == null ? -1 : this.mChildren.indexOf(child);
    }

    @Override
    public void removeAndDisposeAllChildren() {
        if (this.getChildCount() == 0) {
            return;
        }
        int decrease = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            if (this.mYogaNode != null && !this.isYogaLeafNode()) {
                this.mYogaNode.removeChildAt(i);
            }
            ReactShadowNodeImpl toRemove = this.getChildAt(i);
            toRemove.mParent = null;
            toRemove.dispose();
            decrease += toRemove.isLayoutOnly() ? toRemove.getTotalNativeChildren() : 1;
        }
        ((ArrayList)Assertions.assertNotNull(this.mChildren)).clear();
        this.markUpdated();
        this.mTotalNativeChildren -= decrease;
        this.updateNativeChildrenCountInParent(-decrease);
    }

    private void updateNativeChildrenCountInParent(int delta) {
        if (this.mIsLayoutOnly) {
            for (ReactShadowNodeImpl parent = this.getParent(); parent != null; parent = parent.getParent()) {
                parent.mTotalNativeChildren += delta;
                if (!parent.isLayoutOnly()) break;
            }
        }
    }

    @Override
    public void onBeforeLayout() {
    }

    @Override
    public final void updateProperties(ReactStylesDiffMap props) {
        ViewManagerPropertyUpdater.updateProps(this, props);
        this.onAfterUpdateTransaction();
    }

    @Override
    public void onAfterUpdateTransaction() {
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
    }

    @Override
    public boolean dispatchUpdates(float absoluteX, float absoluteY, UIViewOperationQueue uiViewOperationQueue, NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        if (this.mNodeUpdated) {
            this.onCollectExtraUpdates(uiViewOperationQueue);
        }
        if (this.hasNewLayout()) {
            float layoutX = this.getLayoutX();
            float layoutY = this.getLayoutY();
            int newAbsoluteLeft = Math.round(absoluteX + layoutX);
            int newAbsoluteTop = Math.round(absoluteY + layoutY);
            int newAbsoluteRight = Math.round(absoluteX + layoutX + this.getLayoutWidth());
            int newAbsoluteBottom = Math.round(absoluteY + layoutY + this.getLayoutHeight());
            int newScreenX = Math.round(layoutX);
            int newScreenY = Math.round(layoutY);
            int newScreenWidth = newAbsoluteRight - newAbsoluteLeft;
            int newScreenHeight = newAbsoluteBottom - newAbsoluteTop;
            boolean layoutHasChanged = newScreenX != this.mScreenX || newScreenY != this.mScreenY || newScreenWidth != this.mScreenWidth || newScreenHeight != this.mScreenHeight;
            this.mScreenX = newScreenX;
            this.mScreenY = newScreenY;
            this.mScreenWidth = newScreenWidth;
            this.mScreenHeight = newScreenHeight;
            if (layoutHasChanged) {
                nativeViewHierarchyOptimizer.handleUpdateLayout(this);
            }
            return layoutHasChanged;
        }
        return false;
    }

    @Override
    public final int getReactTag() {
        return this.mReactTag;
    }

    @Override
    public void setReactTag(int reactTag) {
        this.mReactTag = reactTag;
    }

    @Override
    public final ReactShadowNodeImpl getRootNode() {
        return (ReactShadowNodeImpl)Assertions.assertNotNull((Object)this.mRootNode);
    }

    @Override
    public final void setRootNode(ReactShadowNodeImpl rootNode) {
        this.mRootNode = rootNode;
    }

    @Override
    public final void setViewClassName(String viewClassName) {
        this.mViewClassName = viewClassName;
    }

    @Override
    @Nullable
    public final ReactShadowNodeImpl getParent() {
        return this.mParent;
    }

    @Override
    public final ThemedReactContext getThemedContext() {
        return (ThemedReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mThemedContext)));
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        this.mThemedContext = themedContext;
    }

    @Override
    public final boolean shouldNotifyOnLayout() {
        return this.mShouldNotifyOnLayout;
    }

    @Override
    public void calculateLayout() {
        this.mYogaNode.calculateLayout(Float.NaN, Float.NaN);
    }

    @Override
    public final boolean hasNewLayout() {
        return this.mYogaNode != null && this.mYogaNode.hasNewLayout();
    }

    @Override
    public final void markLayoutSeen() {
        if (this.mYogaNode != null) {
            this.mYogaNode.markLayoutSeen();
        }
    }

    @Override
    public final void addNativeChildAt(ReactShadowNodeImpl child, int nativeIndex) {
        Assertions.assertCondition((!this.mIsLayoutOnly ? 1 : 0) != 0);
        Assertions.assertCondition((!child.mIsLayoutOnly ? 1 : 0) != 0);
        if (this.mNativeChildren == null) {
            this.mNativeChildren = new ArrayList(4);
        }
        this.mNativeChildren.add(nativeIndex, child);
        child.mNativeParent = this;
    }

    @Override
    public final ReactShadowNodeImpl removeNativeChildAt(int i) {
        Assertions.assertNotNull(this.mNativeChildren);
        ReactShadowNodeImpl removed = this.mNativeChildren.remove(i);
        removed.mNativeParent = null;
        return removed;
    }

    @Override
    public final void removeAllNativeChildren() {
        if (this.mNativeChildren != null) {
            for (int i = this.mNativeChildren.size() - 1; i >= 0; --i) {
                this.mNativeChildren.get((int)i).mNativeParent = null;
            }
            this.mNativeChildren.clear();
        }
    }

    @Override
    public final int getNativeChildCount() {
        return this.mNativeChildren == null ? 0 : this.mNativeChildren.size();
    }

    @Override
    public final int indexOfNativeChild(ReactShadowNodeImpl nativeChild) {
        Assertions.assertNotNull(this.mNativeChildren);
        return this.mNativeChildren.indexOf(nativeChild);
    }

    @Override
    @Nullable
    public final ReactShadowNodeImpl getNativeParent() {
        return this.mNativeParent;
    }

    @Override
    public final void setIsLayoutOnly(boolean isLayoutOnly) {
        Assertions.assertCondition((this.getParent() == null ? 1 : 0) != 0, (String)"Must remove from no opt parent first");
        Assertions.assertCondition((this.mNativeParent == null ? 1 : 0) != 0, (String)"Must remove from native parent first");
        Assertions.assertCondition((this.getNativeChildCount() == 0 ? 1 : 0) != 0, (String)"Must remove all native children first");
        this.mIsLayoutOnly = isLayoutOnly;
    }

    @Override
    public final boolean isLayoutOnly() {
        return this.mIsLayoutOnly;
    }

    @Override
    public final int getTotalNativeChildren() {
        return this.mTotalNativeChildren;
    }

    @Override
    public boolean isDescendantOf(ReactShadowNodeImpl ancestorNode) {
        boolean isDescendant = false;
        for (ReactShadowNodeImpl parentNode = this.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            if (parentNode != ancestorNode) continue;
            isDescendant = true;
            break;
        }
        return isDescendant;
    }

    @Override
    public void setLocalData(Object data) {
    }

    @Override
    public final int getNativeOffsetForChild(ReactShadowNodeImpl child) {
        int index = 0;
        boolean found = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ReactShadowNodeImpl current = this.getChildAt(i);
            if (child == current) {
                found = true;
                break;
            }
            index += current.isLayoutOnly() ? current.getTotalNativeChildren() : 1;
        }
        if (!found) {
            throw new RuntimeException("Child " + child.getReactTag() + " was not a child of " + this.mReactTag);
        }
        return index;
    }

    @Override
    public final float getLayoutX() {
        return this.mYogaNode.getLayoutX();
    }

    @Override
    public final float getLayoutY() {
        return this.mYogaNode.getLayoutY();
    }

    @Override
    public final float getLayoutWidth() {
        return this.mYogaNode.getLayoutWidth();
    }

    @Override
    public final float getLayoutHeight() {
        return this.mYogaNode.getLayoutHeight();
    }

    @Override
    public int getScreenX() {
        return this.mScreenX;
    }

    @Override
    public int getScreenY() {
        return this.mScreenY;
    }

    @Override
    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    @Override
    public final YogaDirection getLayoutDirection() {
        return this.mYogaNode.getLayoutDirection();
    }

    @Override
    public void setLayoutDirection(YogaDirection direction) {
        this.mYogaNode.setDirection(direction);
    }

    @Override
    public final YogaValue getStyleWidth() {
        return this.mYogaNode.getWidth();
    }

    @Override
    public void setStyleWidth(float widthPx) {
        this.mYogaNode.setWidth(widthPx);
    }

    @Override
    public void setStyleWidthPercent(float percent) {
        this.mYogaNode.setWidthPercent(percent);
    }

    @Override
    public void setStyleWidthAuto() {
        this.mYogaNode.setWidthAuto();
    }

    @Override
    public void setStyleMinWidth(float widthPx) {
        this.mYogaNode.setMinWidth(widthPx);
    }

    @Override
    public void setStyleMinWidthPercent(float percent) {
        this.mYogaNode.setMinWidthPercent(percent);
    }

    @Override
    public void setStyleMaxWidth(float widthPx) {
        this.mYogaNode.setMaxWidth(widthPx);
    }

    @Override
    public void setStyleMaxWidthPercent(float percent) {
        this.mYogaNode.setMaxWidthPercent(percent);
    }

    @Override
    public final YogaValue getStyleHeight() {
        return this.mYogaNode.getHeight();
    }

    @Override
    public void setStyleHeight(float heightPx) {
        this.mYogaNode.setHeight(heightPx);
    }

    @Override
    public void setStyleHeightPercent(float percent) {
        this.mYogaNode.setHeightPercent(percent);
    }

    @Override
    public void setStyleHeightAuto() {
        this.mYogaNode.setHeightAuto();
    }

    @Override
    public void setStyleMinHeight(float widthPx) {
        this.mYogaNode.setMinHeight(widthPx);
    }

    @Override
    public void setStyleMinHeightPercent(float percent) {
        this.mYogaNode.setMinHeightPercent(percent);
    }

    @Override
    public void setStyleMaxHeight(float widthPx) {
        this.mYogaNode.setMaxHeight(widthPx);
    }

    @Override
    public void setStyleMaxHeightPercent(float percent) {
        this.mYogaNode.setMaxHeightPercent(percent);
    }

    @Override
    public void setFlex(float flex) {
        this.mYogaNode.setFlex(flex);
    }

    @Override
    public void setFlexGrow(float flexGrow) {
        this.mYogaNode.setFlexGrow(flexGrow);
    }

    @Override
    public void setFlexShrink(float flexShrink) {
        this.mYogaNode.setFlexShrink(flexShrink);
    }

    @Override
    public void setFlexBasis(float flexBasis) {
        this.mYogaNode.setFlexBasis(flexBasis);
    }

    @Override
    public void setFlexBasisAuto() {
        this.mYogaNode.setFlexBasisAuto();
    }

    @Override
    public void setFlexBasisPercent(float percent) {
        this.mYogaNode.setFlexBasisPercent(percent);
    }

    @Override
    public void setStyleAspectRatio(float aspectRatio) {
        this.mYogaNode.setAspectRatio(aspectRatio);
    }

    @Override
    public void setFlexDirection(YogaFlexDirection flexDirection) {
        this.mYogaNode.setFlexDirection(flexDirection);
    }

    @Override
    public void setFlexWrap(YogaWrap wrap) {
        this.mYogaNode.setWrap(wrap);
    }

    @Override
    public void setAlignSelf(YogaAlign alignSelf) {
        this.mYogaNode.setAlignSelf(alignSelf);
    }

    @Override
    public void setAlignItems(YogaAlign alignItems) {
        this.mYogaNode.setAlignItems(alignItems);
    }

    @Override
    public void setAlignContent(YogaAlign alignContent) {
        this.mYogaNode.setAlignContent(alignContent);
    }

    @Override
    public void setJustifyContent(YogaJustify justifyContent) {
        this.mYogaNode.setJustifyContent(justifyContent);
    }

    @Override
    public void setOverflow(YogaOverflow overflow) {
        this.mYogaNode.setOverflow(overflow);
    }

    @Override
    public void setDisplay(YogaDisplay display) {
        this.mYogaNode.setDisplay(display);
    }

    @Override
    public void setMargin(int spacingType, float margin) {
        this.mYogaNode.setMargin(YogaEdge.fromInt(spacingType), margin);
    }

    @Override
    public void setMarginPercent(int spacingType, float percent) {
        this.mYogaNode.setMarginPercent(YogaEdge.fromInt(spacingType), percent);
    }

    @Override
    public void setMarginAuto(int spacingType) {
        this.mYogaNode.setMarginAuto(YogaEdge.fromInt(spacingType));
    }

    @Override
    public final float getPadding(int spacingType) {
        return this.mYogaNode.getLayoutPadding(YogaEdge.fromInt(spacingType));
    }

    @Override
    public final YogaValue getStylePadding(int spacingType) {
        return this.mYogaNode.getPadding(YogaEdge.fromInt(spacingType));
    }

    @Override
    public void setDefaultPadding(int spacingType, float padding) {
        this.mDefaultPadding.set(spacingType, padding);
        this.updatePadding();
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        this.mPadding[spacingType] = padding;
        this.mPaddingIsPercent[spacingType] = false;
        this.updatePadding();
    }

    @Override
    public void setPaddingPercent(int spacingType, float percent) {
        this.mPadding[spacingType] = percent;
        this.mPaddingIsPercent[spacingType] = !YogaConstants.isUndefined(percent);
        this.updatePadding();
    }

    private void updatePadding() {
        for (int spacingType = 0; spacingType <= 8; ++spacingType) {
            if (spacingType == 0 || spacingType == 2 || spacingType == 4 || spacingType == 5) {
                if (YogaConstants.isUndefined(this.mPadding[spacingType]) && YogaConstants.isUndefined(this.mPadding[6]) && YogaConstants.isUndefined(this.mPadding[8])) {
                    this.mYogaNode.setPadding(YogaEdge.fromInt(spacingType), this.mDefaultPadding.getRaw(spacingType));
                    continue;
                }
            } else if (spacingType == 1 || spacingType == 3) {
                if (YogaConstants.isUndefined(this.mPadding[spacingType]) && YogaConstants.isUndefined(this.mPadding[7]) && YogaConstants.isUndefined(this.mPadding[8])) {
                    this.mYogaNode.setPadding(YogaEdge.fromInt(spacingType), this.mDefaultPadding.getRaw(spacingType));
                    continue;
                }
            } else if (YogaConstants.isUndefined(this.mPadding[spacingType])) {
                this.mYogaNode.setPadding(YogaEdge.fromInt(spacingType), this.mDefaultPadding.getRaw(spacingType));
                continue;
            }
            if (this.mPaddingIsPercent[spacingType]) {
                this.mYogaNode.setPaddingPercent(YogaEdge.fromInt(spacingType), this.mPadding[spacingType]);
                continue;
            }
            this.mYogaNode.setPadding(YogaEdge.fromInt(spacingType), this.mPadding[spacingType]);
        }
    }

    @Override
    public void setBorder(int spacingType, float borderWidth) {
        this.mYogaNode.setBorder(YogaEdge.fromInt(spacingType), borderWidth);
    }

    @Override
    public void setPosition(int spacingType, float position) {
        this.mYogaNode.setPosition(YogaEdge.fromInt(spacingType), position);
    }

    @Override
    public void setPositionPercent(int spacingType, float percent) {
        this.mYogaNode.setPositionPercent(YogaEdge.fromInt(spacingType), percent);
    }

    @Override
    public void setPositionType(YogaPositionType positionType) {
        this.mYogaNode.setPositionType(positionType);
    }

    @Override
    public void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        this.mShouldNotifyOnLayout = shouldNotifyOnLayout;
    }

    @Override
    public void setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mYogaNode.setBaselineFunction(baselineFunction);
    }

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        if (measureFunction == null ^ this.mYogaNode.isMeasureDefined() && this.getChildCount() != 0) {
            throw new RuntimeException("Since a node with a measure function does not add any native yoga children, it's not safe to transition to/from having a measure function unless a node has no children");
        }
        this.mYogaNode.setMeasureFunction(measureFunction);
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mYogaNode.isMeasureDefined();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringWithIndentation(sb, 0);
        return sb.toString();
    }

    private void toStringWithIndentation(StringBuilder result, int level) {
        int i;
        for (i = 0; i < level; ++i) {
            result.append("__");
        }
        result.append(this.getClass().getSimpleName()).append(" ");
        if (this.mYogaNode != null) {
            result.append(this.getLayoutWidth()).append(",").append(this.getLayoutHeight());
        } else {
            result.append("(virtual node)");
        }
        result.append("\n");
        if (this.getChildCount() == 0) {
            return;
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).toStringWithIndentation(result, level + 1);
        }
    }

    @Override
    public void dispose() {
        if (this.mYogaNode != null) {
            this.mYogaNode.reset();
            YogaNodePool.get().release(this.mYogaNode);
        }
    }
}

