/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.core.util.Pools;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import javax.annotation.Nullable;

public class DynamicFromMap
implements Dynamic {
    private static final Pools.SimplePool<DynamicFromMap> sPool = new Pools.SimplePool(10);
    @Nullable
    private ReadableMap mMap;
    @Nullable
    private String mName;

    private DynamicFromMap() {
    }

    public static DynamicFromMap create(ReadableMap map, String name) {
        DynamicFromMap dynamic = (DynamicFromMap)sPool.acquire();
        if (dynamic == null) {
            dynamic = new DynamicFromMap();
        }
        dynamic.mMap = map;
        dynamic.mName = name;
        return dynamic;
    }

    @Override
    public void recycle() {
        this.mMap = null;
        this.mName = null;
        sPool.release((Object)this);
    }

    @Override
    public boolean isNull() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.isNull(this.mName);
    }

    @Override
    public boolean asBoolean() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getBoolean(this.mName);
    }

    @Override
    public double asDouble() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getDouble(this.mName);
    }

    @Override
    public int asInt() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getInt(this.mName);
    }

    @Override
    public String asString() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getString(this.mName);
    }

    @Override
    public ReadableArray asArray() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getArray(this.mName);
    }

    @Override
    public ReadableMap asMap() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getMap(this.mName);
    }

    @Override
    public ReadableType getType() {
        if (this.mMap == null || this.mName == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mMap.getType(this.mName);
    }
}

