/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.facebook.infer.annotation.Assertions;
import java.util.HashMap;
import javax.annotation.Nullable;

final class TypefaceCache {
    private static final int MAX_STYLES = 4;
    private static final HashMap<String, Typeface[]> FONTFAMILY_CACHE = new HashMap();
    private static final HashMap<Typeface, Typeface[]> TYPEFACE_CACHE = new HashMap();
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    @Nullable
    private static AssetManager sAssetManager = null;

    TypefaceCache() {
    }

    public static void setAssetManager(AssetManager assetManager) {
        sAssetManager = assetManager;
    }

    public static Typeface getTypeface(String fontFamily, int style2) {
        Typeface typeface;
        Typeface[] cache = FONTFAMILY_CACHE.get(fontFamily);
        if (cache == null) {
            cache = new Typeface[4];
            FONTFAMILY_CACHE.put(fontFamily, cache);
        } else if (cache[style2] != null) {
            return cache[style2];
        }
        cache[style2] = typeface = TypefaceCache.createTypeface(fontFamily, style2);
        TYPEFACE_CACHE.put(typeface, cache);
        return typeface;
    }

    private static Typeface createTypeface(String fontFamilyName, int style2) {
        String extension = EXTENSIONS[style2];
        StringBuilder fileNameBuffer = new StringBuilder(32).append(FONTS_ASSET_PATH).append(fontFamilyName).append(extension);
        int length = fileNameBuffer.length();
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = fileNameBuffer.append(fileExtension).toString();
            try {
                return Typeface.createFromAsset((AssetManager)sAssetManager, (String)fileName);
            }
            catch (RuntimeException e) {
                fileNameBuffer.setLength(length);
            }
        }
        return (Typeface)Assertions.assumeNotNull((Object)Typeface.create((String)fontFamilyName, (int)style2));
    }

    public static Typeface getTypeface(Typeface typeface, int style2) {
        if (typeface == null) {
            return Typeface.defaultFromStyle((int)style2);
        }
        Typeface[] cache = TYPEFACE_CACHE.get(typeface);
        if (cache == null) {
            cache = new Typeface[4];
            cache[typeface.getStyle()] = typeface;
        } else if (cache[style2] != null) {
            return cache[style2];
        }
        cache[style2] = typeface = Typeface.create((Typeface)typeface, (int)style2);
        TYPEFACE_CACHE.put(typeface, cache);
        return typeface;
    }
}

