/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.flat.FlatTextShadowNode;
import com.facebook.react.flat.FontStylingSpan;
import com.facebook.react.flat.ShadowStyleSpan;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.annotations.ReactProp;
import javax.annotation.Nullable;

class RCTVirtualText
extends FlatTextShadowNode {
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String NORMAL = "normal";
    private static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    private static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    private static final String PROP_SHADOW_COLOR = "textShadowColor";
    private static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    private FontStylingSpan mFontStylingSpan = FontStylingSpan.INSTANCE;
    private ShadowStyleSpan mShadowStyleSpan = ShadowStyleSpan.INSTANCE;

    RCTVirtualText() {
    }

    @Override
    public void addChildAt(ReactShadowNodeImpl child, int i) {
        super.addChildAt(child, i);
        this.notifyChanged(true);
    }

    @Override
    protected void performCollectText(SpannableStringBuilder builder) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FlatTextShadowNode child = (FlatTextShadowNode)this.getChildAt(i);
            child.collectText(builder);
        }
    }

    @Override
    protected void performApplySpans(SpannableStringBuilder builder, int begin, int end, boolean isEditable) {
        this.mFontStylingSpan.freeze();
        int flag = isEditable ? 33 : (begin == 0 ? 18 : 34);
        builder.setSpan((Object)this.mFontStylingSpan, begin, end, flag);
        if (this.mShadowStyleSpan.getColor() != 0 && this.mShadowStyleSpan.getRadius() != 0.0f) {
            this.mShadowStyleSpan.freeze();
            builder.setSpan((Object)this.mShadowStyleSpan, begin, end, flag);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FlatTextShadowNode child = (FlatTextShadowNode)this.getChildAt(i);
            child.applySpans(builder, isEditable);
        }
    }

    @Override
    protected void performCollectAttachDetachListeners(StateBuilder stateBuilder) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FlatTextShadowNode child = (FlatTextShadowNode)this.getChildAt(i);
            child.performCollectAttachDetachListeners(stateBuilder);
        }
    }

    @ReactProp(name="fontSize", defaultFloat=NaNf)
    public void setFontSize(float fontSizeSp) {
        int fontSize = Float.isNaN(fontSizeSp) ? this.getDefaultFontSize() : RCTVirtualText.fontSizeFromSp(fontSizeSp);
        if (this.mFontStylingSpan.getFontSize() != fontSize) {
            this.getSpan().setFontSize(fontSize);
            this.notifyChanged(true);
        }
    }

    @ReactProp(name="color", defaultDouble=NaN)
    public void setColor(double textColor) {
        if (this.mFontStylingSpan.getTextColor() != textColor) {
            this.getSpan().setTextColor(textColor);
            this.notifyChanged(false);
        }
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (this.isVirtual()) {
            if (this.mFontStylingSpan.getBackgroundColor() != backgroundColor) {
                this.getSpan().setBackgroundColor(backgroundColor);
                this.notifyChanged(false);
            }
        } else {
            super.setBackgroundColor(backgroundColor);
        }
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(@Nullable String fontFamily) {
        if (!TextUtils.equals((CharSequence)this.mFontStylingSpan.getFontFamily(), (CharSequence)fontFamily)) {
            this.getSpan().setFontFamily(fontFamily);
            this.notifyChanged(true);
        }
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeight;
        if (fontWeightString == null) {
            fontWeight = -1;
        } else if (BOLD.equals(fontWeightString)) {
            fontWeight = 1;
        } else if (NORMAL.equals(fontWeightString)) {
            fontWeight = 0;
        } else {
            int fontWeightNumeric = RCTVirtualText.parseNumericFontWeight(fontWeightString);
            if (fontWeightNumeric == -1) {
                throw new RuntimeException("invalid font weight " + fontWeightString);
            }
            int n = fontWeight = fontWeightNumeric >= 500 ? 1 : 0;
        }
        if (this.mFontStylingSpan.getFontWeight() != fontWeight) {
            this.getSpan().setFontWeight(fontWeight);
            this.notifyChanged(true);
        }
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        boolean isUnderlineTextDecorationSet = false;
        boolean isLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split(" ")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    isUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"line-through".equals(textDecorationLineSubString)) continue;
                isLineThroughTextDecorationSet = true;
            }
        }
        if (isUnderlineTextDecorationSet != this.mFontStylingSpan.hasUnderline() || isLineThroughTextDecorationSet != this.mFontStylingSpan.hasStrikeThrough()) {
            FontStylingSpan span = this.getSpan();
            span.setHasUnderline(isUnderlineTextDecorationSet);
            span.setHasStrikeThrough(isLineThroughTextDecorationSet);
            this.notifyChanged(true);
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle;
        if (fontStyleString == null) {
            fontStyle = -1;
        } else if (ITALIC.equals(fontStyleString)) {
            fontStyle = 2;
        } else if (NORMAL.equals(fontStyleString)) {
            fontStyle = 0;
        } else {
            throw new RuntimeException("invalid font style " + fontStyleString);
        }
        if (this.mFontStylingSpan.getFontStyle() != fontStyle) {
            this.getSpan().setFontStyle(fontStyle);
            this.notifyChanged(true);
        }
    }

    @ReactProp(name="textShadowOffset")
    public void setTextShadowOffset(@Nullable ReadableMap offsetMap) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey("width")) {
                dx = PixelUtil.toPixelFromDIP(offsetMap.getDouble("width"));
            }
            if (offsetMap.hasKey("height")) {
                dy = PixelUtil.toPixelFromDIP(offsetMap.getDouble("height"));
            }
        }
        if (!this.mShadowStyleSpan.offsetMatches(dx, dy)) {
            this.getShadowSpan().setOffset(dx, dy);
            this.notifyChanged(false);
        }
    }

    @ReactProp(name="textShadowRadius")
    public void setTextShadowRadius(float textShadowRadius) {
        textShadowRadius = PixelUtil.toPixelFromDIP(textShadowRadius);
        if (this.mShadowStyleSpan.getRadius() != textShadowRadius) {
            this.getShadowSpan().setRadius(textShadowRadius);
            this.notifyChanged(false);
        }
    }

    @ReactProp(name="textShadowColor", defaultInt=0x55000000, customType="Color")
    public void setTextShadowColor(int textShadowColor) {
        if (this.mShadowStyleSpan.getColor() != textShadowColor) {
            this.getShadowSpan().setColor(textShadowColor);
            this.notifyChanged(false);
        }
    }

    protected final int getFontSize() {
        return this.mFontStylingSpan.getFontSize();
    }

    protected final int getFontStyle() {
        int style2 = this.mFontStylingSpan.getFontStyle();
        return style2 >= 0 ? style2 : 0;
    }

    protected int getDefaultFontSize() {
        return -1;
    }

    static int fontSizeFromSp(float sp) {
        return (int)Math.ceil(PixelUtil.toPixelFromSP(sp));
    }

    protected final FontStylingSpan getSpan() {
        if (this.mFontStylingSpan.isFrozen()) {
            this.mFontStylingSpan = this.mFontStylingSpan.mutableCopy();
        }
        return this.mFontStylingSpan;
    }

    final SpannableStringBuilder getText() {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        this.collectText(sb);
        this.applySpans(sb, this.isEditable());
        return sb;
    }

    private final ShadowStyleSpan getShadowSpan() {
        if (this.mShadowStyleSpan.isFrozen()) {
            this.mShadowStyleSpan = this.mShadowStyleSpan.mutableCopy();
        }
        return this.mShadowStyleSpan;
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }
}

