/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableMap;

class SpringAnimation
extends AnimationDriver {
    private static final double MAX_DELTA_TIME_SEC = 0.064;
    private static final double SOLVER_TIMESTEP_SEC = 0.001;
    private long mLastTime;
    private boolean mSpringStarted;
    private double mSpringStiffness;
    private double mSpringDamping;
    private double mSpringMass;
    private double mInitialVelocity;
    private boolean mOvershootClampingEnabled;
    private final PhysicsState mCurrentState = new PhysicsState();
    private double mStartValue;
    private double mEndValue;
    private double mRestSpeedThreshold;
    private double mDisplacementFromRestThreshold;
    private double mTimeAccumulator = 0.0;
    private int mIterations;
    private int mCurrentLoop = 0;
    private double mOriginalValue;

    SpringAnimation(ReadableMap config) {
        this.mSpringStiffness = config.getDouble("stiffness");
        this.mSpringDamping = config.getDouble("damping");
        this.mSpringMass = config.getDouble("mass");
        this.mCurrentState.velocity = this.mInitialVelocity = config.getDouble("initialVelocity");
        this.mEndValue = config.getDouble("toValue");
        this.mRestSpeedThreshold = config.getDouble("restSpeedThreshold");
        this.mDisplacementFromRestThreshold = config.getDouble("restDisplacementThreshold");
        this.mOvershootClampingEnabled = config.getBoolean("overshootClamping");
        this.mIterations = config.hasKey("iterations") ? config.getInt("iterations") : 1;
        this.mHasFinished = this.mIterations == 0;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        long frameTimeMillis = frameTimeNanos / 1000000L;
        if (!this.mSpringStarted) {
            if (this.mCurrentLoop == 0) {
                this.mOriginalValue = this.mAnimatedValue.mValue;
                this.mCurrentLoop = 1;
            }
            this.mStartValue = this.mCurrentState.position = this.mAnimatedValue.mValue;
            this.mLastTime = frameTimeMillis;
            this.mTimeAccumulator = 0.0;
            this.mSpringStarted = true;
        }
        this.advance((double)(frameTimeMillis - this.mLastTime) / 1000.0);
        this.mLastTime = frameTimeMillis;
        this.mAnimatedValue.mValue = this.mCurrentState.position;
        if (this.isAtRest()) {
            if (this.mIterations == -1 || this.mCurrentLoop < this.mIterations) {
                this.mSpringStarted = false;
                this.mAnimatedValue.mValue = this.mOriginalValue;
                ++this.mCurrentLoop;
            } else {
                this.mHasFinished = true;
            }
        }
    }

    private double getDisplacementDistanceForState(PhysicsState state) {
        return Math.abs(this.mEndValue - state.position);
    }

    private boolean isAtRest() {
        return Math.abs(this.mCurrentState.velocity) <= this.mRestSpeedThreshold && (this.getDisplacementDistanceForState(this.mCurrentState) <= this.mDisplacementFromRestThreshold || this.mSpringStiffness == 0.0);
    }

    private boolean isOvershooting() {
        return this.mSpringStiffness > 0.0 && (this.mStartValue < this.mEndValue && this.mCurrentState.position > this.mEndValue || this.mStartValue > this.mEndValue && this.mCurrentState.position < this.mEndValue);
    }

    private void advance(double realDeltaTime) {
        double velocity;
        double position;
        if (this.isAtRest()) {
            return;
        }
        double adjustedDeltaTime = realDeltaTime;
        if (realDeltaTime > 0.064) {
            adjustedDeltaTime = 0.064;
        }
        this.mTimeAccumulator += adjustedDeltaTime;
        double c = this.mSpringDamping;
        double m = this.mSpringMass;
        double k = this.mSpringStiffness;
        double v0 = -this.mInitialVelocity;
        double zeta = c / (2.0 * Math.sqrt(k * m));
        double omega0 = Math.sqrt(k / m);
        double omega1 = omega0 * Math.sqrt(1.0 - zeta * zeta);
        double x0 = this.mEndValue - this.mStartValue;
        double t = this.mTimeAccumulator;
        if (zeta < 1.0) {
            double envelope = Math.exp(-zeta * omega0 * t);
            position = this.mEndValue - envelope * ((v0 + zeta * omega0 * x0) / omega1 * Math.sin(omega1 * t) + x0 * Math.cos(omega1 * t));
            velocity = zeta * omega0 * envelope * (Math.sin(omega1 * t) * (v0 + zeta * omega0 * x0) / omega1 + x0 * Math.cos(omega1 * t)) - envelope * (Math.cos(omega1 * t) * (v0 + zeta * omega0 * x0) - omega1 * x0 * Math.sin(omega1 * t));
        } else {
            double envelope = Math.exp(-omega0 * t);
            position = this.mEndValue - envelope * (x0 + (v0 + omega0 * x0) * t);
            velocity = envelope * (v0 * (t * omega0 - 1.0) + t * x0 * (omega0 * omega0));
        }
        this.mCurrentState.position = position;
        this.mCurrentState.velocity = velocity;
        if (this.isAtRest() || this.mOvershootClampingEnabled && this.isOvershooting()) {
            if (this.mSpringStiffness > 0.0) {
                this.mStartValue = this.mEndValue;
                this.mCurrentState.position = this.mEndValue;
            } else {
                this.mStartValue = this.mEndValue = this.mCurrentState.position;
            }
            this.mCurrentState.velocity = 0.0;
        }
    }

    private static class PhysicsState {
        double position;
        double velocity;

        private PhysicsState() {
        }
    }
}

