/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.swmansion.rnscreens.Screen;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="RNSScreen")
public class ScreenViewManager
extends ViewGroupManager<Screen> {
    protected static final String REACT_CLASS = "RNSScreen";

    public String getName() {
        return REACT_CLASS;
    }

    protected Screen createViewInstance(ThemedReactContext reactContext) {
        return new Screen((ReactContext)reactContext);
    }

    @ReactProp(name="active", defaultFloat=0.0f)
    public void setActive(Screen view, float active) {
        view.setActive(active != 0.0f);
    }

    @ReactProp(name="stackPresentation")
    public void setStackPresentation(Screen view, String presentation) {
        if ("push".equals(presentation)) {
            view.setStackPresentation(Screen.StackPresentation.PUSH);
        } else if ("modal".equals(presentation) || "containedModal".equals(presentation) || "fullScreenModal".equals(presentation) || "formSheet".equals(presentation)) {
            view.setStackPresentation(Screen.StackPresentation.MODAL);
        } else if ("transparentModal".equals(presentation) || "containedTransparentModal".equals(presentation)) {
            view.setStackPresentation(Screen.StackPresentation.TRANSPARENT_MODAL);
        } else {
            throw new JSApplicationIllegalArgumentException("Unknown presentation type " + presentation);
        }
    }

    @ReactProp(name="stackAnimation")
    public void setStackAnimation(Screen view, String animation) {
        if (animation == null || "default".equals(animation)) {
            view.setStackAnimation(Screen.StackAnimation.DEFAULT);
        } else if ("none".equals(animation)) {
            view.setStackAnimation(Screen.StackAnimation.NONE);
        } else if ("fade".equals(animation)) {
            view.setStackAnimation(Screen.StackAnimation.FADE);
        }
    }

    @ReactProp(name="gestureEnabled", defaultBoolean=true)
    public void setGestureEnabled(Screen view, boolean gestureEnabled) {
        view.setGestureEnabled(gestureEnabled);
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of((Object)"topDismissed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDismissed"), (Object)"topAppear", (Object)MapBuilder.of((Object)"registrationName", (Object)"onAppear"), (Object)"topFinishTransitioning", (Object)MapBuilder.of((Object)"registrationName", (Object)"onFinishTransitioning"));
    }
}

