/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.views.text.ReactFontManager;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.ScreenStack;
import com.swmansion.rnscreens.ScreenStackFragment;
import com.swmansion.rnscreens.ScreenStackHeaderSubview;
import java.util.ArrayList;

public class ScreenStackHeaderConfig
extends ViewGroup {
    private final ArrayList<ScreenStackHeaderSubview> mConfigSubviews = new ArrayList(3);
    private String mTitle;
    private int mTitleColor;
    private String mTitleFontFamily;
    private float mTitleFontSize;
    private int mBackgroundColor;
    private boolean mIsHidden;
    private boolean mIsBackButtonHidden;
    private boolean mIsShadowHidden;
    private boolean mDestroyed;
    private boolean mBackButtonInCustomView;
    private boolean mIsTopInsetEnabled = true;
    private int mTintColor;
    private final Toolbar mToolbar;
    private boolean mIsAttachedToWindow = false;
    private int mDefaultStartInset;
    private int mDefaultStartInsetWithNavigation;
    private View.OnClickListener mBackClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            ScreenStackFragment fragment = ScreenStackHeaderConfig.this.getScreenFragment();
            if (fragment != null) {
                ScreenStack stack = ScreenStackHeaderConfig.this.getScreenStack();
                if (stack != null && stack.getRootScreen() == fragment.getScreen()) {
                    Fragment parentFragment = fragment.getParentFragment();
                    if (parentFragment instanceof ScreenStackFragment) {
                        ((ScreenStackFragment)parentFragment).dismiss();
                    }
                } else {
                    fragment.dismiss();
                }
            }
        }
    };

    public ScreenStackHeaderConfig(Context context) {
        super(context);
        this.setVisibility(8);
        this.mToolbar = new Toolbar(context);
        this.mDefaultStartInset = this.mToolbar.getContentInsetStart();
        this.mDefaultStartInsetWithNavigation = this.mToolbar.getContentInsetStartWithNavigation();
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843827, tv, true)) {
            this.mToolbar.setBackgroundColor(tv.data);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public void destroy() {
        this.mDestroyed = true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttachedToWindow = true;
        this.onUpdate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttachedToWindow = false;
    }

    private Screen getScreen() {
        ViewParent screen = this.getParent();
        if (screen instanceof Screen) {
            return (Screen)screen;
        }
        return null;
    }

    private ScreenStack getScreenStack() {
        ScreenContainer container;
        Screen screen = this.getScreen();
        if (screen != null && (container = screen.getContainer()) instanceof ScreenStack) {
            return (ScreenStack)container;
        }
        return null;
    }

    private ScreenStackFragment getScreenFragment() {
        ScreenFragment fragment;
        ViewParent screen = this.getParent();
        if (screen instanceof Screen && (fragment = ((Screen)screen).getFragment()) instanceof ScreenStackFragment) {
            return (ScreenStackFragment)fragment;
        }
        return null;
    }

    public void onUpdate() {
        int i;
        Drawable navigationIcon;
        boolean isTop;
        Screen parent = (Screen)this.getParent();
        ScreenStack stack = this.getScreenStack();
        boolean bl = stack == null ? true : (isTop = stack.getTopScreen() == parent);
        if (!this.mIsAttachedToWindow || !isTop || this.mDestroyed) {
            return;
        }
        AppCompatActivity activity = (AppCompatActivity)this.getScreenFragment().getActivity();
        if (activity == null) {
            return;
        }
        if (this.mIsHidden) {
            if (this.mToolbar.getParent() != null) {
                this.getScreenFragment().removeToolbar();
            }
            return;
        }
        if (this.mToolbar.getParent() == null) {
            this.getScreenFragment().setToolbar(this.mToolbar);
        }
        if (this.mIsTopInsetEnabled) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mToolbar.setPadding(0, this.getRootWindowInsets().getSystemWindowInsetTop(), 0, 0);
            } else {
                this.mToolbar.setPadding(0, (int)(25.0f * this.getResources().getDisplayMetrics().density), 0, 0);
            }
        } else if (this.mToolbar.getPaddingTop() > 0) {
            this.mToolbar.setPadding(0, 0, 0, 0);
        }
        activity.setSupportActionBar(this.mToolbar);
        ActionBar actionBar = activity.getSupportActionBar();
        this.mToolbar.setContentInsetStartWithNavigation(this.mDefaultStartInsetWithNavigation);
        this.mToolbar.setContentInsetsRelative(this.mDefaultStartInset, this.mDefaultStartInset);
        actionBar.setDisplayHomeAsUpEnabled(this.getScreenFragment().canNavigateBack() ? !this.mIsBackButtonHidden : false);
        this.mToolbar.setNavigationOnClickListener(this.mBackClickListener);
        this.getScreenFragment().setToolbarShadowHidden(this.mIsShadowHidden);
        actionBar.setTitle((CharSequence)this.mTitle);
        if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.mToolbar.setContentInsetStartWithNavigation(0);
        }
        TextView titleTextView = this.getTitleTextView();
        if (this.mTitleColor != 0) {
            this.mToolbar.setTitleTextColor(this.mTitleColor);
        }
        if (titleTextView != null) {
            if (this.mTitleFontFamily != null) {
                titleTextView.setTypeface(ReactFontManager.getInstance().getTypeface(this.mTitleFontFamily, 0, this.getContext().getAssets()));
            }
            if (this.mTitleFontSize > 0.0f) {
                titleTextView.setTextSize(this.mTitleFontSize);
            }
        }
        if (this.mBackgroundColor != 0) {
            this.mToolbar.setBackgroundColor(this.mBackgroundColor);
        }
        if (this.mTintColor != 0 && (navigationIcon = this.mToolbar.getNavigationIcon()) != null) {
            navigationIcon.setColorFilter(this.mTintColor, PorterDuff.Mode.SRC_ATOP);
        }
        for (i = this.mToolbar.getChildCount() - 1; i >= 0; --i) {
            if (!(this.mToolbar.getChildAt(i) instanceof ScreenStackHeaderSubview)) continue;
            this.mToolbar.removeViewAt(i);
        }
        int size = this.mConfigSubviews.size();
        for (i = 0; i < size; ++i) {
            ScreenStackHeaderSubview view = this.mConfigSubviews.get(i);
            ScreenStackHeaderSubview.Type type = view.getType();
            if (type == ScreenStackHeaderSubview.Type.BACK) {
                View firstChild = view.getChildAt(0);
                if (!(firstChild instanceof ImageView)) {
                    throw new JSApplicationIllegalArgumentException("Back button header config view should have Image as first child");
                }
                actionBar.setHomeAsUpIndicator(((ImageView)firstChild).getDrawable());
                continue;
            }
            Toolbar.LayoutParams params = new Toolbar.LayoutParams(-2, -1);
            switch (type) {
                case LEFT: {
                    if (!this.mBackButtonInCustomView) {
                        this.mToolbar.setNavigationIcon(null);
                    }
                    this.mToolbar.setTitle(null);
                    params.gravity = 3;
                    break;
                }
                case RIGHT: {
                    params.gravity = 5;
                    break;
                }
                case CENTER: {
                    params.width = -1;
                    params.gravity = 1;
                    this.mToolbar.setTitle(null);
                }
            }
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mToolbar.addView((View)view);
        }
    }

    private void maybeUpdate() {
        if (this.getParent() != null && !this.mDestroyed) {
            this.onUpdate();
        }
    }

    public ScreenStackHeaderSubview getConfigSubview(int index) {
        return this.mConfigSubviews.get(index);
    }

    public int getConfigSubviewsCount() {
        return this.mConfigSubviews.size();
    }

    public void removeConfigSubview(int index) {
        this.mConfigSubviews.remove(index);
        this.maybeUpdate();
    }

    public void removeAllConfigSubviews() {
        this.mConfigSubviews.clear();
        this.maybeUpdate();
    }

    public void addConfigSubview(ScreenStackHeaderSubview child, int index) {
        this.mConfigSubviews.add(index, child);
        this.maybeUpdate();
    }

    private TextView getTitleTextView() {
        int size = this.mToolbar.getChildCount();
        for (int i = 0; i < size; ++i) {
            TextView tv;
            View view = this.mToolbar.getChildAt(i);
            if (!(view instanceof TextView) || !(tv = (TextView)view).getText().equals(this.mToolbar.getTitle())) continue;
            return tv;
        }
        return null;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setTitleFontFamily(String titleFontFamily) {
        this.mTitleFontFamily = titleFontFamily;
    }

    public void setTitleFontSize(float titleFontSize) {
        this.mTitleFontSize = titleFontSize;
    }

    public void setTitleColor(int color) {
        this.mTitleColor = color;
    }

    public void setTintColor(int color) {
        this.mTintColor = color;
    }

    public void setTopInsetEnabled(boolean topInsetEnabled) {
        this.mIsTopInsetEnabled = topInsetEnabled;
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
    }

    public void setHideShadow(boolean hideShadow) {
        this.mIsShadowHidden = hideShadow;
    }

    public void setHideBackButton(boolean hideBackButton) {
        this.mIsBackButtonHidden = hideBackButton;
    }

    public void setHidden(boolean hidden) {
        this.mIsHidden = hidden;
    }

    public void setBackButtonInCustomView(boolean backButtonInCustomView) {
        this.mBackButtonInCustomView = backButtonInCustomView;
    }
}

