/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.fragment.app.Fragment;
import com.facebook.react.uimanager.PixelUtil;
import com.google.android.material.appbar.AppBarLayout;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.ScreenStack;
import com.swmansion.rnscreens.ScreenStackHeaderConfig;

public class ScreenStackFragment
extends ScreenFragment {
    private static final float TOOLBAR_ELEVATION = PixelUtil.toPixelFromDIP((float)4.0f);
    private AppBarLayout mAppBarLayout;
    private Toolbar mToolbar;
    private boolean mShadowHidden;

    @SuppressLint(value={"ValidFragment"})
    public ScreenStackFragment(Screen screenView) {
        super(screenView);
    }

    public void removeToolbar() {
        if (this.mAppBarLayout != null && this.mToolbar != null && this.mToolbar.getParent() == this.mAppBarLayout) {
            this.mAppBarLayout.removeView((View)this.mToolbar);
        }
        this.mToolbar = null;
    }

    public void setToolbar(Toolbar toolbar) {
        if (this.mAppBarLayout != null) {
            this.mAppBarLayout.addView((View)toolbar);
        }
        this.mToolbar = toolbar;
        AppBarLayout.LayoutParams params = new AppBarLayout.LayoutParams(-1, -2);
        params.setScrollFlags(0);
        this.mToolbar.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setToolbarShadowHidden(boolean hidden) {
        if (this.mShadowHidden != hidden) {
            this.mAppBarLayout.setTargetElevation(hidden ? 0.0f : TOOLBAR_ELEVATION);
            this.mShadowHidden = hidden;
        }
    }

    public void onStackUpdate() {
        View child = this.mScreenView.getChildAt(0);
        if (child instanceof ScreenStackHeaderConfig) {
            ((ScreenStackHeaderConfig)child).onUpdate();
        }
    }

    @Override
    public void onViewAnimationEnd() {
        super.onViewAnimationEnd();
        this.notifyViewAppearTransitionEnd();
    }

    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (enter && transit == 0) {
            this.notifyViewAppearTransitionEnd();
        }
        return null;
    }

    private void notifyViewAppearTransitionEnd() {
        ViewParent screenStack = this.getView().getParent();
        if (screenStack instanceof ScreenStack) {
            ((ScreenStack)screenStack).onViewAppearTransitionEnd();
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        NotifyingCoordinatorLayout view = new NotifyingCoordinatorLayout(this.getContext(), this);
        CoordinatorLayout.LayoutParams params = new CoordinatorLayout.LayoutParams(-1, -1);
        params.setBehavior((CoordinatorLayout.Behavior)new AppBarLayout.ScrollingViewBehavior());
        this.mScreenView.setLayoutParams((ViewGroup.LayoutParams)params);
        view.addView(ScreenStackFragment.recycleView((View)this.mScreenView));
        this.mAppBarLayout = new AppBarLayout(this.getContext());
        this.mAppBarLayout.setBackgroundColor(0);
        this.mAppBarLayout.setLayoutParams((ViewGroup.LayoutParams)new AppBarLayout.LayoutParams(-1, -2));
        view.addView((View)this.mAppBarLayout);
        if (this.mShadowHidden) {
            this.mAppBarLayout.setTargetElevation(0.0f);
        }
        if (this.mToolbar != null) {
            this.mAppBarLayout.addView(ScreenStackFragment.recycleView((View)this.mToolbar));
        }
        return view;
    }

    public boolean isDismissable() {
        return this.mScreenView.isGestureEnabled();
    }

    public boolean canNavigateBack() {
        ScreenContainer container = this.mScreenView.getContainer();
        if (container instanceof ScreenStack) {
            if (((ScreenStack)container).getRootScreen() == this.getScreen()) {
                Fragment parentFragment = this.getParentFragment();
                if (parentFragment instanceof ScreenStackFragment) {
                    return ((ScreenStackFragment)parentFragment).canNavigateBack();
                }
                return false;
            }
            return true;
        }
        throw new IllegalStateException("ScreenStackFragment added into a non-stack container");
    }

    public void dismiss() {
        ScreenContainer container = this.mScreenView.getContainer();
        if (!(container instanceof ScreenStack)) {
            throw new IllegalStateException("ScreenStackFragment added into a non-stack container");
        }
        ((ScreenStack)container).dismiss(this);
    }

    private static class NotifyingCoordinatorLayout
    extends CoordinatorLayout {
        private final ScreenFragment mFragment;

        public NotifyingCoordinatorLayout(@NonNull Context context, ScreenFragment fragment) {
            super(context);
            this.mFragment = fragment;
        }

        protected void onAnimationEnd() {
            super.onAnimationEnd();
            this.mFragment.onViewAnimationEnd();
        }
    }
}

