/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.SafeAreaViewEdges;
import com.th3rdwave.safeareacontext.SafeAreaViewLocalData;
import com.th3rdwave.safeareacontext.SafeAreaViewMode;
import java.util.EnumSet;

public class SafeAreaViewShadowNode
extends LayoutShadowNode {
    @Nullable
    private SafeAreaViewLocalData mLocalData;
    private float[] mPaddings = new float[ViewProps.PADDING_MARGIN_SPACING_TYPES.length];
    private float[] mMargins = new float[ViewProps.PADDING_MARGIN_SPACING_TYPES.length];
    private boolean mNeedsUpdate = false;

    public SafeAreaViewShadowNode() {
        for (int i = 0; i < ViewProps.PADDING_MARGIN_SPACING_TYPES.length; ++i) {
            this.mPaddings[i] = Float.NaN;
            this.mMargins[i] = Float.NaN;
        }
    }

    private void updateInsets() {
        float insetLeft;
        float leftEdge;
        float bottomEdge;
        float rightEdge;
        float topEdge;
        float horizontalEdges;
        float verticalEdges;
        if (this.mLocalData == null) {
            return;
        }
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        float[] meta = this.mLocalData.getMode() == SafeAreaViewMode.PADDING ? this.mPaddings : this.mMargins;
        float allEdges = meta[8];
        if (!Float.isNaN(allEdges)) {
            top = allEdges;
            right = allEdges;
            bottom = allEdges;
            left = allEdges;
        }
        if (!Float.isNaN(verticalEdges = meta[7])) {
            top = verticalEdges;
            bottom = verticalEdges;
        }
        if (!Float.isNaN(horizontalEdges = meta[6])) {
            right = horizontalEdges;
            left = horizontalEdges;
        }
        if (!Float.isNaN(topEdge = meta[1])) {
            top = topEdge;
        }
        if (!Float.isNaN(rightEdge = meta[2])) {
            right = rightEdge;
        }
        if (!Float.isNaN(bottomEdge = meta[3])) {
            bottom = bottomEdge;
        }
        if (!Float.isNaN(leftEdge = meta[0])) {
            left = leftEdge;
        }
        top = PixelUtil.toPixelFromDIP((float)top);
        right = PixelUtil.toPixelFromDIP((float)right);
        bottom = PixelUtil.toPixelFromDIP((float)bottom);
        left = PixelUtil.toPixelFromDIP((float)left);
        EnumSet<SafeAreaViewEdges> edges = this.mLocalData.getEdges();
        EdgeInsets insets = this.mLocalData.getInsets();
        float insetTop = edges.contains((Object)SafeAreaViewEdges.TOP) ? insets.top : 0.0f;
        float insetRight = edges.contains((Object)SafeAreaViewEdges.RIGHT) ? insets.right : 0.0f;
        float insetBottom = edges.contains((Object)SafeAreaViewEdges.BOTTOM) ? insets.bottom : 0.0f;
        float f = insetLeft = edges.contains((Object)SafeAreaViewEdges.LEFT) ? insets.left : 0.0f;
        if (this.mLocalData.getMode() == SafeAreaViewMode.PADDING) {
            super.setPadding(1, insetTop + top);
            super.setPadding(2, insetRight + right);
            super.setPadding(3, insetBottom + bottom);
            super.setPadding(0, insetLeft + left);
        } else {
            super.setMargin(1, insetTop + top);
            super.setMargin(2, insetRight + right);
            super.setMargin(3, insetBottom + bottom);
            super.setMargin(0, insetLeft + left);
        }
    }

    private void resetInsets(SafeAreaViewMode mode) {
        if (mode == SafeAreaViewMode.PADDING) {
            super.setPadding(1, this.mPaddings[1]);
            super.setPadding(2, this.mPaddings[1]);
            super.setPadding(3, this.mPaddings[3]);
            super.setPadding(0, this.mPaddings[0]);
        } else {
            super.setMargin(1, this.mMargins[1]);
            super.setMargin(2, this.mMargins[1]);
            super.setMargin(3, this.mMargins[3]);
            super.setMargin(0, this.mMargins[0]);
        }
    }

    public void onBeforeLayout() {
        if (this.mNeedsUpdate) {
            this.mNeedsUpdate = false;
            this.updateInsets();
        }
    }

    public void onBeforeLayout(NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        if (this.mNeedsUpdate) {
            this.mNeedsUpdate = false;
            this.updateInsets();
        }
    }

    public void setLocalData(Object data) {
        if (!(data instanceof SafeAreaViewLocalData)) {
            return;
        }
        SafeAreaViewLocalData localData = (SafeAreaViewLocalData)data;
        if (this.mLocalData != null && this.mLocalData.getMode() != localData.getMode()) {
            this.resetInsets(this.mLocalData.getMode());
        }
        this.mLocalData = localData;
        this.mNeedsUpdate = false;
        this.updateInsets();
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom", "paddingLeft", "paddingRight"})
    public void setPaddings(int index, Dynamic padding) {
        int spacingType = ViewProps.PADDING_MARGIN_SPACING_TYPES[index];
        this.mPaddings[spacingType] = padding.getType() == ReadableType.Number ? (float)padding.asDouble() : Float.NaN;
        super.setPaddings(index, padding);
        this.mNeedsUpdate = true;
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginStart", "marginEnd", "marginTop", "marginBottom", "marginLeft", "marginRight"})
    public void setMargins(int index, Dynamic margin) {
        int spacingType = ViewProps.PADDING_MARGIN_SPACING_TYPES[index];
        this.mMargins[spacingType] = margin.getType() == ReadableType.Number ? (float)margin.asDouble() : Float.NaN;
        super.setMargins(index, margin);
        this.mNeedsUpdate = true;
    }
}

