/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.th3rdwave.safeareacontext.SafeAreaView;
import com.th3rdwave.safeareacontext.SafeAreaViewEdges;
import com.th3rdwave.safeareacontext.SafeAreaViewMode;
import com.th3rdwave.safeareacontext.SafeAreaViewShadowNode;
import java.util.EnumSet;

public class SafeAreaViewManager
extends ViewGroupManager<SafeAreaView> {
    @NonNull
    public String getName() {
        return "RNCSafeAreaView";
    }

    @NonNull
    public SafeAreaView createViewInstance(@NonNull ThemedReactContext context) {
        return new SafeAreaView((Context)context);
    }

    @NonNull
    public SafeAreaViewShadowNode createShadowNodeInstance() {
        return new SafeAreaViewShadowNode();
    }

    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return SafeAreaViewShadowNode.class;
    }

    @ReactProp(name="mode")
    public void setMode(SafeAreaView view, @Nullable String mode) {
        if ("padding".equals(mode)) {
            view.setMode(SafeAreaViewMode.PADDING);
        } else if ("margin".equals(mode)) {
            view.setMode(SafeAreaViewMode.MARGIN);
        }
    }

    @ReactProp(name="edges")
    public void setEdges(SafeAreaView view, @Nullable ReadableArray propList) {
        EnumSet<SafeAreaViewEdges> edges = EnumSet.noneOf(SafeAreaViewEdges.class);
        if (propList != null) {
            for (int i = 0; i < propList.size(); ++i) {
                String edgeName = propList.getString(i);
                if ("top".equals(edgeName)) {
                    edges.add(SafeAreaViewEdges.TOP);
                    continue;
                }
                if ("right".equals(edgeName)) {
                    edges.add(SafeAreaViewEdges.RIGHT);
                    continue;
                }
                if ("bottom".equals(edgeName)) {
                    edges.add(SafeAreaViewEdges.BOTTOM);
                    continue;
                }
                if (!"left".equals(edgeName)) continue;
                edges.add(SafeAreaViewEdges.LEFT);
            }
        }
        view.setEdges(edges);
    }
}

