/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.views.view.ReactViewGroup;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.SafeAreaProvider;
import com.th3rdwave.safeareacontext.SafeAreaUtils;
import com.th3rdwave.safeareacontext.SafeAreaViewEdges;
import com.th3rdwave.safeareacontext.SafeAreaViewLocalData;
import com.th3rdwave.safeareacontext.SafeAreaViewMode;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"ViewConstructor"})
public class SafeAreaView
extends ReactViewGroup
implements ViewTreeObserver.OnPreDrawListener {
    private SafeAreaViewMode mMode = SafeAreaViewMode.PADDING;
    @Nullable
    private EdgeInsets mInsets;
    @Nullable
    private EnumSet<SafeAreaViewEdges> mEdges;
    @Nullable
    private View mProviderView;
    private static final long MAX_WAIT_TIME_NANO = 5000000000L;

    public SafeAreaView(Context context) {
        super(context);
    }

    private static ReactContext getReactContext(View view) {
        Context context = view.getContext();
        if (!(context instanceof ReactContext) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return (ReactContext)context;
    }

    private void updateInsets() {
        if (this.mInsets != null) {
            EnumSet<SafeAreaViewEdges> edges = this.mEdges != null ? this.mEdges : EnumSet.allOf(SafeAreaViewEdges.class);
            SafeAreaViewLocalData localData = new SafeAreaViewLocalData(this.mInsets, this.mMode, edges);
            ReactContext reactContext = SafeAreaView.getReactContext((View)this);
            UIManagerModule uiManager = (UIManagerModule)reactContext.getNativeModule(UIManagerModule.class);
            if (uiManager != null) {
                uiManager.setViewLocalData(this.getId(), (Object)localData);
                this.waitForReactLayout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReactLayout() {
        final AtomicBoolean done = new AtomicBoolean(false);
        long startTime = System.nanoTime();
        long waitTime = 0L;
        SafeAreaView.getReactContext((View)this).runOnNativeModulesQueueThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = done;
                synchronized (atomicBoolean) {
                    done.set(true);
                    done.notify();
                }
            }
        });
        AtomicBoolean atomicBoolean = done;
        synchronized (atomicBoolean) {
            while (!done.get() && waitTime < 5000000000L) {
                try {
                    done.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = System.nanoTime() - startTime;
            }
            if (waitTime >= 5000000000L) {
                Log.w((String)"SafeAreaView", (String)"Timed out waiting for layout.");
            }
        }
    }

    public void setMode(SafeAreaViewMode mode) {
        this.mMode = mode;
        this.updateInsets();
    }

    public void setEdges(EnumSet<SafeAreaViewEdges> edges) {
        this.mEdges = edges;
        this.updateInsets();
    }

    private boolean maybeUpdateInsets() {
        if (this.mProviderView == null) {
            return false;
        }
        EdgeInsets edgeInsets = SafeAreaUtils.getSafeAreaInsets(this.mProviderView);
        if (!(edgeInsets == null || this.mInsets != null && this.mInsets.equalsToEdgeInsets(edgeInsets))) {
            this.mInsets = edgeInsets;
            this.updateInsets();
            return true;
        }
        return false;
    }

    private View findProvider() {
        for (ViewParent current = this.getParent(); current != null; current = current.getParent()) {
            if (!(current instanceof SafeAreaProvider)) continue;
            return (View)current;
        }
        return this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mProviderView = this.findProvider();
        this.mProviderView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.maybeUpdateInsets();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mProviderView != null) {
            this.mProviderView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.mProviderView = null;
    }

    public boolean onPreDraw() {
        boolean didUpdate = this.maybeUpdateInsets();
        if (didUpdate) {
            this.requestLayout();
        }
        return !didUpdate;
    }
}

