/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import androidx.annotation.Nullable;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.Rect;

class SafeAreaUtils {
    SafeAreaUtils() {
    }

    @Nullable
    private static EdgeInsets getRootWindowInsetsCompat(View rootView) {
        if (Build.VERSION.SDK_INT >= 23) {
            WindowInsets insets = rootView.getRootWindowInsets();
            if (insets == null) {
                return null;
            }
            return new EdgeInsets(insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getStableInsetBottom(), insets.getSystemWindowInsetLeft());
        }
        android.graphics.Rect visibleRect = new android.graphics.Rect();
        rootView.getWindowVisibleDisplayFrame(visibleRect);
        return new EdgeInsets(visibleRect.top, rootView.getWidth() - visibleRect.right, rootView.getHeight() - visibleRect.bottom, visibleRect.left);
    }

    @Nullable
    static EdgeInsets getSafeAreaInsets(View view) {
        if (view.getHeight() == 0) {
            return null;
        }
        View rootView = view.getRootView();
        EdgeInsets windowInsets = SafeAreaUtils.getRootWindowInsetsCompat(rootView);
        if (windowInsets == null) {
            return null;
        }
        float windowWidth = rootView.getWidth();
        float windowHeight = rootView.getHeight();
        android.graphics.Rect visibleRect = new android.graphics.Rect();
        view.getGlobalVisibleRect(visibleRect);
        windowInsets.top = Math.max(windowInsets.top - (float)visibleRect.top, 0.0f);
        windowInsets.left = Math.max(windowInsets.left - (float)visibleRect.left, 0.0f);
        windowInsets.bottom = Math.max((float)(visibleRect.top + view.getHeight()) + windowInsets.bottom - windowHeight, 0.0f);
        windowInsets.right = Math.max((float)(visibleRect.left + view.getWidth()) + windowInsets.right - windowWidth, 0.0f);
        return windowInsets;
    }

    @Nullable
    static Rect getFrame(ViewGroup rootView, View view) {
        if (view.getParent() == null) {
            return null;
        }
        android.graphics.Rect offset = new android.graphics.Rect();
        view.getDrawingRect(offset);
        try {
            rootView.offsetDescendantRectToMyCoords(view, offset);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
        return new Rect(offset.left, offset.top, view.getWidth(), view.getHeight());
    }
}

