/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.InsetsChangeEvent;
import com.th3rdwave.safeareacontext.Rect;
import com.th3rdwave.safeareacontext.SafeAreaProvider;
import com.th3rdwave.safeareacontext.SafeAreaUtils;
import com.th3rdwave.safeareacontext.SerializationUtils;
import java.util.Map;

public class SafeAreaProviderManager
extends ViewGroupManager<SafeAreaProvider> {
    private final ReactApplicationContext mContext;

    public SafeAreaProviderManager(ReactApplicationContext context) {
        this.mContext = context;
    }

    @NonNull
    public String getName() {
        return "RNCSafeAreaProvider";
    }

    @NonNull
    public SafeAreaProvider createViewInstance(@NonNull ThemedReactContext context) {
        return new SafeAreaProvider((Context)context);
    }

    protected void addEventEmitters(@NonNull ThemedReactContext reactContext, @NonNull SafeAreaProvider view) {
        final EventDispatcher dispatcher = ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher();
        view.setOnInsetsChangeListener(new SafeAreaProvider.OnInsetsChangeListener(){

            @Override
            public void onInsetsChange(SafeAreaProvider view, EdgeInsets insets, Rect frame) {
                dispatcher.dispatchEvent((Event)new InsetsChangeEvent(view.getId(), insets, frame));
            }
        });
    }

    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)"topInsetsChange", (Object)MapBuilder.of((Object)"registrationName", (Object)"onInsetsChange")).build();
    }

    @Nullable
    private Map<String, Object> getInitialWindowMetrics() {
        Activity activity = this.mContext.getCurrentActivity();
        if (activity == null) {
            return null;
        }
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (decorView == null) {
            return null;
        }
        View contentView = decorView.findViewById(0x1020002);
        EdgeInsets insets = SafeAreaUtils.getSafeAreaInsets((View)decorView);
        Rect frame = SafeAreaUtils.getFrame(decorView, contentView);
        if (insets == null || frame == null) {
            return null;
        }
        return MapBuilder.of((Object)"insets", SerializationUtils.edgeInsetsToJavaMap(insets), (Object)"frame", SerializationUtils.rectToJavaMap(frame));
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of((Object)"initialWindowMetrics", this.getInitialWindowMetrics());
    }
}

