/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.views.view.ReactViewGroup;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.Rect;
import com.th3rdwave.safeareacontext.SafeAreaUtils;

@SuppressLint(value={"ViewConstructor"})
public class SafeAreaProvider
extends ReactViewGroup
implements ViewTreeObserver.OnPreDrawListener {
    @Nullable
    private OnInsetsChangeListener mInsetsChangeListener;
    @Nullable
    private EdgeInsets mLastInsets;
    @Nullable
    private Rect mLastFrame;

    public SafeAreaProvider(Context context) {
        super(context);
    }

    private void maybeUpdateInsets() {
        EdgeInsets edgeInsets = SafeAreaUtils.getSafeAreaInsets((View)this);
        Rect frame = SafeAreaUtils.getFrame((ViewGroup)this.getRootView(), (View)this);
        if (!(edgeInsets == null || frame == null || this.mLastInsets != null && this.mLastFrame != null && this.mLastInsets.equalsToEdgeInsets(edgeInsets) && this.mLastFrame.equalsToRect(frame))) {
            ((OnInsetsChangeListener)Assertions.assertNotNull((Object)this.mInsetsChangeListener)).onInsetsChange(this, edgeInsets, frame);
            this.mLastInsets = edgeInsets;
            this.mLastFrame = frame;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.maybeUpdateInsets();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public boolean onPreDraw() {
        this.maybeUpdateInsets();
        return true;
    }

    public void setOnInsetsChangeListener(OnInsetsChangeListener listener) {
        this.mInsetsChangeListener = listener;
    }

    public static interface OnInsetsChangeListener {
        public void onInsetsChange(SafeAreaProvider var1, EdgeInsets var2, Rect var3);
    }
}

