/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.Rect;
import com.th3rdwave.safeareacontext.SerializationUtils;

class InsetsChangeEvent
extends Event<InsetsChangeEvent> {
    static final String EVENT_NAME = "topInsetsChange";
    private EdgeInsets mInsets;
    private Rect mFrame;

    InsetsChangeEvent(int viewTag, EdgeInsets insets, Rect frame) {
        super(viewTag);
        this.mInsets = insets;
        this.mFrame = frame;
    }

    public String getEventName() {
        return EVENT_NAME;
    }

    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap event = Arguments.createMap();
        event.putMap("insets", SerializationUtils.edgeInsetsToJsMap(this.mInsets));
        event.putMap("frame", SerializationUtils.rectToJsMap(this.mFrame));
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), event);
    }
}

