/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.transitions;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionValues;
import androidx.transition.Visibility;

public class Scale
extends Visibility {
    static final String PROPNAME_SCALE_X = "scale:scaleX";
    static final String PROPNAME_SCALE_Y = "scale:scaleY";

    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        transitionValues.values.put(PROPNAME_SCALE_X, Float.valueOf(transitionValues.view.getScaleX()));
        transitionValues.values.put(PROPNAME_SCALE_Y, Float.valueOf(transitionValues.view.getScaleY()));
    }

    public Scale setDisappearedScale(float disappearedScale) {
        if (disappearedScale < 0.0f) {
            throw new IllegalArgumentException("disappearedScale cannot be negative!");
        }
        return this;
    }

    private Animator createAnimation(final View view, float startScale, float endScale, TransitionValues values) {
        final float initialScaleX = view.getScaleX();
        final float initialScaleY = view.getScaleY();
        float startScaleX = initialScaleX * startScale;
        float endScaleX = initialScaleX * endScale;
        float startScaleY = initialScaleY * startScale;
        float endScaleY = initialScaleY * endScale;
        if (values != null) {
            Float savedScaleX = (Float)values.values.get(PROPNAME_SCALE_X);
            Float savedScaleY = (Float)values.values.get(PROPNAME_SCALE_Y);
            if (savedScaleX != null && savedScaleX.floatValue() != initialScaleX) {
                startScaleX = savedScaleX.floatValue();
            }
            if (savedScaleY != null && savedScaleY.floatValue() != initialScaleY) {
                startScaleY = savedScaleY.floatValue();
            }
        }
        view.setScaleX(startScaleX);
        view.setScaleY(startScaleY);
        AnimatorSet animator = new AnimatorSet();
        animator.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (Property)View.SCALE_X, (float[])new float[]{startScaleX, endScaleX}), ObjectAnimator.ofFloat((Object)view, (Property)View.SCALE_Y, (float[])new float[]{startScaleY, endScaleY})});
        this.addListener((Transition.TransitionListener)new TransitionListenerAdapter(){

            public void onTransitionEnd(Transition transition) {
                view.setScaleX(initialScaleX);
                view.setScaleY(initialScaleY);
                transition.removeListener((Transition.TransitionListener)this);
            }
        });
        return animator;
    }

    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimation(view, 0.0f, 1.0f, startValues);
    }

    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimation(view, 1.0f, 0.0f, startValues);
    }
}

