/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.nodes.Node;
import java.util.ArrayList;
import java.util.List;

public class TransformNode
extends Node {
    private List<TransformConfig> mTransforms;

    private static List<TransformConfig> processTransforms(ReadableArray transforms) {
        ArrayList<TransformConfig> configs = new ArrayList<TransformConfig>(transforms.size());
        for (int i = 0; i < transforms.size(); ++i) {
            TransformConfig transformConfig;
            ReadableMap transformConfigMap = transforms.getMap(i);
            String property = transformConfigMap.getString("property");
            if (transformConfigMap.hasKey("nodeID")) {
                transformConfig = new AnimatedTransformConfig();
                transformConfig.propertyName = property;
                transformConfig.nodeID = transformConfigMap.getInt("nodeID");
                configs.add(transformConfig);
                continue;
            }
            transformConfig = new StaticTransformConfig();
            ((StaticTransformConfig)transformConfig).propertyName = property;
            ((StaticTransformConfig)transformConfig).value = transformConfigMap.getType("value") == ReadableType.String ? transformConfigMap.getString("value") : Double.valueOf(transformConfigMap.getDouble("value"));
            configs.add(transformConfig);
        }
        return configs;
    }

    public TransformNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mTransforms = TransformNode.processTransforms(config.getArray("transform"));
    }

    protected WritableArray evaluate() {
        ArrayList<JavaOnlyMap> transforms = new ArrayList<JavaOnlyMap>(this.mTransforms.size());
        for (TransformConfig transformConfig : this.mTransforms) {
            transforms.add(JavaOnlyMap.of((Object[])new Object[]{transformConfig.propertyName, transformConfig.getValue(this.mNodesManager)}));
        }
        return JavaOnlyArray.from(transforms);
    }

    private static class StaticTransformConfig
    extends TransformConfig {
        public Object value;

        private StaticTransformConfig() {
        }

        @Override
        public Object getValue(NodesManager nodesManager) {
            return this.value;
        }
    }

    private static class AnimatedTransformConfig
    extends TransformConfig {
        public int nodeID;

        private AnimatedTransformConfig() {
        }

        @Override
        public Object getValue(NodesManager nodesManager) {
            return nodesManager.getNodeValue(this.nodeID);
        }
    }

    private static abstract class TransformConfig {
        public String propertyName;

        private TransformConfig() {
        }

        public abstract Object getValue(NodesManager var1);
    }
}

