/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.UIImplementation;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.Utils;
import com.swmansion.reanimated.nodes.FinalNode;
import com.swmansion.reanimated.nodes.Node;
import com.swmansion.reanimated.nodes.StyleNode;
import java.util.Map;

public class PropsNode
extends Node
implements FinalNode {
    private final Map<String, Integer> mMapping;
    private final UIImplementation mUIImplementation;
    private int mConnectedViewTag = -1;
    private final JavaOnlyMap mPropMap;
    private final ReactStylesDiffMap mDiffMap;

    private static void addProp(WritableMap propMap, String key, Object value) {
        if (value == null) {
            propMap.putNull(key);
        } else if (value instanceof Double) {
            propMap.putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            propMap.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Number) {
            propMap.putDouble(key, ((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            propMap.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            propMap.putString(key, (String)value);
        } else if (value instanceof WritableArray) {
            propMap.putArray(key, (WritableArray)value);
        } else if (value instanceof WritableMap) {
            propMap.putMap(key, (WritableMap)value);
        } else {
            throw new IllegalStateException("Unknown type of animated value");
        }
    }

    public PropsNode(int nodeID, ReadableMap config, NodesManager nodesManager, UIImplementation uiImplementation) {
        super(nodeID, config, nodesManager);
        this.mMapping = Utils.processMapping(config.getMap("props"));
        this.mUIImplementation = uiImplementation;
        this.mPropMap = new JavaOnlyMap();
        this.mDiffMap = new ReactStylesDiffMap((ReadableMap)this.mPropMap);
    }

    public void connectToView(int viewTag) {
        this.mConnectedViewTag = viewTag;
        this.dangerouslyRescheduleEvaluate();
    }

    public void disconnectFromView(int viewTag) {
        this.mConnectedViewTag = -1;
    }

    @Override
    protected Double evaluate() {
        boolean hasUIProps = false;
        boolean hasNativeProps = false;
        boolean hasJSProps = false;
        WritableMap jsProps = Arguments.createMap();
        WritableMap nativeProps = Arguments.createMap();
        for (Map.Entry<String, Integer> entry : this.mMapping.entrySet()) {
            Node node = this.mNodesManager.findNodeById(entry.getValue(), Node.class);
            if (node instanceof StyleNode) {
                WritableMap style = (WritableMap)node.value();
                ReadableMapKeySetIterator iter = style.keySetIterator();
                block6: while (iter.hasNextKey()) {
                    JavaOnlyMap dest;
                    String key = iter.nextKey();
                    if (this.mNodesManager.uiProps.contains(key)) {
                        hasUIProps = true;
                        dest = this.mPropMap;
                    } else if (this.mNodesManager.nativeProps.contains(key)) {
                        hasNativeProps = true;
                        dest = nativeProps;
                    } else {
                        hasJSProps = true;
                        dest = jsProps;
                    }
                    ReadableType type = style.getType(key);
                    switch (type) {
                        case Number: {
                            dest.putDouble(key, style.getDouble(key));
                            continue block6;
                        }
                        case String: {
                            dest.putString(key, style.getString(key));
                            continue block6;
                        }
                        case Array: {
                            dest.putArray(key, (WritableArray)style.getArray(key));
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected type " + type);
                }
                continue;
            }
            String key = entry.getKey();
            Object value = node.value();
            if (this.mNodesManager.uiProps.contains(key)) {
                hasUIProps = true;
                PropsNode.addProp((WritableMap)this.mPropMap, key, value);
                continue;
            }
            hasNativeProps = true;
            PropsNode.addProp(nativeProps, key, value);
        }
        if (this.mConnectedViewTag != -1) {
            if (hasUIProps) {
                this.mUIImplementation.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, this.mDiffMap);
            }
            if (hasNativeProps) {
                this.mNodesManager.enqueueUpdateViewOnNativeThread(this.mConnectedViewTag, nativeProps);
            }
            if (hasJSProps) {
                WritableMap evt = Arguments.createMap();
                evt.putInt("viewTag", this.mConnectedViewTag);
                evt.putMap("props", jsProps);
                this.mNodesManager.sendEvent("onReanimatedPropsChange", evt);
            }
        }
        return ZERO;
    }

    @Override
    public void update() {
        if (this.mConnectedViewTag == -1) {
            return;
        }
        this.value();
    }
}

