/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.Utils;
import com.swmansion.reanimated.nodes.Node;

public class JSCallNode
extends Node {
    private final int[] mInputIDs;

    public JSCallNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mInputIDs = Utils.processIntArray(config.getArray("input"));
    }

    @Override
    protected Double evaluate() {
        WritableArray args = Arguments.createArray();
        for (int i = 0; i < this.mInputIDs.length; ++i) {
            Node node = this.mNodesManager.findNodeById(this.mInputIDs[i], Node.class);
            if (node.value() == null) {
                args.pushNull();
                continue;
            }
            Object value = node.value();
            if (value instanceof String) {
                args.pushString((String)value);
                continue;
            }
            args.pushDouble(node.doubleValue().doubleValue());
        }
        WritableMap eventData = Arguments.createMap();
        eventData.putInt("id", this.mNodeID);
        eventData.putArray("args", args);
        this.mNodesManager.sendEvent("onReanimatedCall", eventData);
        return ZERO;
    }
}

