/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated;

import android.util.SparseArray;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.ChoreographerCompat;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIManagerReanimatedHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.swmansion.reanimated.UpdateContext;
import com.swmansion.reanimated.nodes.AlwaysNode;
import com.swmansion.reanimated.nodes.BezierNode;
import com.swmansion.reanimated.nodes.BlockNode;
import com.swmansion.reanimated.nodes.CallFuncNode;
import com.swmansion.reanimated.nodes.ClockNode;
import com.swmansion.reanimated.nodes.ClockOpNode;
import com.swmansion.reanimated.nodes.ConcatNode;
import com.swmansion.reanimated.nodes.CondNode;
import com.swmansion.reanimated.nodes.DebugNode;
import com.swmansion.reanimated.nodes.EventNode;
import com.swmansion.reanimated.nodes.FunctionNode;
import com.swmansion.reanimated.nodes.JSCallNode;
import com.swmansion.reanimated.nodes.Node;
import com.swmansion.reanimated.nodes.NoopNode;
import com.swmansion.reanimated.nodes.OperatorNode;
import com.swmansion.reanimated.nodes.ParamNode;
import com.swmansion.reanimated.nodes.PropsNode;
import com.swmansion.reanimated.nodes.SetNode;
import com.swmansion.reanimated.nodes.StyleNode;
import com.swmansion.reanimated.nodes.TransformNode;
import com.swmansion.reanimated.nodes.ValueNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class NodesManager
implements EventDispatcherListener {
    private static final Double ZERO = 0.0;
    private final SparseArray<Node> mAnimatedNodes = new SparseArray();
    private final Map<String, EventNode> mEventMapping = new HashMap<String, EventNode>();
    private final UIImplementation mUIImplementation;
    private final DeviceEventManagerModule.RCTDeviceEventEmitter mEventEmitter;
    private final ReactChoreographer mReactChoreographer;
    private final GuardedFrameCallback mChoreographerCallback;
    private final UIManagerModule.CustomEventNamesResolver mCustomEventNamesResolver;
    private final AtomicBoolean mCallbackPosted = new AtomicBoolean();
    private final NoopNode mNoopNode;
    private final ReactContext mContext;
    private final UIManagerModule mUIManager;
    private List<OnAnimationFrame> mFrameCallbacks = new ArrayList<OnAnimationFrame>();
    private ConcurrentLinkedQueue<Event> mEventQueue = new ConcurrentLinkedQueue();
    private boolean mWantRunUpdates;
    public double currentFrameTimeMs;
    public final UpdateContext updateContext;
    public Set<String> uiProps = Collections.emptySet();
    public Set<String> nativeProps = Collections.emptySet();
    private Queue<NativeUpdateOperation> mOperationsInBatch = new LinkedList<NativeUpdateOperation>();

    public NodesManager(ReactContext context) {
        this.mContext = context;
        this.mUIManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        this.updateContext = new UpdateContext();
        this.mUIImplementation = this.mUIManager.getUIImplementation();
        this.mCustomEventNamesResolver = this.mUIManager.getDirectEventNamesResolver();
        this.mUIManager.getEventDispatcher().addListener((EventDispatcherListener)this);
        this.mEventEmitter = (DeviceEventManagerModule.RCTDeviceEventEmitter)context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class);
        this.mReactChoreographer = ReactChoreographer.getInstance();
        this.mChoreographerCallback = new GuardedFrameCallback(context){

            protected void doFrameGuarded(long frameTimeNanos) {
                NodesManager.this.onAnimationFrame(frameTimeNanos);
            }
        };
        this.mNoopNode = new NoopNode(this);
    }

    public void onHostPause() {
        if (this.mCallbackPosted.get()) {
            this.stopUpdatingOnAnimationFrame();
            this.mCallbackPosted.set(true);
        }
    }

    public void onHostResume() {
        if (this.mCallbackPosted.getAndSet(false)) {
            this.startUpdatingOnAnimationFrame();
        }
    }

    private void startUpdatingOnAnimationFrame() {
        if (!this.mCallbackPosted.getAndSet(true)) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, (ChoreographerCompat.FrameCallback)this.mChoreographerCallback);
        }
    }

    private void stopUpdatingOnAnimationFrame() {
        if (this.mCallbackPosted.getAndSet(false)) {
            this.mReactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, (ChoreographerCompat.FrameCallback)this.mChoreographerCallback);
        }
    }

    private void onAnimationFrame(long frameTimeNanos) {
        this.currentFrameTimeMs = (double)frameTimeNanos / 1000000.0;
        while (!this.mEventQueue.isEmpty()) {
            this.handleEvent(this.mEventQueue.poll());
        }
        if (!this.mFrameCallbacks.isEmpty()) {
            List<OnAnimationFrame> frameCallbacks = this.mFrameCallbacks;
            this.mFrameCallbacks = new ArrayList<OnAnimationFrame>(frameCallbacks.size());
            int size = frameCallbacks.size();
            for (int i = 0; i < size; ++i) {
                frameCallbacks.get(i).onAnimationFrame();
            }
        }
        if (this.mWantRunUpdates) {
            Node.runUpdates(this.updateContext);
        }
        if (!this.mOperationsInBatch.isEmpty()) {
            final Queue<NativeUpdateOperation> copiedOperationsQueue = this.mOperationsInBatch;
            this.mOperationsInBatch = new LinkedList<NativeUpdateOperation>();
            this.mContext.runOnNativeModulesQueueThread((Runnable)new GuardedRunnable(this.mContext){

                public void runGuarded() {
                    boolean shouldDispatchUpdates = UIManagerReanimatedHelper.isOperationQueueEmpty(NodesManager.this.mUIImplementation);
                    while (!copiedOperationsQueue.isEmpty()) {
                        NativeUpdateOperation op = (NativeUpdateOperation)copiedOperationsQueue.remove();
                        ReactShadowNode shadowNode = NodesManager.this.mUIImplementation.resolveShadowNode(op.mViewTag);
                        if (shadowNode == null) continue;
                        NodesManager.this.mUIManager.updateView(op.mViewTag, shadowNode.getViewClass(), (ReadableMap)op.mNativeProps);
                    }
                    if (shouldDispatchUpdates) {
                        NodesManager.this.mUIImplementation.dispatchViewUpdates(-1);
                    }
                }
            });
        }
        this.mCallbackPosted.set(false);
        this.mWantRunUpdates = false;
        if (!this.mFrameCallbacks.isEmpty() || !this.mEventQueue.isEmpty()) {
            this.startUpdatingOnAnimationFrame();
        }
    }

    public Object getNodeValue(int nodeID) {
        Node node = (Node)this.mAnimatedNodes.get(nodeID);
        if (node != null) {
            return node.value();
        }
        return ZERO;
    }

    public <T extends Node> T findNodeById(int id, Class<T> type) {
        Node node = (Node)this.mAnimatedNodes.get(id);
        if (node == null) {
            if (type == Node.class || type == ValueNode.class) {
                return (T)this.mNoopNode;
            }
            throw new IllegalArgumentException("Requested node with id " + id + " of type " + type + " cannot be found");
        }
        if (type.isInstance(node)) {
            return (T)node;
        }
        throw new IllegalArgumentException("Node with id " + id + " is of incompatible type " + node.getClass() + ", requested type was " + type);
    }

    public void createNode(int nodeID, ReadableMap config) {
        Node node;
        if (this.mAnimatedNodes.get(nodeID) != null) {
            throw new JSApplicationIllegalArgumentException("Animated node with ID " + nodeID + " already exists");
        }
        String type = config.getString("type");
        if ("props".equals(type)) {
            node = new PropsNode(nodeID, config, this, this.mUIImplementation);
        } else if ("style".equals(type)) {
            node = new StyleNode(nodeID, config, this);
        } else if ("transform".equals(type)) {
            node = new TransformNode(nodeID, config, this);
        } else if ("value".equals(type)) {
            node = new ValueNode(nodeID, config, this);
        } else if ("block".equals(type)) {
            node = new BlockNode(nodeID, config, this);
        } else if ("cond".equals(type)) {
            node = new CondNode(nodeID, config, this);
        } else if ("op".equals(type)) {
            node = new OperatorNode(nodeID, config, this);
        } else if ("set".equals(type)) {
            node = new SetNode(nodeID, config, this);
        } else if ("debug".equals(type)) {
            node = new DebugNode(nodeID, config, this);
        } else if ("clock".equals(type)) {
            node = new ClockNode(nodeID, config, this);
        } else if ("clockStart".equals(type)) {
            node = new ClockOpNode.ClockStartNode(nodeID, config, this);
        } else if ("clockStop".equals(type)) {
            node = new ClockOpNode.ClockStopNode(nodeID, config, this);
        } else if ("clockTest".equals(type)) {
            node = new ClockOpNode.ClockTestNode(nodeID, config, this);
        } else if ("call".equals(type)) {
            node = new JSCallNode(nodeID, config, this);
        } else if ("bezier".equals(type)) {
            node = new BezierNode(nodeID, config, this);
        } else if ("event".equals(type)) {
            node = new EventNode(nodeID, config, this);
        } else if ("always".equals(type)) {
            node = new AlwaysNode(nodeID, config, this);
        } else if ("concat".equals(type)) {
            node = new ConcatNode(nodeID, config, this);
        } else if ("param".equals(type)) {
            node = new ParamNode(nodeID, config, this);
        } else if ("func".equals(type)) {
            node = new FunctionNode(nodeID, config, this);
        } else if ("callfunc".equals(type)) {
            node = new CallFuncNode(nodeID, config, this);
        } else {
            throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        }
        this.mAnimatedNodes.put(nodeID, (Object)node);
    }

    public void dropNode(int tag) {
        this.mAnimatedNodes.remove(tag);
    }

    public void connectNodes(int parentID, int childID) {
        Node parentNode = (Node)this.mAnimatedNodes.get(parentID);
        Node childNode = (Node)this.mAnimatedNodes.get(childID);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with ID " + childID + " does not exists");
        }
        parentNode.addChild(childNode);
    }

    public void disconnectNodes(int parentID, int childID) {
        Node parentNode = (Node)this.mAnimatedNodes.get(parentID);
        Node childNode = (Node)this.mAnimatedNodes.get(childID);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with ID " + childID + " does not exists");
        }
        parentNode.removeChild(childNode);
    }

    public void connectNodeToView(int nodeID, int viewTag) {
        Node node = (Node)this.mAnimatedNodes.get(nodeID);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with ID " + nodeID + " does not exists");
        }
        if (!(node instanceof PropsNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsNode.class.getName());
        }
        ((PropsNode)node).connectToView(viewTag);
    }

    public void disconnectNodeFromView(int nodeID, int viewTag) {
        Node node = (Node)this.mAnimatedNodes.get(nodeID);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with ID " + nodeID + " does not exists");
        }
        if (!(node instanceof PropsNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsNode.class.getName());
        }
        ((PropsNode)node).disconnectFromView(viewTag);
    }

    public void enqueueUpdateViewOnNativeThread(int viewTag, WritableMap nativeProps) {
        this.mOperationsInBatch.add(new NativeUpdateOperation(viewTag, nativeProps));
    }

    public void attachEvent(int viewTag, String eventName, int eventNodeID) {
        String key = viewTag + eventName;
        EventNode node = (EventNode)this.mAnimatedNodes.get(eventNodeID);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Event node " + eventNodeID + " does not exists");
        }
        if (this.mEventMapping.containsKey(key)) {
            throw new JSApplicationIllegalArgumentException("Event handler already set for the given view and event type");
        }
        this.mEventMapping.put(key, node);
    }

    public void detachEvent(int viewTag, String eventName, int eventNodeID) {
        String key = viewTag + eventName;
        this.mEventMapping.remove(key);
    }

    public void configureProps(Set<String> nativePropsSet, Set<String> uiPropsSet) {
        this.nativeProps = nativePropsSet;
        this.uiProps = uiPropsSet;
    }

    public void getValue(int nodeID, Callback callback) {
        callback.invoke(new Object[]{((Node)this.mAnimatedNodes.get(nodeID)).value()});
    }

    public void postRunUpdatesAfterAnimation() {
        this.mWantRunUpdates = true;
        this.startUpdatingOnAnimationFrame();
    }

    public void postOnAnimation(OnAnimationFrame onAnimationFrame) {
        this.mFrameCallbacks.add(onAnimationFrame);
        this.startUpdatingOnAnimationFrame();
    }

    public void onEventDispatch(Event event) {
        if (UiThreadUtil.isOnUiThread()) {
            this.handleEvent(event);
        } else {
            this.mEventQueue.offer(event);
            this.startUpdatingOnAnimationFrame();
        }
    }

    private void handleEvent(Event event) {
        if (!this.mEventMapping.isEmpty()) {
            String eventName = this.mCustomEventNamesResolver.resolveCustomEventName(event.getEventName());
            int viewTag = event.getViewTag();
            String key = viewTag + eventName;
            EventNode node = this.mEventMapping.get(key);
            if (node != null) {
                event.dispatch((RCTEventEmitter)node);
            }
        }
    }

    public void sendEvent(String name, WritableMap body) {
        this.mEventEmitter.emit(name, (Object)body);
    }

    public void setValue(int nodeID, Double newValue) {
        Node node = (Node)this.mAnimatedNodes.get(nodeID);
        if (node != null) {
            ((ValueNode)node).setValue(newValue);
        }
    }

    private final class NativeUpdateOperation {
        public int mViewTag;
        public WritableMap mNativeProps;

        public NativeUpdateOperation(int viewTag, WritableMap nativeProps) {
            this.mViewTag = viewTag;
            this.mNativeProps = nativeProps;
        }
    }

    public static interface OnAnimationFrame {
        public void onAnimationFrame();
    }
}

