/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler.react;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.swmansion.gesturehandler.FlingGestureHandler;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.LongPressGestureHandler;
import com.swmansion.gesturehandler.NativeViewGestureHandler;
import com.swmansion.gesturehandler.OnTouchEventListener;
import com.swmansion.gesturehandler.PanGestureHandler;
import com.swmansion.gesturehandler.PinchGestureHandler;
import com.swmansion.gesturehandler.RotationGestureHandler;
import com.swmansion.gesturehandler.TapGestureHandler;
import com.swmansion.gesturehandler.react.RNGestureHandlerEnabledRootView;
import com.swmansion.gesturehandler.react.RNGestureHandlerEvent;
import com.swmansion.gesturehandler.react.RNGestureHandlerEventDataExtractor;
import com.swmansion.gesturehandler.react.RNGestureHandlerInteractionManager;
import com.swmansion.gesturehandler.react.RNGestureHandlerRegistry;
import com.swmansion.gesturehandler.react.RNGestureHandlerRootHelper;
import com.swmansion.gesturehandler.react.RNGestureHandlerStateChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="RNGestureHandlerModule")
public class RNGestureHandlerModule
extends ReactContextBaseJavaModule {
    public static final String MODULE_NAME = "RNGestureHandlerModule";
    private static final String KEY_SHOULD_CANCEL_WHEN_OUTSIDE = "shouldCancelWhenOutside";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_HIT_SLOP = "hitSlop";
    private static final String KEY_HIT_SLOP_LEFT = "left";
    private static final String KEY_HIT_SLOP_TOP = "top";
    private static final String KEY_HIT_SLOP_RIGHT = "right";
    private static final String KEY_HIT_SLOP_BOTTOM = "bottom";
    private static final String KEY_HIT_SLOP_VERTICAL = "vertical";
    private static final String KEY_HIT_SLOP_HORIZONTAL = "horizontal";
    private static final String KEY_HIT_SLOP_WIDTH = "width";
    private static final String KEY_HIT_SLOP_HEIGHT = "height";
    private static final String KEY_NATIVE_VIEW_SHOULD_ACTIVATE_ON_START = "shouldActivateOnStart";
    private static final String KEY_NATIVE_VIEW_DISALLOW_INTERRUPTION = "disallowInterruption";
    private static final String KEY_TAP_NUMBER_OF_TAPS = "numberOfTaps";
    private static final String KEY_TAP_MAX_DURATION_MS = "maxDurationMs";
    private static final String KEY_TAP_MAX_DELAY_MS = "maxDelayMs";
    private static final String KEY_TAP_MAX_DELTA_X = "maxDeltaX";
    private static final String KEY_TAP_MAX_DELTA_Y = "maxDeltaY";
    private static final String KEY_TAP_MAX_DIST = "maxDist";
    private static final String KEY_TAP_MIN_POINTERS = "minPointers";
    private static final String KEY_LONG_PRESS_MIN_DURATION_MS = "minDurationMs";
    private static final String KEY_LONG_PRESS_MAX_DIST = "maxDist";
    private static final String KEY_PAN_ACTIVE_OFFSET_X_START = "activeOffsetXStart";
    private static final String KEY_PAN_ACTIVE_OFFSET_X_END = "activeOffsetXEnd";
    private static final String KEY_PAN_FAIL_OFFSET_RANGE_X_START = "failOffsetXStart";
    private static final String KEY_PAN_FAIL_OFFSET_RANGE_X_END = "failOffsetXEnd";
    private static final String KEY_PAN_ACTIVE_OFFSET_Y_START = "activeOffsetYStart";
    private static final String KEY_PAN_ACTIVE_OFFSET_Y_END = "activeOffsetYEnd";
    private static final String KEY_PAN_FAIL_OFFSET_RANGE_Y_START = "failOffsetYStart";
    private static final String KEY_PAN_FAIL_OFFSET_RANGE_Y_END = "failOffsetYEnd";
    private static final String KEY_PAN_MIN_DIST = "minDist";
    private static final String KEY_PAN_MIN_VELOCITY = "minVelocity";
    private static final String KEY_PAN_MIN_VELOCITY_X = "minVelocityX";
    private static final String KEY_PAN_MIN_VELOCITY_Y = "minVelocityY";
    private static final String KEY_PAN_MIN_POINTERS = "minPointers";
    private static final String KEY_PAN_MAX_POINTERS = "maxPointers";
    private static final String KEY_PAN_AVG_TOUCHES = "avgTouches";
    private static final String KEY_NUMBER_OF_POINTERS = "numberOfPointers";
    private static final String KEY_DIRECTION = "direction";
    private OnTouchEventListener mEventListener = new OnTouchEventListener(){

        public void onTouchEvent(GestureHandler handler, MotionEvent event) {
            RNGestureHandlerModule.this.onTouchEvent(handler, event);
        }

        public void onStateChange(GestureHandler handler, int newState, int oldState) {
            RNGestureHandlerModule.this.onStateChange(handler, newState, oldState);
        }
    };
    private HandlerFactory[] mHandlerFactories = new HandlerFactory[]{new NativeViewGestureHandlerFactory(), new TapGestureHandlerFactory(), new LongPressGestureHandlerFactory(), new PanGestureHandlerFactory(), new PinchGestureHandlerFactory(), new RotationGestureHandlerFactory(), new FlingGestureHandlerFactory()};
    private final RNGestureHandlerRegistry mRegistry = new RNGestureHandlerRegistry();
    private RNGestureHandlerInteractionManager mInteractionManager = new RNGestureHandlerInteractionManager();
    private List<RNGestureHandlerRootHelper> mRoots = new ArrayList<RNGestureHandlerRootHelper>();
    private List<Integer> mEnqueuedRootViewInit = new ArrayList<Integer>();

    public RNGestureHandlerModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return MODULE_NAME;
    }

    @ReactMethod
    public void createGestureHandler(String handlerName, int handlerTag, ReadableMap config) {
        for (int i = 0; i < this.mHandlerFactories.length; ++i) {
            HandlerFactory handlerFactory = this.mHandlerFactories[i];
            if (!handlerFactory.getName().equals(handlerName)) continue;
            Object handler = handlerFactory.create((Context)this.getReactApplicationContext());
            ((GestureHandler)handler).setTag(handlerTag);
            ((GestureHandler)handler).setOnTouchEventListener(this.mEventListener);
            this.mRegistry.registerHandler((GestureHandler)handler);
            this.mInteractionManager.configureInteractions((GestureHandler)handler, config);
            handlerFactory.configure(handler, config);
            return;
        }
        throw new JSApplicationIllegalArgumentException("Invalid handler name " + handlerName);
    }

    @ReactMethod
    public void attachGestureHandler(int handlerTag, int viewTag) {
        this.tryInitializeHandlerForReactRootView(viewTag);
        if (!this.mRegistry.attachHandlerToView(handlerTag, viewTag)) {
            throw new JSApplicationIllegalArgumentException("Handler with tag " + handlerTag + " does not exists");
        }
    }

    @ReactMethod
    public void updateGestureHandler(int handlerTag, ReadableMap config) {
        HandlerFactory factory;
        GestureHandler handler = this.mRegistry.getHandler(handlerTag);
        if (handler != null && (factory = this.findFactoryForHandler(handler)) != null) {
            this.mInteractionManager.dropRelationsForHandlerWithTag(handlerTag);
            this.mInteractionManager.configureInteractions(handler, config);
            factory.configure(handler, config);
        }
    }

    @ReactMethod
    public void dropGestureHandler(int handlerTag) {
        this.mInteractionManager.dropRelationsForHandlerWithTag(handlerTag);
        this.mRegistry.dropHandler(handlerTag);
    }

    @ReactMethod
    public void handleSetJSResponder(int viewTag, boolean blockNativeResponder) {
        RNGestureHandlerRootHelper rootView;
        if (this.mRegistry != null && (rootView = this.findRootHelperForViewAncestor(viewTag)) != null) {
            rootView.handleSetJSResponder(viewTag, blockNativeResponder);
        }
    }

    @ReactMethod
    public void handleClearJSResponder() {
    }

    @Nullable
    public Map getConstants() {
        return MapBuilder.of((Object)"State", (Object)MapBuilder.of((Object)"UNDETERMINED", (Object)0, (Object)"BEGAN", (Object)2, (Object)"ACTIVE", (Object)4, (Object)"CANCELLED", (Object)3, (Object)"FAILED", (Object)1, (Object)"END", (Object)5), (Object)"Direction", (Object)MapBuilder.of((Object)"RIGHT", (Object)1, (Object)"LEFT", (Object)2, (Object)"UP", (Object)4, (Object)"DOWN", (Object)8));
    }

    public RNGestureHandlerRegistry getRegistry() {
        return this.mRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCatalystInstanceDestroy() {
        this.mRegistry.dropAllHandlers();
        this.mInteractionManager.reset();
        List<RNGestureHandlerRootHelper> list = this.mRoots;
        synchronized (list) {
            while (!this.mRoots.isEmpty()) {
                int sizeBefore = this.mRoots.size();
                RNGestureHandlerRootHelper root = this.mRoots.get(0);
                ReactRootView reactRootView = root.getRootView();
                if (reactRootView instanceof RNGestureHandlerEnabledRootView) {
                    ((RNGestureHandlerEnabledRootView)reactRootView).tearDown();
                } else {
                    root.tearDown();
                }
                if (this.mRoots.size() < sizeBefore) continue;
                throw new IllegalStateException("Expected root helper to get unregistered while tearing down");
            }
        }
        super.onCatalystInstanceDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitializeHandlerForReactRootView(int ancestorViewTag) {
        UIManagerModule uiManager = (UIManagerModule)this.getReactApplicationContext().getNativeModule(UIManagerModule.class);
        final int rootViewTag = uiManager.resolveRootTagFromReactTag(ancestorViewTag);
        if (rootViewTag < 1) {
            throw new JSApplicationIllegalArgumentException("Could find root view for a given ancestor with tag " + ancestorViewTag);
        }
        List<Object> list = this.mRoots;
        synchronized (list) {
            for (int i = 0; i < this.mRoots.size(); ++i) {
                RNGestureHandlerRootHelper root = this.mRoots.get(i);
                if (root.getRootView().getRootViewTag() != rootViewTag) continue;
                return;
            }
        }
        list = this.mEnqueuedRootViewInit;
        synchronized (list) {
            if (this.mEnqueuedRootViewInit.contains(rootViewTag)) {
                return;
            }
            this.mEnqueuedRootViewInit.add(rootViewTag);
        }
        uiManager.addUIBlock(new UIBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                View view = nativeViewHierarchyManager.resolveView(rootViewTag);
                if (view instanceof RNGestureHandlerEnabledRootView) {
                    ((RNGestureHandlerEnabledRootView)view).initialize();
                }
                List list = RNGestureHandlerModule.this.mEnqueuedRootViewInit;
                synchronized (list) {
                    RNGestureHandlerModule.this.mEnqueuedRootViewInit.remove(new Integer(rootViewTag));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRootHelper(RNGestureHandlerRootHelper root) {
        List<RNGestureHandlerRootHelper> list = this.mRoots;
        synchronized (list) {
            if (this.mRoots.contains(root)) {
                throw new IllegalStateException("Root helper" + root + " already registered");
            }
            this.mRoots.add(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRootHelper(RNGestureHandlerRootHelper root) {
        List<RNGestureHandlerRootHelper> list = this.mRoots;
        synchronized (list) {
            this.mRoots.remove(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RNGestureHandlerRootHelper findRootHelperForViewAncestor(int viewTag) {
        UIManagerModule uiManager = (UIManagerModule)this.getReactApplicationContext().getNativeModule(UIManagerModule.class);
        int rootViewTag = uiManager.resolveRootTagFromReactTag(viewTag);
        if (rootViewTag < 1) {
            return null;
        }
        List<RNGestureHandlerRootHelper> list = this.mRoots;
        synchronized (list) {
            for (int i = 0; i < this.mRoots.size(); ++i) {
                RNGestureHandlerRootHelper root = this.mRoots.get(i);
                if (root.getRootView().getRootViewTag() != rootViewTag) continue;
                return root;
            }
        }
        return null;
    }

    @Nullable
    private HandlerFactory findFactoryForHandler(GestureHandler handler) {
        for (int i = 0; i < this.mHandlerFactories.length; ++i) {
            HandlerFactory factory = this.mHandlerFactories[i];
            if (!factory.getType().equals(handler.getClass())) continue;
            return factory;
        }
        return null;
    }

    private void onTouchEvent(GestureHandler handler, MotionEvent motionEvent) {
        if (handler.getTag() < 0) {
            return;
        }
        if (handler.getState() == 4) {
            HandlerFactory handlerFactory = this.findFactoryForHandler(handler);
            EventDispatcher eventDispatcher = ((UIManagerModule)this.getReactApplicationContext().getNativeModule(UIManagerModule.class)).getEventDispatcher();
            RNGestureHandlerEvent event = RNGestureHandlerEvent.obtain(handler, handlerFactory);
            eventDispatcher.dispatchEvent((Event)event);
        }
    }

    private void onStateChange(GestureHandler handler, int newState, int oldState) {
        if (handler.getTag() < 0) {
            return;
        }
        HandlerFactory handlerFactory = this.findFactoryForHandler(handler);
        EventDispatcher eventDispatcher = ((UIManagerModule)this.getReactApplicationContext().getNativeModule(UIManagerModule.class)).getEventDispatcher();
        RNGestureHandlerStateChangeEvent event = RNGestureHandlerStateChangeEvent.obtain(handler, newState, oldState, handlerFactory);
        eventDispatcher.dispatchEvent((Event)event);
    }

    private static void handleHitSlopProperty(GestureHandler handler, ReadableMap config) {
        if (config.getType(KEY_HIT_SLOP) == ReadableType.Number) {
            float hitSlop = PixelUtil.toPixelFromDIP((double)config.getDouble(KEY_HIT_SLOP));
            handler.setHitSlop(hitSlop, hitSlop, hitSlop, hitSlop, Float.NaN, Float.NaN);
        } else {
            ReadableMap hitSlop = config.getMap(KEY_HIT_SLOP);
            float left = Float.NaN;
            float top = Float.NaN;
            float right = Float.NaN;
            float bottom = Float.NaN;
            float width = Float.NaN;
            float height = Float.NaN;
            if (hitSlop.hasKey(KEY_HIT_SLOP_HORIZONTAL)) {
                float horizontalPad;
                left = right = (horizontalPad = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_HORIZONTAL)));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_VERTICAL)) {
                float verticalPad;
                top = bottom = (verticalPad = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_VERTICAL)));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_LEFT)) {
                left = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_LEFT));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_TOP)) {
                top = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_TOP));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_RIGHT)) {
                right = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_RIGHT));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_BOTTOM)) {
                bottom = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_BOTTOM));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_WIDTH)) {
                width = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_WIDTH));
            }
            if (hitSlop.hasKey(KEY_HIT_SLOP_HEIGHT)) {
                height = PixelUtil.toPixelFromDIP((double)hitSlop.getDouble(KEY_HIT_SLOP_HEIGHT));
            }
            handler.setHitSlop(left, top, right, bottom, width, height);
        }
    }

    private static class RotationGestureHandlerFactory
    extends HandlerFactory<RotationGestureHandler> {
        private RotationGestureHandlerFactory() {
        }

        @Override
        public Class<RotationGestureHandler> getType() {
            return RotationGestureHandler.class;
        }

        @Override
        public String getName() {
            return "RotationGestureHandler";
        }

        @Override
        public RotationGestureHandler create(Context context) {
            return new RotationGestureHandler();
        }

        @Override
        public void extractEventData(RotationGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("rotation", handler.getRotation());
            eventData.putDouble("anchorX", (double)PixelUtil.toDIPFromPixel((float)handler.getAnchorX()));
            eventData.putDouble("anchorY", (double)PixelUtil.toDIPFromPixel((float)handler.getAnchorY()));
            eventData.putDouble("velocity", handler.getVelocity());
        }
    }

    private static class FlingGestureHandlerFactory
    extends HandlerFactory<FlingGestureHandler> {
        private FlingGestureHandlerFactory() {
        }

        @Override
        public Class<FlingGestureHandler> getType() {
            return FlingGestureHandler.class;
        }

        @Override
        public String getName() {
            return "FlingGestureHandler";
        }

        @Override
        public FlingGestureHandler create(Context context) {
            return new FlingGestureHandler();
        }

        @Override
        public void configure(FlingGestureHandler handler, ReadableMap config) {
            super.configure(handler, config);
            if (config.hasKey(RNGestureHandlerModule.KEY_NUMBER_OF_POINTERS)) {
                handler.setNumberOfPointersRequired(config.getInt(RNGestureHandlerModule.KEY_NUMBER_OF_POINTERS));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_DIRECTION)) {
                handler.setDirection(config.getInt(RNGestureHandlerModule.KEY_DIRECTION));
            }
        }

        @Override
        public void extractEventData(FlingGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("x", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionX()));
            eventData.putDouble("y", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionY()));
            eventData.putDouble("absoluteX", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionX()));
            eventData.putDouble("absoluteY", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionY()));
        }
    }

    private static class PinchGestureHandlerFactory
    extends HandlerFactory<PinchGestureHandler> {
        private PinchGestureHandlerFactory() {
        }

        @Override
        public Class<PinchGestureHandler> getType() {
            return PinchGestureHandler.class;
        }

        @Override
        public String getName() {
            return "PinchGestureHandler";
        }

        @Override
        public PinchGestureHandler create(Context context) {
            return new PinchGestureHandler();
        }

        @Override
        public void extractEventData(PinchGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("scale", handler.getScale());
            eventData.putDouble("focalX", (double)PixelUtil.toDIPFromPixel((float)handler.getFocalPointX()));
            eventData.putDouble("focalY", (double)PixelUtil.toDIPFromPixel((float)handler.getFocalPointY()));
            eventData.putDouble("velocity", handler.getVelocity());
        }
    }

    private static class PanGestureHandlerFactory
    extends HandlerFactory<PanGestureHandler> {
        private PanGestureHandlerFactory() {
        }

        @Override
        public Class<PanGestureHandler> getType() {
            return PanGestureHandler.class;
        }

        @Override
        public String getName() {
            return "PanGestureHandler";
        }

        @Override
        public PanGestureHandler create(Context context) {
            return new PanGestureHandler(context);
        }

        @Override
        public void configure(PanGestureHandler handler, ReadableMap config) {
            super.configure(handler, config);
            boolean hasCustomActivationCriteria = false;
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_X_START)) {
                handler.setActiveOffsetXStart(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_X_START)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_X_END)) {
                handler.setActiveOffsetXEnd(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_X_END)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_X_START)) {
                handler.setFailOffsetXStart(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_X_START)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_X_END)) {
                handler.setFailOffsetXEnd(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_X_END)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_Y_START)) {
                handler.setActiveOffsetYStart(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_Y_START)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_Y_END)) {
                handler.setActiveOffsetYEnd(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_ACTIVE_OFFSET_Y_END)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_Y_START)) {
                handler.setFailOffsetYStart(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_Y_START)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_Y_END)) {
                handler.setFailOffsetYEnd(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_FAIL_OFFSET_RANGE_Y_END)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY)) {
                handler.setMinVelocity(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY_X)) {
                handler.setMinVelocityX(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY_X)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY_Y)) {
                handler.setMinVelocityY(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_MIN_VELOCITY_Y)));
                hasCustomActivationCriteria = true;
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_MIN_DIST)) {
                handler.setMinDist(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_PAN_MIN_DIST)));
            } else if (hasCustomActivationCriteria) {
                handler.setMinDist(Float.MAX_VALUE);
            }
            if (config.hasKey("minPointers")) {
                handler.setMinPointers(config.getInt("minPointers"));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_MAX_POINTERS)) {
                handler.setMaxPointers(config.getInt(RNGestureHandlerModule.KEY_PAN_MAX_POINTERS));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_PAN_AVG_TOUCHES)) {
                handler.setAverageTouches(config.getBoolean(RNGestureHandlerModule.KEY_PAN_AVG_TOUCHES));
            }
        }

        @Override
        public void extractEventData(PanGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("x", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionX()));
            eventData.putDouble("y", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionY()));
            eventData.putDouble("absoluteX", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionX()));
            eventData.putDouble("absoluteY", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionY()));
            eventData.putDouble("translationX", (double)PixelUtil.toDIPFromPixel((float)handler.getTranslationX()));
            eventData.putDouble("translationY", (double)PixelUtil.toDIPFromPixel((float)handler.getTranslationY()));
            eventData.putDouble("velocityX", (double)PixelUtil.toDIPFromPixel((float)handler.getVelocityX()));
            eventData.putDouble("velocityY", (double)PixelUtil.toDIPFromPixel((float)handler.getVelocityY()));
        }
    }

    private static class LongPressGestureHandlerFactory
    extends HandlerFactory<LongPressGestureHandler> {
        private LongPressGestureHandlerFactory() {
        }

        @Override
        public Class<LongPressGestureHandler> getType() {
            return LongPressGestureHandler.class;
        }

        @Override
        public String getName() {
            return "LongPressGestureHandler";
        }

        @Override
        public LongPressGestureHandler create(Context context) {
            return new LongPressGestureHandler(context);
        }

        @Override
        public void configure(LongPressGestureHandler handler, ReadableMap config) {
            super.configure(handler, config);
            if (config.hasKey(RNGestureHandlerModule.KEY_LONG_PRESS_MIN_DURATION_MS)) {
                handler.setMinDurationMs(config.getInt(RNGestureHandlerModule.KEY_LONG_PRESS_MIN_DURATION_MS));
            }
            if (config.hasKey("maxDist")) {
                handler.setMaxDist(PixelUtil.toPixelFromDIP((double)config.getDouble("maxDist")));
            }
        }

        @Override
        public void extractEventData(LongPressGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("x", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionX()));
            eventData.putDouble("y", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionY()));
            eventData.putDouble("absoluteX", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionX()));
            eventData.putDouble("absoluteY", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionY()));
        }
    }

    private static class TapGestureHandlerFactory
    extends HandlerFactory<TapGestureHandler> {
        private TapGestureHandlerFactory() {
        }

        @Override
        public Class<TapGestureHandler> getType() {
            return TapGestureHandler.class;
        }

        @Override
        public String getName() {
            return "TapGestureHandler";
        }

        @Override
        public TapGestureHandler create(Context context) {
            return new TapGestureHandler();
        }

        @Override
        public void configure(TapGestureHandler handler, ReadableMap config) {
            super.configure(handler, config);
            if (config.hasKey(RNGestureHandlerModule.KEY_TAP_NUMBER_OF_TAPS)) {
                handler.setNumberOfTaps(config.getInt(RNGestureHandlerModule.KEY_TAP_NUMBER_OF_TAPS));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_TAP_MAX_DURATION_MS)) {
                handler.setMaxDurationMs(config.getInt(RNGestureHandlerModule.KEY_TAP_MAX_DURATION_MS));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_TAP_MAX_DELAY_MS)) {
                handler.setMaxDelayMs(config.getInt(RNGestureHandlerModule.KEY_TAP_MAX_DELAY_MS));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_TAP_MAX_DELTA_X)) {
                handler.setMaxDx(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_TAP_MAX_DELTA_X)));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_TAP_MAX_DELTA_Y)) {
                handler.setMaxDy(PixelUtil.toPixelFromDIP((double)config.getDouble(RNGestureHandlerModule.KEY_TAP_MAX_DELTA_Y)));
            }
            if (config.hasKey("maxDist")) {
                handler.setMaxDist(PixelUtil.toPixelFromDIP((double)config.getDouble("maxDist")));
            }
            if (config.hasKey("minPointers")) {
                handler.setMinNumberOfPointers(config.getInt("minPointers"));
            }
        }

        @Override
        public void extractEventData(TapGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putDouble("x", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionX()));
            eventData.putDouble("y", (double)PixelUtil.toDIPFromPixel((float)handler.getLastRelativePositionY()));
            eventData.putDouble("absoluteX", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionX()));
            eventData.putDouble("absoluteY", (double)PixelUtil.toDIPFromPixel((float)handler.getLastAbsolutePositionY()));
        }
    }

    private static class NativeViewGestureHandlerFactory
    extends HandlerFactory<NativeViewGestureHandler> {
        private NativeViewGestureHandlerFactory() {
        }

        @Override
        public Class<NativeViewGestureHandler> getType() {
            return NativeViewGestureHandler.class;
        }

        @Override
        public String getName() {
            return "NativeViewGestureHandler";
        }

        @Override
        public NativeViewGestureHandler create(Context context) {
            return new NativeViewGestureHandler();
        }

        @Override
        public void configure(NativeViewGestureHandler handler, ReadableMap config) {
            super.configure(handler, config);
            if (config.hasKey(RNGestureHandlerModule.KEY_NATIVE_VIEW_SHOULD_ACTIVATE_ON_START)) {
                handler.setShouldActivateOnStart(config.getBoolean(RNGestureHandlerModule.KEY_NATIVE_VIEW_SHOULD_ACTIVATE_ON_START));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_NATIVE_VIEW_DISALLOW_INTERRUPTION)) {
                handler.setDisallowInterruption(config.getBoolean(RNGestureHandlerModule.KEY_NATIVE_VIEW_DISALLOW_INTERRUPTION));
            }
        }

        @Override
        public void extractEventData(NativeViewGestureHandler handler, WritableMap eventData) {
            super.extractEventData(handler, eventData);
            eventData.putBoolean("pointerInside", handler.isWithinBounds());
        }
    }

    private static abstract class HandlerFactory<T extends GestureHandler>
    implements RNGestureHandlerEventDataExtractor<T> {
        private HandlerFactory() {
        }

        public abstract Class<T> getType();

        public abstract String getName();

        public abstract T create(Context var1);

        public void configure(T handler, ReadableMap config) {
            if (config.hasKey(RNGestureHandlerModule.KEY_SHOULD_CANCEL_WHEN_OUTSIDE)) {
                ((GestureHandler)handler).setShouldCancelWhenOutside(config.getBoolean(RNGestureHandlerModule.KEY_SHOULD_CANCEL_WHEN_OUTSIDE));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_ENABLED)) {
                ((GestureHandler)handler).setEnabled(config.getBoolean(RNGestureHandlerModule.KEY_ENABLED));
            }
            if (config.hasKey(RNGestureHandlerModule.KEY_HIT_SLOP)) {
                RNGestureHandlerModule.handleHitSlopProperty(handler, config);
            }
        }

        @Override
        public void extractEventData(T handler, WritableMap eventData) {
            eventData.putDouble(RNGestureHandlerModule.KEY_NUMBER_OF_POINTERS, (double)((GestureHandler)handler).getNumberOfPointers());
        }
    }
}

