/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler.react;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.ViewGroup;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;

public class RNGestureHandlerButtonViewManager
extends ViewGroupManager<ButtonViewGroup> {
    public String getName() {
        return "RNGestureHandlerButton";
    }

    public ButtonViewGroup createViewInstance(ThemedReactContext context) {
        return new ButtonViewGroup((Context)context);
    }

    @ReactProp(name="foreground")
    @TargetApi(value=23)
    public void setForeground(ButtonViewGroup view, boolean useDrawableOnForeground) {
        view.setUseDrawableOnForeground(useDrawableOnForeground);
    }

    @ReactProp(name="borderless")
    public void setBorderless(ButtonViewGroup view, boolean useBorderlessDrawable) {
        view.setUseBorderlessDrawable(useBorderlessDrawable);
    }

    @ReactProp(name="enabled")
    public void setEnabled(ButtonViewGroup view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="borderRadius")
    public void setBorderRadius(ButtonViewGroup view, float borderRadius) {
        view.setBorderRadius(borderRadius);
    }

    @ReactProp(name="rippleColor")
    public void setRippleColor(ButtonViewGroup view, Integer rippleColor) {
        view.setRippleColor(rippleColor);
    }

    protected void onAfterUpdateTransaction(ButtonViewGroup view) {
        view.updateBackground();
    }

    static class ButtonViewGroup
    extends ViewGroup {
        static TypedValue sResolveOutValue = new TypedValue();
        static ButtonViewGroup sResponder;
        int mBackgroundColor = 0;
        Integer mRippleColor;
        boolean mUseForeground = false;
        boolean mUseBorderless = false;
        float mBorderRadius = 0.0f;
        boolean mNeedBackgroundUpdate = false;

        public ButtonViewGroup(Context context) {
            super(context);
            this.setClickable(true);
            this.setFocusable(true);
            this.mNeedBackgroundUpdate = true;
        }

        public void setBackgroundColor(int color) {
            this.mBackgroundColor = color;
            this.mNeedBackgroundUpdate = true;
        }

        public void setRippleColor(Integer color) {
            this.mRippleColor = color;
            this.mNeedBackgroundUpdate = true;
        }

        public void setBorderRadius(float borderRadius) {
            this.mBorderRadius = borderRadius * this.getResources().getDisplayMetrics().density;
            this.mNeedBackgroundUpdate = true;
        }

        private Drawable applyRippleEffectWhenNeeded(Drawable selectable) {
            if (this.mRippleColor != null && selectable != null && Build.VERSION.SDK_INT >= 21 && selectable instanceof RippleDrawable) {
                int[][] states = new int[][]{{16842910}};
                int[] colors = new int[]{this.mRippleColor};
                ColorStateList colorStateList = new ColorStateList((int[][])states, colors);
                ((RippleDrawable)selectable).setColor(colorStateList);
            }
            return selectable;
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            if (super.onInterceptTouchEvent(ev)) {
                return true;
            }
            this.onTouchEvent(ev);
            return this.isPressed();
        }

        private void updateBackground() {
            if (!this.mNeedBackgroundUpdate) {
                return;
            }
            this.mNeedBackgroundUpdate = false;
            if (this.mBackgroundColor == 0) {
                this.setBackground(null);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.setForeground(null);
            }
            if (this.mUseForeground && Build.VERSION.SDK_INT >= 23) {
                this.setForeground(this.applyRippleEffectWhenNeeded(this.createSelectableDrawable()));
                if (this.mBackgroundColor != 0) {
                    this.setBackgroundColor(this.mBackgroundColor);
                }
            } else if (this.mBackgroundColor == 0 && this.mRippleColor == null) {
                this.setBackground(this.createSelectableDrawable());
            } else {
                PaintDrawable colorDrawable = new PaintDrawable(this.mBackgroundColor);
                Drawable selectable = this.createSelectableDrawable();
                if (this.mBorderRadius != 0.0f) {
                    colorDrawable.setCornerRadius(this.mBorderRadius);
                    if (Build.VERSION.SDK_INT >= 21 && selectable instanceof RippleDrawable) {
                        PaintDrawable mask = new PaintDrawable(-1);
                        mask.setCornerRadius(this.mBorderRadius);
                        ((RippleDrawable)selectable).setDrawableByLayerId(16908334, (Drawable)mask);
                    }
                }
                this.applyRippleEffectWhenNeeded(selectable);
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{colorDrawable, selectable});
                this.setBackground((Drawable)layerDrawable);
            }
        }

        public void setUseDrawableOnForeground(boolean useForeground) {
            this.mUseForeground = useForeground;
            this.mNeedBackgroundUpdate = true;
        }

        public void setUseBorderlessDrawable(boolean useBorderless) {
            this.mUseBorderless = useBorderless;
        }

        private Drawable createSelectableDrawable() {
            int version = Build.VERSION.SDK_INT;
            String identifier = this.mUseBorderless && version >= 21 ? "selectableItemBackgroundBorderless" : "selectableItemBackground";
            int attrID = this.getResources().getIdentifier(identifier, "attr", "android");
            this.getContext().getTheme().resolveAttribute(attrID, sResolveOutValue, true);
            if (version >= 21) {
                return this.getResources().getDrawable(ButtonViewGroup.sResolveOutValue.resourceId, this.getContext().getTheme());
            }
            return this.getResources().getDrawable(ButtonViewGroup.sResolveOutValue.resourceId);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        public void drawableHotspotChanged(float x, float y) {
            if (sResponder == null || sResponder == this) {
                super.drawableHotspotChanged(x, y);
            }
        }

        public void setPressed(boolean pressed) {
            if (pressed && sResponder == null) {
                sResponder = this;
            }
            if (!pressed || sResponder == this) {
                super.setPressed(pressed);
            }
            if (!pressed && sResponder == this) {
                sResponder = null;
            }
        }

        public void dispatchDrawableHotspotChanged(float x, float y) {
        }
    }
}

