/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.GestureUtils;

public class PanGestureHandler
extends GestureHandler<PanGestureHandler> {
    private static float MIN_VALUE_IGNORE = Float.MAX_VALUE;
    private static float MAX_VALUE_IGNORE = Float.MIN_VALUE;
    private static int DEFAULT_MIN_POINTERS = 1;
    private static int DEFAULT_MAX_POINTERS = 10;
    private float mMinDistSq = MAX_VALUE_IGNORE;
    private float mActiveOffsetXStart = MIN_VALUE_IGNORE;
    private float mActiveOffsetXEnd = MAX_VALUE_IGNORE;
    private float mFailOffsetXStart = MAX_VALUE_IGNORE;
    private float mFailOffsetXEnd = MIN_VALUE_IGNORE;
    private float mActiveOffsetYStart = MIN_VALUE_IGNORE;
    private float mActiveOffsetYEnd = MAX_VALUE_IGNORE;
    private float mFailOffsetYStart = MAX_VALUE_IGNORE;
    private float mFailOffsetYEnd = MIN_VALUE_IGNORE;
    private float mMinVelocityX = MIN_VALUE_IGNORE;
    private float mMinVelocityY = MIN_VALUE_IGNORE;
    private float mMinVelocitySq = MIN_VALUE_IGNORE;
    private int mMinPointers = DEFAULT_MIN_POINTERS;
    private int mMaxPointers = DEFAULT_MAX_POINTERS;
    private float mStartX;
    private float mStartY;
    private float mOffsetX;
    private float mOffsetY;
    private float mLastX;
    private float mLastY;
    private float mLastVelocityX;
    private float mLastVelocityY;
    private VelocityTracker mVelocityTracker;
    private boolean mAverageTouches;

    public PanGestureHandler(Context context) {
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        int touchSlop = vc.getScaledTouchSlop();
        this.mMinDistSq = touchSlop * touchSlop;
    }

    public PanGestureHandler setActiveOffsetXStart(float activeOffsetXStart) {
        this.mActiveOffsetXStart = activeOffsetXStart;
        return this;
    }

    public PanGestureHandler setActiveOffsetXEnd(float activeOffsetXEnd) {
        this.mActiveOffsetXEnd = activeOffsetXEnd;
        return this;
    }

    public PanGestureHandler setFailOffsetXStart(float failOffsetXStart) {
        this.mFailOffsetXStart = failOffsetXStart;
        return this;
    }

    public PanGestureHandler setFailOffsetXEnd(float failOffsetXEnd) {
        this.mFailOffsetXEnd = failOffsetXEnd;
        return this;
    }

    public PanGestureHandler setActiveOffsetYStart(float activeOffsetYStart) {
        this.mActiveOffsetYStart = activeOffsetYStart;
        return this;
    }

    public PanGestureHandler setActiveOffsetYEnd(float activeOffsetYEnd) {
        this.mActiveOffsetYEnd = activeOffsetYEnd;
        return this;
    }

    public PanGestureHandler setFailOffsetYStart(float failOffsetYStart) {
        this.mFailOffsetYStart = failOffsetYStart;
        return this;
    }

    public PanGestureHandler setFailOffsetYEnd(float failOffsetYEnd) {
        this.mFailOffsetYEnd = failOffsetYEnd;
        return this;
    }

    public PanGestureHandler setMinDist(float minDist) {
        this.mMinDistSq = minDist * minDist;
        return this;
    }

    public PanGestureHandler setMinPointers(int minPointers) {
        this.mMinPointers = minPointers;
        return this;
    }

    public PanGestureHandler setMaxPointers(int maxPointers) {
        this.mMaxPointers = maxPointers;
        return this;
    }

    public PanGestureHandler setAverageTouches(boolean averageTouches) {
        this.mAverageTouches = averageTouches;
        return this;
    }

    public PanGestureHandler setMinVelocity(float minVelocity) {
        this.mMinVelocitySq = minVelocity * minVelocity;
        return this;
    }

    public PanGestureHandler setMinVelocityX(float minVelocityX) {
        this.mMinVelocityX = minVelocityX;
        return this;
    }

    public PanGestureHandler setMinVelocityY(float minVelocityY) {
        this.mMinVelocityY = minVelocityY;
        return this;
    }

    private boolean shouldActivate() {
        float dx = this.mLastX - this.mStartX + this.mOffsetX;
        if (this.mActiveOffsetXStart != MIN_VALUE_IGNORE && dx < this.mActiveOffsetXStart) {
            return true;
        }
        if (this.mActiveOffsetXEnd != MAX_VALUE_IGNORE && dx > this.mActiveOffsetXEnd) {
            return true;
        }
        float dy = this.mLastY - this.mStartY + this.mOffsetY;
        if (this.mActiveOffsetYStart != MIN_VALUE_IGNORE && dy < this.mActiveOffsetYStart) {
            return true;
        }
        if (this.mActiveOffsetYEnd != MAX_VALUE_IGNORE && dy > this.mActiveOffsetYEnd) {
            return true;
        }
        float distSq = dx * dx + dy * dy;
        if (this.mMinDistSq != MIN_VALUE_IGNORE && distSq >= this.mMinDistSq) {
            return true;
        }
        float vx = this.mLastVelocityX;
        if (this.mMinVelocityX != MIN_VALUE_IGNORE && (this.mMinVelocityX < 0.0f && vx <= this.mMinVelocityX || this.mMinVelocityX >= 0.0f && vx >= this.mMinVelocityX)) {
            return true;
        }
        float vy = this.mLastVelocityY;
        if (this.mMinVelocityY != MIN_VALUE_IGNORE && (this.mMinVelocityY < 0.0f && vx <= this.mMinVelocityY || this.mMinVelocityY >= 0.0f && vx >= this.mMinVelocityY)) {
            return true;
        }
        float velocitySq = vx * vx + vy * vy;
        return this.mMinVelocitySq != MIN_VALUE_IGNORE && velocitySq >= this.mMinVelocitySq;
    }

    private boolean shouldFail() {
        float dx = this.mLastX - this.mStartX + this.mOffsetX;
        if (this.mFailOffsetXStart != MAX_VALUE_IGNORE && dx < this.mFailOffsetXStart) {
            return true;
        }
        if (this.mFailOffsetXEnd != MIN_VALUE_IGNORE && dx > this.mFailOffsetXEnd) {
            return true;
        }
        float dy = this.mLastY - this.mStartY + this.mOffsetY;
        if (this.mFailOffsetYStart != MAX_VALUE_IGNORE && dy < this.mFailOffsetYStart) {
            return true;
        }
        return this.mFailOffsetYEnd != MIN_VALUE_IGNORE && dy > this.mFailOffsetYEnd;
    }

    @Override
    protected void onHandle(MotionEvent event) {
        int state = this.getState();
        int action = event.getActionMasked();
        if (action == 6 || action == 5) {
            this.mOffsetX += this.mLastX - this.mStartX;
            this.mOffsetY += this.mLastY - this.mStartY;
            this.mLastX = GestureUtils.getLastPointerX(event, this.mAverageTouches);
            this.mLastY = GestureUtils.getLastPointerY(event, this.mAverageTouches);
            this.mStartX = this.mLastX;
            this.mStartY = this.mLastY;
        } else {
            this.mLastX = GestureUtils.getLastPointerX(event, this.mAverageTouches);
            this.mLastY = GestureUtils.getLastPointerY(event, this.mAverageTouches);
        }
        if (state == 0 && event.getPointerCount() >= this.mMinPointers) {
            this.mStartX = this.mLastX;
            this.mStartY = this.mLastY;
            this.mOffsetX = 0.0f;
            this.mOffsetY = 0.0f;
            this.mVelocityTracker = VelocityTracker.obtain();
            PanGestureHandler.addVelocityMovement(this.mVelocityTracker, event);
            this.begin();
        } else if (this.mVelocityTracker != null) {
            PanGestureHandler.addVelocityMovement(this.mVelocityTracker, event);
            this.mVelocityTracker.computeCurrentVelocity(1000);
            this.mLastVelocityX = this.mVelocityTracker.getXVelocity();
            this.mLastVelocityY = this.mVelocityTracker.getYVelocity();
        }
        if (action == 1) {
            if (state == 4 || state == 2) {
                this.end();
            } else {
                this.fail();
            }
        } else if (action == 5 && event.getPointerCount() > this.mMaxPointers) {
            if (state == 4) {
                this.cancel();
            } else {
                this.fail();
            }
        } else if (action == 6 && state == 4 && event.getPointerCount() < this.mMinPointers) {
            this.fail();
        } else if (state == 2) {
            if (this.shouldFail()) {
                this.fail();
            } else if (this.shouldActivate()) {
                this.mStartX = this.mLastX;
                this.mStartY = this.mLastY;
                this.activate();
            }
        }
    }

    @Override
    protected void onReset() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public float getTranslationX() {
        return this.mLastX - this.mStartX + this.mOffsetX;
    }

    public float getTranslationY() {
        return this.mLastY - this.mStartY + this.mOffsetY;
    }

    public float getVelocityX() {
        return this.mLastVelocityX;
    }

    public float getVelocityY() {
        return this.mLastVelocityY;
    }

    private static void addVelocityMovement(VelocityTracker tracker, MotionEvent event) {
        float offsetX = event.getRawX() - event.getX();
        float offsetY = event.getRawY() - event.getY();
        event.offsetLocation(offsetX, offsetY);
        tracker.addMovement(event);
        event.offsetLocation(-offsetX, -offsetY);
    }
}

