/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.swmansion.gesturehandler.GestureHandler;

public class NativeViewGestureHandler
extends GestureHandler<NativeViewGestureHandler> {
    private boolean mShouldActivateOnStart;
    private boolean mDisallowInterruption;

    public NativeViewGestureHandler() {
        this.setShouldCancelWhenOutside(true);
    }

    public NativeViewGestureHandler setShouldActivateOnStart(boolean shouldActivateOnStart) {
        this.mShouldActivateOnStart = shouldActivateOnStart;
        return this;
    }

    public NativeViewGestureHandler setDisallowInterruption(boolean disallowInterruption) {
        this.mDisallowInterruption = disallowInterruption;
        return this;
    }

    @Override
    public boolean shouldRequireToWaitForFailure(GestureHandler handler) {
        return super.shouldRequireToWaitForFailure(handler);
    }

    @Override
    public boolean shouldRecognizeSimultaneously(GestureHandler handler) {
        NativeViewGestureHandler nativeWrapper;
        if (handler instanceof NativeViewGestureHandler && (nativeWrapper = (NativeViewGestureHandler)handler).getState() == 4 && nativeWrapper.mDisallowInterruption) {
            return false;
        }
        boolean canBeInterrupted = !this.mDisallowInterruption;
        int state = this.getState();
        int otherState = handler.getState();
        if (state == 4 && otherState == 4 && canBeInterrupted) {
            return false;
        }
        return state == 4 && canBeInterrupted;
    }

    @Override
    public boolean shouldBeCancelledBy(GestureHandler handler) {
        return !this.mDisallowInterruption;
    }

    @Override
    protected void onHandle(MotionEvent event) {
        View view = this.getView();
        int state = this.getState();
        if (event.getActionMasked() == 1) {
            view.onTouchEvent(event);
            if ((state == 0 || state == 2) && view.isPressed()) {
                this.activate();
            }
            this.end();
        } else if (state == 0 || state == 2) {
            if (this.mShouldActivateOnStart) {
                NativeViewGestureHandler.tryIntercept(view, event);
                view.onTouchEvent(event);
                this.activate();
            } else if (NativeViewGestureHandler.tryIntercept(view, event)) {
                view.onTouchEvent(event);
                this.activate();
            } else if (state != 2) {
                this.begin();
            }
        } else if (state == 4) {
            view.onTouchEvent(event);
        }
    }

    private static boolean tryIntercept(View view, MotionEvent event) {
        return view instanceof ViewGroup && ((ViewGroup)view).onInterceptTouchEvent(event);
    }

    @Override
    protected void onCancel() {
        long time = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)time, (long)time, (int)3, (float)0.0f, (float)0.0f, (int)0);
        event.setAction(3);
        this.getView().onTouchEvent(event);
    }
}

