/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.content.Context;
import android.os.Handler;
import android.view.MotionEvent;
import com.swmansion.gesturehandler.GestureHandler;

public class LongPressGestureHandler
extends GestureHandler<LongPressGestureHandler> {
    private static final long DEFAULT_MIN_DURATION_MS = 500L;
    private static float DEFAULT_MAX_DIST_DP = 10.0f;
    private long mMinDurationMs = 500L;
    private float mMaxDistSq;
    private float mStartX;
    private float mStartY;
    private Handler mHandler;

    public LongPressGestureHandler(Context context) {
        this.setShouldCancelWhenOutside(true);
        this.mMaxDistSq = DEFAULT_MAX_DIST_DP * context.getResources().getDisplayMetrics().density;
    }

    public void setMinDurationMs(long minDurationMs) {
        this.mMinDurationMs = minDurationMs;
    }

    public LongPressGestureHandler setMaxDist(float maxDist) {
        this.mMaxDistSq = maxDist * maxDist;
        return this;
    }

    @Override
    protected void onHandle(MotionEvent event) {
        if (this.getState() == 0) {
            this.begin();
            this.mStartX = event.getRawX();
            this.mStartY = event.getRawY();
            this.mHandler = new Handler();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LongPressGestureHandler.this.activate();
                }
            }, this.mMinDurationMs);
        }
        if (event.getActionMasked() == 1) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
            if (this.getState() == 4) {
                this.end();
            } else {
                this.fail();
            }
        } else {
            float deltaY;
            float deltaX = event.getRawX() - this.mStartX;
            float distSq = deltaX * deltaX + (deltaY = event.getRawY() - this.mStartY) * deltaY;
            if (distSq > this.mMaxDistSq) {
                if (this.getState() == 4) {
                    this.cancel();
                } else {
                    this.fail();
                }
            }
        }
    }

    @Override
    protected void onStateChange(int newState, int previousState) {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }
}

