/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.view.MotionEvent;
import android.view.View;
import com.swmansion.gesturehandler.GestureHandlerInteractionController;
import com.swmansion.gesturehandler.GestureHandlerOrchestrator;
import com.swmansion.gesturehandler.GestureUtils;
import com.swmansion.gesturehandler.OnTouchEventListener;
import java.util.Arrays;

public class GestureHandler<T extends GestureHandler> {
    public static final int STATE_UNDETERMINED = 0;
    public static final int STATE_FAILED = 1;
    public static final int STATE_BEGAN = 2;
    public static final int STATE_CANCELLED = 3;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_END = 5;
    public static final float HIT_SLOP_NONE = Float.NaN;
    private static final int HIT_SLOP_LEFT_IDX = 0;
    private static final int HIT_SLOP_TOP_IDX = 1;
    private static final int HIT_SLOP_RIGHT_IDX = 2;
    private static final int HIT_SLOP_BOTTOM_IDX = 3;
    private static final int HIT_SLOP_WIDTH_IDX = 4;
    private static final int HIT_SLOP_HEIGHT_IDX = 5;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_LEFT = 2;
    public static final int DIRECTION_UP = 4;
    public static final int DIRECTION_DOWN = 8;
    private static int MAX_POINTERS_COUNT = 11;
    private static MotionEvent.PointerProperties[] sPointerProps;
    private static MotionEvent.PointerCoords[] sPointerCoords;
    private final int[] mTrackedPointerIDs = new int[MAX_POINTERS_COUNT];
    private int mTrackedPointersCount = 0;
    private int mTag;
    private View mView;
    private int mState = 0;
    private float mX;
    private float mY;
    private boolean mWithinBounds;
    private boolean mEnabled = true;
    private float[] mHitSlop;
    private float mLastX;
    private float mLastY;
    private float mLastEventOffsetX;
    private float mLastEventOffsetY;
    private boolean mShouldCancelWhenOutside;
    private int mNumberOfPointers = 0;
    private GestureHandlerOrchestrator mOrchestrator;
    private OnTouchEventListener<T> mListener;
    private GestureHandlerInteractionController mInteractionController;
    int mActivationIndex;
    boolean mIsActive;
    boolean mIsAwaiting;

    private static void initPointerProps(int size) {
        if (sPointerProps == null) {
            sPointerProps = new MotionEvent.PointerProperties[MAX_POINTERS_COUNT];
            sPointerCoords = new MotionEvent.PointerCoords[MAX_POINTERS_COUNT];
        }
        while (size > 0 && sPointerProps[size - 1] == null) {
            GestureHandler.sPointerProps[size - 1] = new MotionEvent.PointerProperties();
            GestureHandler.sPointerCoords[size - 1] = new MotionEvent.PointerCoords();
            --size;
        }
    }

    private static boolean hitSlopSet(float value) {
        return !Float.isNaN(value);
    }

    void dispatchStateChange(int newState, int prevState) {
        if (this.mListener != null) {
            this.mListener.onStateChange(this, newState, prevState);
        }
    }

    void dispatchTouchEvent(MotionEvent event) {
        if (this.mListener != null) {
            this.mListener.onTouchEvent(this, event);
        }
    }

    public boolean hasCommonPointers(GestureHandler other) {
        for (int i = 0; i < this.mTrackedPointerIDs.length; ++i) {
            if (this.mTrackedPointerIDs[i] == -1 || other.mTrackedPointerIDs[i] == -1) continue;
            return true;
        }
        return false;
    }

    public T setShouldCancelWhenOutside(boolean shouldCancelWhenOutside) {
        this.mShouldCancelWhenOutside = shouldCancelWhenOutside;
        return (T)this;
    }

    public T setEnabled(boolean enabled) {
        if (this.mView != null) {
            this.cancel();
        }
        this.mEnabled = enabled;
        return (T)this;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public T setHitSlop(float leftPad, float topPad, float rightPad, float bottomPad, float width, float height) {
        if (this.mHitSlop == null) {
            this.mHitSlop = new float[6];
        }
        this.mHitSlop[0] = leftPad;
        this.mHitSlop[1] = topPad;
        this.mHitSlop[2] = rightPad;
        this.mHitSlop[3] = bottomPad;
        this.mHitSlop[4] = width;
        this.mHitSlop[5] = height;
        if (GestureHandler.hitSlopSet(width) && GestureHandler.hitSlopSet(leftPad) && GestureHandler.hitSlopSet(rightPad)) {
            throw new IllegalArgumentException("Cannot have all of left, right and width defined");
        }
        if (GestureHandler.hitSlopSet(width) && !GestureHandler.hitSlopSet(leftPad) && !GestureHandler.hitSlopSet(rightPad)) {
            throw new IllegalArgumentException("When width is set one of left or right pads need to be defined");
        }
        if (GestureHandler.hitSlopSet(height) && GestureHandler.hitSlopSet(bottomPad) && GestureHandler.hitSlopSet(topPad)) {
            throw new IllegalArgumentException("Cannot have all of top, bottom and height defined");
        }
        if (GestureHandler.hitSlopSet(height) && !GestureHandler.hitSlopSet(bottomPad) && !GestureHandler.hitSlopSet(topPad)) {
            throw new IllegalArgumentException("When height is set one of top or bottom pads need to be defined");
        }
        return (T)this;
    }

    public T setHitSlop(float padding) {
        return this.setHitSlop(padding, padding, padding, padding, Float.NaN, Float.NaN);
    }

    public T setInteractionController(GestureHandlerInteractionController controller) {
        this.mInteractionController = controller;
        return (T)this;
    }

    public void setTag(int tag) {
        this.mTag = tag;
    }

    public int getTag() {
        return this.mTag;
    }

    public View getView() {
        return this.mView;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public int getNumberOfPointers() {
        return this.mNumberOfPointers;
    }

    public boolean isWithinBounds() {
        return this.mWithinBounds;
    }

    public final void prepare(View view, GestureHandlerOrchestrator orchestrator) {
        if (this.mView != null || this.mOrchestrator != null) {
            throw new IllegalStateException("Already prepared or hasn't been reset");
        }
        Arrays.fill(this.mTrackedPointerIDs, -1);
        this.mTrackedPointersCount = 0;
        this.mState = 0;
        this.mView = view;
        this.mOrchestrator = orchestrator;
    }

    private int findNextLocalPointerId() {
        int localPointerId;
        for (localPointerId = 0; localPointerId < this.mTrackedPointersCount; ++localPointerId) {
            int i;
            for (i = 0; i < this.mTrackedPointerIDs.length && this.mTrackedPointerIDs[i] != localPointerId; ++i) {
            }
            if (i != this.mTrackedPointerIDs.length) continue;
            return localPointerId;
        }
        return localPointerId;
    }

    public void startTrackingPointer(int pointerId) {
        if (this.mTrackedPointerIDs[pointerId] == -1) {
            this.mTrackedPointerIDs[pointerId] = this.findNextLocalPointerId();
            ++this.mTrackedPointersCount;
        }
    }

    public void stopTrackingPointer(int pointerId) {
        if (this.mTrackedPointerIDs[pointerId] != -1) {
            this.mTrackedPointerIDs[pointerId] = -1;
            --this.mTrackedPointersCount;
        }
    }

    private boolean needAdapt(MotionEvent event) {
        if (event.getPointerCount() != this.mTrackedPointersCount) {
            return true;
        }
        for (int i = 0; i < this.mTrackedPointerIDs.length; ++i) {
            if (this.mTrackedPointerIDs[i] == -1 || this.mTrackedPointerIDs[i] == i) continue;
            return true;
        }
        return false;
    }

    private MotionEvent adaptEvent(MotionEvent event) {
        int actionPointer;
        if (!this.needAdapt(event)) {
            return event;
        }
        int action = event.getActionMasked();
        int actionIndex = -1;
        if (action == 0 || action == 5) {
            actionIndex = event.getActionIndex();
            actionPointer = event.getPointerId(actionIndex);
            action = this.mTrackedPointerIDs[actionPointer] != -1 ? (this.mTrackedPointersCount == 1 ? 0 : 5) : 2;
        } else if (action == 1 || action == 6) {
            actionIndex = event.getActionIndex();
            actionPointer = event.getPointerId(actionIndex);
            action = this.mTrackedPointerIDs[actionPointer] != -1 ? (this.mTrackedPointersCount == 1 ? 1 : 6) : 2;
        }
        GestureHandler.initPointerProps(this.mTrackedPointersCount);
        int count = 0;
        float oldX = event.getX();
        float oldY = event.getY();
        event.setLocation(event.getRawX(), event.getRawY());
        int size = event.getPointerCount();
        for (int index = 0; index < size; ++index) {
            int origPointerId = event.getPointerId(index);
            if (this.mTrackedPointerIDs[origPointerId] == -1) continue;
            event.getPointerProperties(index, sPointerProps[count]);
            GestureHandler.sPointerProps[count].id = this.mTrackedPointerIDs[origPointerId];
            event.getPointerCoords(index, sPointerCoords[count]);
            if (index == actionIndex) {
                action |= count << 8;
            }
            ++count;
        }
        MotionEvent result = MotionEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)action, (int)count, (MotionEvent.PointerProperties[])sPointerProps, (MotionEvent.PointerCoords[])sPointerCoords, (int)event.getMetaState(), (int)event.getButtonState(), (float)event.getXPrecision(), (float)event.getYPrecision(), (int)event.getDeviceId(), (int)event.getEdgeFlags(), (int)event.getSource(), (int)event.getFlags());
        event.setLocation(oldX, oldY);
        result.setLocation(oldX, oldY);
        return result;
    }

    public final void handle(MotionEvent origEvent) {
        if (!this.mEnabled || this.mState == 3 || this.mState == 1 || this.mState == 5 || this.mTrackedPointersCount < 1) {
            return;
        }
        MotionEvent event = this.adaptEvent(origEvent);
        this.mX = event.getX();
        this.mY = event.getY();
        this.mNumberOfPointers = event.getPointerCount();
        this.mWithinBounds = this.isWithinBounds(this.mView, this.mX, this.mY);
        if (this.mShouldCancelWhenOutside && !this.mWithinBounds) {
            if (this.mState == 4) {
                this.cancel();
            } else if (this.mState == 2) {
                this.fail();
            }
            return;
        }
        this.mLastX = GestureUtils.getLastPointerX(event, true);
        this.mLastY = GestureUtils.getLastPointerY(event, true);
        this.mLastEventOffsetX = event.getRawX() - event.getX();
        this.mLastEventOffsetY = event.getRawY() - event.getY();
        this.onHandle(event);
        if (event != origEvent) {
            event.recycle();
        }
    }

    private void moveToState(int newState) {
        if (this.mState == newState) {
            return;
        }
        int oldState = this.mState;
        this.mState = newState;
        this.mOrchestrator.onHandlerStateChange(this, newState, oldState);
        this.onStateChange(newState, oldState);
    }

    public boolean wantEvents() {
        return this.mEnabled && this.mState != 1 && this.mState != 3 && this.mState != 5 && this.mTrackedPointersCount > 0;
    }

    public int getState() {
        return this.mState;
    }

    public boolean shouldRequireToWaitForFailure(GestureHandler handler) {
        if (handler != this && this.mInteractionController != null) {
            return this.mInteractionController.shouldRequireHandlerToWaitForFailure(this, handler);
        }
        return false;
    }

    public boolean shouldWaitForHandlerFailure(GestureHandler handler) {
        if (handler != this && this.mInteractionController != null) {
            return this.mInteractionController.shouldWaitForHandlerFailure(this, handler);
        }
        return false;
    }

    public boolean shouldRecognizeSimultaneously(GestureHandler handler) {
        if (handler == this) {
            return true;
        }
        if (this.mInteractionController != null) {
            return this.mInteractionController.shouldRecognizeSimultaneously(this, handler);
        }
        return false;
    }

    public boolean shouldBeCancelledBy(GestureHandler handler) {
        if (handler == this) {
            return false;
        }
        if (this.mInteractionController != null) {
            return this.mInteractionController.shouldHandlerBeCancelledBy(this, handler);
        }
        return false;
    }

    public boolean isWithinBounds(View view, float posX, float posY) {
        float left = 0.0f;
        float top = 0.0f;
        float right = view.getWidth();
        float bottom = view.getHeight();
        if (this.mHitSlop != null) {
            float padLeft = this.mHitSlop[0];
            float padTop = this.mHitSlop[1];
            float padRight = this.mHitSlop[2];
            float padBottom = this.mHitSlop[3];
            if (GestureHandler.hitSlopSet(padLeft)) {
                left -= padLeft;
            }
            if (GestureHandler.hitSlopSet(padTop)) {
                top -= padBottom;
            }
            if (GestureHandler.hitSlopSet(padRight)) {
                right += padRight;
            }
            if (GestureHandler.hitSlopSet(padBottom)) {
                bottom += padBottom;
            }
            float width = this.mHitSlop[4];
            float height = this.mHitSlop[5];
            if (GestureHandler.hitSlopSet(width)) {
                if (!GestureHandler.hitSlopSet(padLeft)) {
                    left = right - width;
                } else if (!GestureHandler.hitSlopSet(padRight)) {
                    right = left + width;
                }
            }
            if (GestureHandler.hitSlopSet(height)) {
                if (!GestureHandler.hitSlopSet(top)) {
                    top = bottom - height;
                } else if (!GestureHandler.hitSlopSet(bottom)) {
                    bottom = top + height;
                }
            }
        }
        return posX >= left && posX <= right && posY >= top && posY <= bottom;
    }

    public final void cancel() {
        if (this.mState == 4 || this.mState == 0 || this.mState == 2) {
            this.onCancel();
            this.moveToState(3);
        }
    }

    public final void fail() {
        if (this.mState == 4 || this.mState == 0 || this.mState == 2) {
            this.moveToState(1);
        }
    }

    public final void activate() {
        if (this.mState == 0 || this.mState == 2) {
            this.moveToState(4);
        }
    }

    public final void begin() {
        if (this.mState == 0) {
            this.moveToState(2);
        }
    }

    public final void end() {
        if (this.mState == 2 || this.mState == 4) {
            this.moveToState(5);
        }
    }

    protected void onHandle(MotionEvent event) {
        this.moveToState(1);
    }

    protected void onStateChange(int newState, int previousState) {
    }

    protected void onReset() {
    }

    protected void onCancel() {
    }

    public final void reset() {
        this.mView = null;
        this.mOrchestrator = null;
        Arrays.fill(this.mTrackedPointerIDs, -1);
        this.mTrackedPointersCount = 0;
        this.onReset();
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNDETERMINED";
            }
            case 4: {
                return "ACTIVE";
            }
            case 1: {
                return "FAILED";
            }
            case 2: {
                return "BEGIN";
            }
            case 3: {
                return "CANCELLED";
            }
            case 5: {
                return "END";
            }
        }
        return null;
    }

    public GestureHandler setOnTouchEventListener(OnTouchEventListener<T> listener) {
        this.mListener = listener;
        return this;
    }

    public String toString() {
        String viewString = this.mView == null ? null : this.mView.getClass().getSimpleName();
        return this.getClass().getSimpleName() + "@[" + this.mTag + "]:" + viewString;
    }

    public float getLastAbsolutePositionX() {
        return this.mLastX;
    }

    public float getLastAbsolutePositionY() {
        return this.mLastY;
    }

    public float getLastRelativePositionX() {
        return this.mLastX - this.mLastEventOffsetX;
    }

    public float getLastRelativePositionY() {
        return this.mLastY - this.mLastEventOffsetY;
    }
}

