/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.lottie;

import android.animation.Animator;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import com.airbnb.android.react.lottie.LottieAnimationViewPropertyManager;
import com.airbnb.lottie.LottieAnimationView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import java.util.Map;
import java.util.WeakHashMap;

class LottieAnimationViewManager
extends SimpleViewManager<LottieAnimationView> {
    private static final String TAG = LottieAnimationViewManager.class.getSimpleName();
    private static final String REACT_CLASS = "LottieAnimationView";
    private static final int VERSION = 1;
    private static final int COMMAND_PLAY = 1;
    private static final int COMMAND_RESET = 2;
    private Map<LottieAnimationView, LottieAnimationViewPropertyManager> propManagersMap = new WeakHashMap<LottieAnimationView, LottieAnimationViewPropertyManager>();

    LottieAnimationViewManager() {
    }

    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.builder().put((Object)"VERSION", (Object)1).build();
    }

    public String getName() {
        return REACT_CLASS;
    }

    public LottieAnimationView createViewInstance(ThemedReactContext context) {
        final LottieAnimationView view = new LottieAnimationView((Context)context);
        view.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        view.addAnimatorListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                LottieAnimationViewManager.this.sendOnAnimationFinishEvent(view, false);
            }

            public void onAnimationCancel(Animator animation) {
                LottieAnimationViewManager.this.sendOnAnimationFinishEvent(view, true);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return view;
    }

    private void sendOnAnimationFinishEvent(LottieAnimationView view, boolean isCancelled) {
        WritableMap event = Arguments.createMap();
        event.putBoolean("isCancelled", isCancelled);
        Context ctx = view.getContext();
        ReactContext reactContext = null;
        while (ctx instanceof ContextWrapper) {
            if (ctx instanceof ReactContext) {
                reactContext = (ReactContext)ctx;
                break;
            }
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        if (reactContext != null) {
            ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(view.getId(), "animationFinish", event);
        }
    }

    public Map getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put((Object)"animationFinish", (Object)MapBuilder.of((Object)"phasedRegistrationNames", (Object)MapBuilder.of((Object)"bubbled", (Object)"onAnimationFinish"))).build();
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"play", (Object)1, (Object)"reset", (Object)2);
    }

    public void receiveCommand(final LottieAnimationView view, int commandId, final ReadableArray args) {
        switch (commandId) {
            case 1: {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        int startFrame = args.getInt(0);
                        int endFrame = args.getInt(1);
                        if (startFrame != -1 && endFrame != -1) {
                            view.setMinAndMaxFrame(args.getInt(0), args.getInt(1));
                        }
                        if (ViewCompat.isAttachedToWindow((View)view)) {
                            view.setProgress(0.0f);
                            view.playAnimation();
                        } else {
                            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                                public void onViewAttachedToWindow(View v) {
                                    LottieAnimationView view = (LottieAnimationView)v;
                                    view.setProgress(0.0f);
                                    view.playAnimation();
                                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                                }

                                public void onViewDetachedFromWindow(View v) {
                                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                                }
                            });
                        }
                    }
                });
                break;
            }
            case 2: {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        if (ViewCompat.isAttachedToWindow((View)view)) {
                            view.cancelAnimation();
                            view.setProgress(0.0f);
                        }
                    }
                });
            }
        }
    }

    @ReactProp(name="sourceName")
    public void setSourceName(LottieAnimationView view, String name) {
        this.getOrCreatePropertyManager(view).setAnimationName(name);
    }

    @ReactProp(name="sourceJson")
    public void setSourceJson(LottieAnimationView view, String json) {
        this.getOrCreatePropertyManager(view).setAnimationJson(json);
    }

    @ReactProp(name="cacheStrategy")
    public void setCacheStrategy(LottieAnimationView view, String name) {
    }

    @ReactProp(name="resizeMode")
    public void setResizeMode(LottieAnimationView view, String resizeMode) {
        ImageView.ScaleType mode = null;
        if ("cover".equals(resizeMode)) {
            mode = ImageView.ScaleType.CENTER_CROP;
        } else if ("contain".equals(resizeMode)) {
            mode = ImageView.ScaleType.CENTER_INSIDE;
        } else if ("center".equals(resizeMode)) {
            mode = ImageView.ScaleType.CENTER;
        }
        this.getOrCreatePropertyManager(view).setScaleType(mode);
    }

    @ReactProp(name="progress")
    public void setProgress(LottieAnimationView view, float progress) {
        this.getOrCreatePropertyManager(view).setProgress(Float.valueOf(progress));
    }

    @ReactProp(name="speed")
    public void setSpeed(LottieAnimationView view, double speed) {
        this.getOrCreatePropertyManager(view).setSpeed((float)speed);
    }

    @ReactProp(name="loop")
    public void setLoop(LottieAnimationView view, boolean loop) {
        this.getOrCreatePropertyManager(view).setLoop(loop);
    }

    @ReactProp(name="hardwareAccelerationAndroid")
    public void setHardwareAcceleration(LottieAnimationView view, boolean use) {
        this.getOrCreatePropertyManager(view).setUseHardwareAcceleration(use);
    }

    @ReactProp(name="imageAssetsFolder")
    public void setImageAssetsFolder(LottieAnimationView view, String imageAssetsFolder) {
        this.getOrCreatePropertyManager(view).setImageAssetsFolder(imageAssetsFolder);
    }

    @ReactProp(name="imageSource")
    public void setImageSource(LottieAnimationView view, ReadableMap imageSource) {
        this.getOrCreatePropertyManager(view).setImageSource(imageSource);
    }

    @ReactProp(name="enableMergePathsAndroidForKitKatAndAbove")
    public void setEnableMergePaths(LottieAnimationView view, boolean enableMergePaths) {
        this.getOrCreatePropertyManager(view).setEnableMergePaths(enableMergePaths);
    }

    protected void onAfterUpdateTransaction(LottieAnimationView view) {
        super.onAfterUpdateTransaction((View)view);
        this.getOrCreatePropertyManager(view).commitChanges();
    }

    private LottieAnimationViewPropertyManager getOrCreatePropertyManager(LottieAnimationView view) {
        LottieAnimationViewPropertyManager result = this.propManagersMap.get(view);
        if (result == null) {
            result = new LottieAnimationViewPropertyManager(view);
            this.propManagersMap.put(view, result);
        }
        return result;
    }
}

