/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.widget.RecyclerBinderConfiguration;
import com.facebook.litho.sections.widget.RecyclerConfiguration;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.StaggeredGridLayoutInfo;
import javax.annotation.Nullable;

public class StaggeredGridRecyclerConfiguration<T extends SectionTree.Target & Binder<RecyclerView>>
implements RecyclerConfiguration {
    private final int mNumSpans;
    private final int mOrientation;
    private final boolean mReverseLayout;
    private final int mGapStrategy;
    private final RecyclerBinderConfiguration mRecyclerBinderConfiguration;

    public static Builder create() {
        return new Builder();
    }

    @Deprecated
    public static StaggeredGridRecyclerConfiguration createWithRecyclerBinderConfiguration(int numSpans, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        return new StaggeredGridRecyclerConfiguration(numSpans, 1, false, 0, recyclerBinderConfiguration);
    }

    @Deprecated
    public StaggeredGridRecyclerConfiguration(int numSpans) {
        this(numSpans, 1, false);
    }

    @Deprecated
    public StaggeredGridRecyclerConfiguration(int numSpans, int orientation, boolean reverseLayout) {
        this(numSpans, orientation, reverseLayout, Builder.RECYCLER_BINDER_CONFIGURATION);
    }

    @Deprecated
    public StaggeredGridRecyclerConfiguration(int numSpans, int orientation, boolean reverseLayout, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        this(numSpans, orientation, reverseLayout, 0, recyclerBinderConfiguration);
    }

    @Deprecated
    public StaggeredGridRecyclerConfiguration(int numSpans, int orientation, boolean reverseLayout, int gapStrategy, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        this.mNumSpans = numSpans;
        this.mOrientation = orientation;
        this.mReverseLayout = reverseLayout;
        this.mGapStrategy = gapStrategy;
        this.mRecyclerBinderConfiguration = recyclerBinderConfiguration == null ? Builder.RECYCLER_BINDER_CONFIGURATION : recyclerBinderConfiguration;
    }

    @Override
    @Nullable
    public SnapHelper getSnapHelper() {
        return null;
    }

    @Override
    public int getSnapMode() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public LayoutInfo getLayoutInfo(ComponentContext c) {
        return new StaggeredGridLayoutInfo(this.mNumSpans, this.mOrientation, this.mReverseLayout, this.mGapStrategy);
    }

    @Override
    public RecyclerBinderConfiguration getRecyclerBinderConfiguration() {
        return this.mRecyclerBinderConfiguration;
    }

    public static class Builder {
        static final RecyclerBinderConfiguration RECYCLER_BINDER_CONFIGURATION = RecyclerBinderConfiguration.create().build();
        private int mNumSpans = 2;
        private int mOrientation = 1;
        private boolean mReverseLayout = false;
        private int mGapStrategy = 0;
        private RecyclerBinderConfiguration mRecyclerBinderConfiguration = RECYCLER_BINDER_CONFIGURATION;

        Builder() {
        }

        public Builder numSpans(int numSpans) {
            this.mNumSpans = numSpans;
            return this;
        }

        public Builder orientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public Builder reverseLayout(boolean reverseLayout) {
            this.mReverseLayout = reverseLayout;
            return this;
        }

        public Builder gapStrategy(int gapStrategy) {
            this.mGapStrategy = gapStrategy;
            return this;
        }

        public Builder recyclerBinderConfiguration(RecyclerBinderConfiguration recyclerBinderConfiguration) {
            this.mRecyclerBinderConfiguration = recyclerBinderConfiguration;
            return this;
        }

        public StaggeredGridRecyclerConfiguration build() {
            return new StaggeredGridRecyclerConfiguration(this.mNumSpans, this.mOrientation, this.mReverseLayout, this.mGapStrategy, this.mRecyclerBinderConfiguration);
        }
    }
}

