/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Size;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.config.SectionsConfiguration;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.ChangeSetCompleteCallback;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.SmoothScrollAlignmentType;
import com.facebook.litho.widget.ViewportInfo;
import java.util.List;

public class SectionBinderTarget
implements SectionTree.Target,
Binder<RecyclerView> {
    private final RecyclerBinder mRecyclerBinder;
    private final boolean mUseBackgroundChangeSets;

    public static SectionBinderTarget createWithBackgroundChangeSets(RecyclerBinder recyclerBinder) {
        return new SectionBinderTarget(recyclerBinder, true);
    }

    public SectionBinderTarget(RecyclerBinder recyclerBinder) {
        this(recyclerBinder, SectionsConfiguration.useBackgroundChangeSets);
    }

    SectionBinderTarget(RecyclerBinder recyclerBinder, boolean useBackgroundChangeSets) {
        this.mRecyclerBinder = recyclerBinder;
        this.mUseBackgroundChangeSets = useBackgroundChangeSets;
    }

    public void setSize(int width, int height) {
        this.mRecyclerBinder.setSize(width, height);
    }

    public void measure(Size outSize, int widthSpec, int heightSpec, EventHandler<ReMeasureEvent> reMeasureEventEventHandler) {
        this.mRecyclerBinder.measure(outSize, widthSpec, heightSpec, reMeasureEventEventHandler);
    }

    public ComponentTree getComponentAt(int position) {
        return this.mRecyclerBinder.getComponentAt(position);
    }

    public void mount(RecyclerView view) {
        this.mRecyclerBinder.mount(view);
    }

    public void bind(RecyclerView view) {
        this.mRecyclerBinder.bind(view);
    }

    public void unbind(RecyclerView view) {
        this.mRecyclerBinder.unbind(view);
    }

    public void unmount(RecyclerView view) {
        this.mRecyclerBinder.unmount(view);
    }

    public void setViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        this.mRecyclerBinder.setViewportChangedListener(viewportChangedListener);
    }

    public void insert(int index, RenderInfo renderInfo) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.insertItemAtAsync(index, renderInfo);
        } else {
            this.mRecyclerBinder.insertItemAt(index, renderInfo);
        }
    }

    public void insertRange(int index, int count, List<RenderInfo> renderInfos) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.insertRangeAtAsync(index, renderInfos);
        } else {
            this.mRecyclerBinder.insertRangeAt(index, renderInfos);
        }
    }

    public void update(int index, RenderInfo renderInfo) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.updateItemAtAsync(index, renderInfo);
        } else {
            this.mRecyclerBinder.updateItemAt(index, renderInfo);
        }
    }

    public void updateRange(int index, int count, List<RenderInfo> renderInfos) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.updateRangeAtAsync(index, renderInfos);
        } else {
            this.mRecyclerBinder.updateRangeAt(index, renderInfos);
        }
    }

    public void move(int fromPosition, int toPosition) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.moveItemAsync(fromPosition, toPosition);
        } else {
            this.mRecyclerBinder.moveItem(fromPosition, toPosition);
        }
    }

    public void notifyChangeSetComplete(boolean isDataChanged, ChangeSetCompleteCallback changeSetCompleteCallback) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.notifyChangeSetCompleteAsync(isDataChanged, changeSetCompleteCallback);
        } else {
            this.mRecyclerBinder.notifyChangeSetComplete(isDataChanged, changeSetCompleteCallback);
        }
    }

    public void requestFocus(int index) {
        this.mRecyclerBinder.scrollToPosition(index);
    }

    public void requestSmoothFocus(int index, int offset, SmoothScrollAlignmentType type) {
        this.mRecyclerBinder.scrollSmoothToPosition(index, offset, type);
    }

    public void requestFocusWithOffset(int index, int offset) {
        this.mRecyclerBinder.scrollToPositionWithOffset(index, offset);
    }

    public void delete(int index) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.removeItemAtAsync(index);
        } else {
            this.mRecyclerBinder.removeItemAt(index);
        }
    }

    public void deleteRange(int index, int count) {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.removeRangeAtAsync(index, count);
        } else {
            this.mRecyclerBinder.removeRangeAt(index, count);
        }
    }

    public boolean isWrapContent() {
        return this.mRecyclerBinder.isWrapContent();
    }

    public boolean canMeasure() {
        return this.mRecyclerBinder.canMeasure();
    }

    public void setCanMeasure(boolean canMeasure) {
        this.mRecyclerBinder.setCanMeasure(canMeasure);
    }

    public boolean supportsBackgroundChangeSets() {
        return this.mUseBackgroundChangeSets;
    }

    public void clear() {
        if (this.mUseBackgroundChangeSets) {
            this.mRecyclerBinder.clearAsync();
        } else {
            this.mRecyclerBinder.removeRangeAt(0, this.mRecyclerBinder.getItemCount());
        }
    }
}

