/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.SmoothScrollAlignmentType;
import com.facebook.litho.widget.SnapUtil;
import com.facebook.litho.widget.StaggeredGridLayoutHelper;
import java.lang.ref.WeakReference;

public class RecyclerCollectionEventsController
extends RecyclerEventsController {
    private WeakReference<SectionTree> mSectionTree;
    private int mSnapMode = Integer.MIN_VALUE;
    private int mFirstCompletelyVisibleItemPosition = 0;
    private int mLastCompletelyVisibleItemPosition = 0;

    public void requestRefresh() {
        this.requestRefresh(false);
    }

    public void requestRefresh(boolean showSpinner) {
        if (this.mSectionTree != null && this.mSectionTree.get() != null) {
            if (showSpinner) {
                this.showRefreshing();
            }
            ((SectionTree)this.mSectionTree.get()).refresh();
        }
    }

    public void requestScrollToNextPosition(boolean animated) {
        int defaultTarget = Math.max(0, this.mLastCompletelyVisibleItemPosition + 1);
        int snapTarget = this.getSmoothScrollTarget(true, defaultTarget);
        this.requestScrollToPositionInner(animated, defaultTarget, snapTarget);
    }

    public void requestScrollToPreviousPosition(boolean animated) {
        int defaultTarget = Math.max(0, this.mFirstCompletelyVisibleItemPosition - 1);
        int snapTarget = this.getSmoothScrollTarget(false, defaultTarget);
        this.requestScrollToPositionInner(animated, defaultTarget, snapTarget);
    }

    public void requestScrollToPositionWithSnap(int target) {
        this.requestScrollToPositionInner(true, target, target);
    }

    public void requestScrollToPositionWithSnap(int target, RecyclerView.SmoothScroller smoothScroller) {
        this.requestScrollToPositionInner(true, target, target, smoothScroller);
    }

    private void requestScrollToPositionInner(boolean animated, int defaultTarget, int snapTarget) {
        this.requestScrollToPositionInner(animated, defaultTarget, snapTarget, null);
    }

    private void requestScrollToPositionInner(boolean animated, int defaultTarget, int snapTarget, RecyclerView.SmoothScroller smoothScroller) {
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager == null || recyclerView.isLayoutFrozen()) {
            return;
        }
        if (!animated) {
            this.requestScrollToPosition(defaultTarget, false);
            return;
        }
        if (smoothScroller == null && this.mSnapMode == Integer.MIN_VALUE) {
            this.requestScrollToPosition(defaultTarget, true);
            return;
        }
        if (smoothScroller == null) {
            smoothScroller = SnapUtil.getSmoothScrollerWithOffset((Context)recyclerView.getContext(), (int)0, (SmoothScrollAlignmentType)RecyclerCollectionEventsController.getSmoothScrollAlignmentTypeFrom(this.mSnapMode));
        }
        smoothScroller.setTargetPosition(snapTarget);
        layoutManager.startSmoothScroll(smoothScroller);
    }

    private int getSmoothScrollTarget(boolean forward, int defaultTarget) {
        switch (this.mSnapMode) {
            case -2147483648: {
                return defaultTarget;
            }
            case -1: {
                return Math.max(0, forward ? this.mFirstCompletelyVisibleItemPosition + 1 : this.mFirstCompletelyVisibleItemPosition - 1);
            }
            case 1: {
                return Math.max(0, forward ? this.mLastCompletelyVisibleItemPosition + 1 : this.mLastCompletelyVisibleItemPosition - 1);
            }
            case 0x7FFFFFFE: 
            case 0x7FFFFFFF: {
                int centerPositionY;
                RecyclerView recyclerView = this.getRecyclerView();
                if (recyclerView == null) {
                    return defaultTarget;
                }
                int centerPositionX = recyclerView.getWidth() / 2;
                View centerView = recyclerView.findChildViewUnder((float)centerPositionX, (float)(centerPositionY = recyclerView.getHeight() / 2));
                if (centerView == null) {
                    return defaultTarget;
                }
                int centerViewPosition = recyclerView.getChildAdapterPosition(centerView);
                return Math.max(0, forward ? centerViewPosition + 1 : centerViewPosition - 1);
            }
        }
        return defaultTarget;
    }

    private static SmoothScrollAlignmentType getSmoothScrollAlignmentTypeFrom(int snapMode) {
        switch (snapMode) {
            case -1: {
                return SmoothScrollAlignmentType.SNAP_TO_START;
            }
            case 1: {
                return SmoothScrollAlignmentType.SNAP_TO_END;
            }
            case 0x7FFFFFFE: 
            case 0x7FFFFFFF: {
                return SmoothScrollAlignmentType.SNAP_TO_CENTER;
            }
        }
        return SmoothScrollAlignmentType.DEFAULT;
    }

    void setSectionTree(SectionTree sectionTree) {
        this.mSectionTree = new WeakReference<SectionTree>(sectionTree);
    }

    void setSnapMode(int snapMode) {
        this.mSnapMode = snapMode;
    }

    private static int getFirstCompletelyVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return StaggeredGridLayoutHelper.findFirstFullyVisibleItemPosition((StaggeredGridLayoutManager)((StaggeredGridLayoutManager)layoutManager));
        }
        return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
    }

    private static int getLastCompletelyVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return StaggeredGridLayoutHelper.findLastFullyVisibleItemPosition((StaggeredGridLayoutManager)((StaggeredGridLayoutManager)layoutManager));
        }
        return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
    }

    public void updateFirstLastFullyVisibleItemPositions(RecyclerView.LayoutManager layoutManager) {
        int lastCompletelyVisibleItemPosition;
        int firstCompletelyVisibleItemPosition = RecyclerCollectionEventsController.getFirstCompletelyVisibleItemPosition(layoutManager);
        if (firstCompletelyVisibleItemPosition != -1) {
            this.mFirstCompletelyVisibleItemPosition = firstCompletelyVisibleItemPosition;
        }
        if ((lastCompletelyVisibleItemPosition = RecyclerCollectionEventsController.getLastCompletelyVisibleItemPosition(layoutManager)) != -1) {
            this.mLastCompletelyVisibleItemPosition = lastCompletelyVisibleItemPosition;
        }
    }
}

