/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.annotation.IdRes;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.EventHandler;
import com.facebook.litho.StateValue;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Wrapper;
import com.facebook.litho.annotations.FromTrigger;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.OnEvent;
import com.facebook.litho.annotations.OnTrigger;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Param;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.sections.BaseLoadEventsHandler;
import com.facebook.litho.sections.LoadEventsHandler;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionContext;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.config.SectionsConfiguration;
import com.facebook.litho.sections.widget.ListRecyclerConfiguration;
import com.facebook.litho.sections.widget.RecyclerBinderConfiguration;
import com.facebook.litho.sections.widget.RecyclerCollectionComponent;
import com.facebook.litho.sections.widget.RecyclerCollectionEventsController;
import com.facebook.litho.sections.widget.RecyclerConfiguration;
import com.facebook.litho.sections.widget.ScrollEvent;
import com.facebook.litho.sections.widget.SectionBinderTarget;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LithoRecylerView;
import com.facebook.litho.widget.PTRRefreshEvent;
import com.facebook.litho.widget.Recycler;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.ViewportInfo;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import java.util.List;

@LayoutSpec(events={PTRRefreshEvent.class})
public class RecyclerCollectionComponentSpec {
    @PropDefault
    public static final RecyclerConfiguration recyclerConfiguration = new ListRecyclerConfiguration();
    @PropDefault
    public static final boolean nestedScrollingEnabled = true;
    @PropDefault
    public static final int scrollBarStyle = 0;
    @PropDefault
    public static final int recyclerViewId = -1;
    @PropDefault
    public static final int overScrollMode = 0;
    @PropDefault
    protected static final boolean asyncStateUpdates = SectionsConfiguration.sectionComponentsAsyncStateUpdates;
    @PropDefault
    public static final RecyclerView.ItemAnimator itemAnimator = new NoUpdateItemAnimator();
    @PropDefault
    protected static final boolean asyncPropUpdates = SectionsConfiguration.sectionComponentsAsyncPropUpdates;
    @PropDefault
    protected static final boolean setRootAsync = ComponentsConfiguration.setRootAsyncRecyclerCollectionComponent;
    @PropDefault
    public static final boolean clipToPadding = true;
    @PropDefault
    public static final boolean clipChildren = true;
    @PropDefault
    public static final int refreshProgressBarColor = -12425294;
    private static final int MIN_SCROLL_FOR_PAGE = 20;

    @OnCreateLayout
    static Component onCreateLayout(ComponentContext c, @Prop Section section, @Prop(optional=true) Component loadingComponent, @Prop(optional=true) Component emptyComponent, @Prop(optional=true) Component errorComponent, @Prop(optional=true, varArg="onScrollListener") List<RecyclerView.OnScrollListener> onScrollListeners, @Prop(optional=true) LoadEventsHandler loadEventsHandler, @Prop(optional=true) boolean clipToPadding, @Prop(optional=true) boolean clipChildren, @Prop(optional=true) boolean nestedScrollingEnabled, @Prop(optional=true) int scrollBarStyle, @Prop(optional=true) RecyclerView.ItemDecoration itemDecoration, @Prop(optional=true) RecyclerView.ItemAnimator itemAnimator, @Prop(optional=true) @IdRes int recyclerViewId, @Prop(optional=true) int overScrollMode, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int leftPadding, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int rightPadding, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int topPadding, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int bottomPadding, @Prop(optional=true) EventHandler<TouchEvent> recyclerTouchEventHandler, @Prop(optional=true) boolean horizontalFadingEdgeEnabled, @Prop(optional=true) boolean verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int fadingEdgeLength, @Prop(optional=true, resType=ResType.COLOR) int refreshProgressBarColor, @Prop(optional=true) LithoRecylerView.TouchInterceptor touchInterceptor, @Prop(optional=true) boolean setRootAsync, @Prop(optional=true) boolean disablePTR, @Prop(optional=true) RecyclerConfiguration recyclerConfiguration, @State(canUpdateLazily=true) boolean hasSetSectionTreeRoot, @State RecyclerCollectionEventsController internalEventsController, @State LoadingState loadingState, @State Binder<RecyclerView> binder, @State SectionTree sectionTree, @State RecyclerCollectionLoadEventsHandler recyclerCollectionLoadEventsHandler, @State SnapHelper snapHelper) {
        boolean shouldHideComponent;
        recyclerCollectionLoadEventsHandler.setLoadEventsHandler(loadEventsHandler);
        if (hasSetSectionTreeRoot && setRootAsync) {
            sectionTree.setRootAsync(section);
        } else {
            RecyclerCollectionComponent.lazyUpdateHasSetSectionTreeRoot(c, true);
            sectionTree.setRoot(section);
        }
        boolean isErrorButNoErrorComponent = loadingState == LoadingState.ERROR && errorComponent == null;
        boolean isEmptyButNoEmptyComponent = loadingState == LoadingState.EMPTY && emptyComponent == null;
        boolean bl = shouldHideComponent = isEmptyButNoEmptyComponent || isErrorButNoErrorComponent;
        if (shouldHideComponent) {
            return null;
        }
        boolean canPTR = recyclerConfiguration.getOrientation() != 0 && !disablePTR;
        Recycler.Builder recycler = (Recycler.Builder)((Recycler.Builder)Recycler.create((ComponentContext)c).clipToPadding(clipToPadding).leftPadding(leftPadding).rightPadding(rightPadding).topPadding(topPadding).bottomPadding(bottomPadding).clipChildren(clipChildren).nestedScrollingEnabled(nestedScrollingEnabled).scrollBarStyle(scrollBarStyle).recyclerViewId(recyclerViewId).overScrollMode(overScrollMode).recyclerEventsController((RecyclerEventsController)internalEventsController).refreshHandler(!canPTR ? null : RecyclerCollectionComponent.onRefresh(c, sectionTree)).pullToRefresh(canPTR).itemDecoration(itemDecoration).horizontalFadingEdgeEnabled(horizontalFadingEdgeEnabled).verticalFadingEdgeEnabled(verticalFadingEdgeEnabled).fadingEdgeLengthDip((float)fadingEdgeLength).onScrollListener((RecyclerView.OnScrollListener)new RecyclerCollectionOnScrollListener(internalEventsController)).onScrollListeners(onScrollListeners).refreshProgressBarColor(refreshProgressBarColor).snapHelper(snapHelper).touchInterceptor(touchInterceptor).binder(binder).itemAnimator((RecyclerView.ItemAnimator)(RecyclerCollectionComponentSpec.itemAnimator == itemAnimator ? new NoUpdateItemAnimator() : itemAnimator)).flexShrink(0.0f)).touchHandler(recyclerTouchEventHandler);
        if (!binder.canMeasure() && !recyclerConfiguration.getRecyclerBinderConfiguration().isWrapContent()) {
            ((Recycler.Builder)recycler.positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0);
        }
        Column.Builder containerBuilder = ((Column.Builder)Column.create((ComponentContext)c).flexShrink(0.0f)).alignContent(YogaAlign.FLEX_START).child((Component.Builder)recycler);
        if (loadingState == LoadingState.LOADING && loadingComponent != null) {
            containerBuilder.child(((Wrapper.Builder)((Wrapper.Builder)Wrapper.create((ComponentContext)c).delegate(loadingComponent).flexShrink(0.0f)).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0));
        } else if (loadingState == LoadingState.EMPTY) {
            containerBuilder.child(((Wrapper.Builder)((Wrapper.Builder)Wrapper.create((ComponentContext)c).delegate(emptyComponent).flexShrink(0.0f)).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0));
        } else if (loadingState == LoadingState.ERROR) {
            containerBuilder.child(((Wrapper.Builder)((Wrapper.Builder)Wrapper.create((ComponentContext)c).delegate(errorComponent).flexShrink(0.0f)).positionType(YogaPositionType.ABSOLUTE)).positionPx(YogaEdge.ALL, 0));
        }
        return containerBuilder.build();
    }

    @OnCreateInitialState
    static void createInitialState(ComponentContext c, @Prop Section section, @Prop(optional=true) RecyclerConfiguration recyclerConfiguration, @Prop(optional=true) RecyclerCollectionEventsController eventsController, @Prop(optional=true) boolean asyncPropUpdates, @Prop(optional=true) boolean asyncStateUpdates, @Prop(optional=true) boolean forceSyncStateUpdates, @Prop(optional=true) boolean ignoreLoadingUpdates, @Prop(optional=true) String sectionTreeTag, @Prop(optional=true) boolean canMeasureRecycler, StateValue<SnapHelper> snapHelper, StateValue<SectionTree> sectionTree, StateValue<RecyclerCollectionLoadEventsHandler> recyclerCollectionLoadEventsHandler, StateValue<Binder<RecyclerView>> binder, StateValue<LoadingState> loadingState, StateValue<RecyclerCollectionEventsController> internalEventsController) {
        RecyclerBinderConfiguration binderConfiguration = recyclerConfiguration.getRecyclerBinderConfiguration();
        RecyclerBinder recyclerBinder = new RecyclerBinder.Builder().layoutInfo(recyclerConfiguration.getLayoutInfo(c)).rangeRatio(binderConfiguration.getRangeRatio()).layoutHandlerFactory(binderConfiguration.getLayoutHandlerFactory()).wrapContent(binderConfiguration.isWrapContent()).enableStableIds(binderConfiguration.getEnableStableIds()).invalidStateLogParamsList(binderConfiguration.getInvalidStateLogParamsList()).useSharedLayoutStateFuture(binderConfiguration.getUseSharedLayoutStateFuture()).threadPoolConfig(binderConfiguration.getThreadPoolConfiguration()).asyncInitRange(binderConfiguration.getAsyncInitRange()).hscrollAsyncMode(binderConfiguration.getHScrollAsyncMode()).canPrefetchDisplayLists(binderConfiguration.canPrefetchDisplayLists()).isCircular(binderConfiguration.isCircular()).hasDynamicItemHeight(binderConfiguration.hasDynamicItemHeight()).splitLayoutTag(binderConfiguration.getSplitLayoutTag()).build(c);
        SectionBinderTarget targetBinder = new SectionBinderTarget(recyclerBinder, binderConfiguration.getUseBackgroundChangeSets());
        SectionContext sectionContext = new SectionContext(c);
        binder.set((Object)targetBinder);
        snapHelper.set((Object)recyclerConfiguration.getSnapHelper());
        final SectionTree sectionTreeInstance = SectionTree.create((SectionContext)sectionContext, (SectionTree.Target)targetBinder).tag(sectionTreeTag == null || sectionTreeTag.equals("") ? section.getSimpleName() : sectionTreeTag).asyncPropUpdates(asyncPropUpdates).asyncStateUpdates(asyncStateUpdates).forceSyncStateUpdates(forceSyncStateUpdates).build();
        sectionTree.set((Object)sectionTreeInstance);
        RecyclerCollectionEventsController internalEventsControllerInstance = eventsController != null ? eventsController : new RecyclerCollectionEventsController();
        internalEventsControllerInstance.setSectionTree(sectionTreeInstance);
        internalEventsControllerInstance.setSnapMode(recyclerConfiguration.getSnapMode());
        internalEventsController.set((Object)internalEventsControllerInstance);
        RecyclerCollectionLoadEventsHandler recyclerCollectionLoadEventsHandlerInstance = new RecyclerCollectionLoadEventsHandler(c, internalEventsControllerInstance, ignoreLoadingUpdates);
        recyclerCollectionLoadEventsHandler.set((Object)recyclerCollectionLoadEventsHandlerInstance);
        sectionTreeInstance.setLoadEventsHandler((LoadEventsHandler)recyclerCollectionLoadEventsHandlerInstance);
        ViewportInfo.ViewportChanged viewPortChanged = new ViewportInfo.ViewportChanged(){

            public void viewportChanged(int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, int state) {
                sectionTreeInstance.viewPortChanged(firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex, state);
            }
        };
        targetBinder.setViewportChangedListener(viewPortChanged);
        targetBinder.setCanMeasure(canMeasureRecycler);
        if (ignoreLoadingUpdates) {
            loadingState.set((Object)LoadingState.LOADED);
        } else {
            loadingState.set((Object)LoadingState.LOADING);
        }
    }

    @OnUpdateState
    static void updateLoadingState(StateValue<LoadingState> loadingState, @Param LoadingState currentLoadingState) {
        loadingState.set((Object)currentLoadingState);
    }

    @OnEvent(value=PTRRefreshEvent.class)
    protected static boolean onRefresh(ComponentContext c, @Param SectionTree sectionTree, @Prop(optional=true) boolean ignoreLoadingUpdates) {
        EventHandler ptrEventHandler = RecyclerCollectionComponent.getPTRRefreshEventHandler(c);
        if (!ignoreLoadingUpdates || ptrEventHandler == null) {
            sectionTree.refresh();
            return true;
        }
        boolean isHandled = RecyclerCollectionComponent.dispatchPTRRefreshEvent(ptrEventHandler);
        if (!isHandled) {
            sectionTree.refresh();
        }
        return true;
    }

    @OnTrigger(value=ScrollEvent.class)
    static void onScroll(ComponentContext c, @FromTrigger int position, @FromTrigger boolean animate, @State SectionTree sectionTree) {
        sectionTree.requestFocusOnRoot(position);
    }

    public static class NoUpdateItemAnimator
    extends DefaultItemAnimator {
        public NoUpdateItemAnimator() {
            this.setSupportsChangeAnimations(false);
        }
    }

    static class RecyclerCollectionLoadEventsHandler
    extends BaseLoadEventsHandler {
        private LoadEventsHandler mDelegate;
        private LoadingState mLastState = LoadingState.LOADING;
        private final ComponentContext mComponentContext;
        private final RecyclerEventsController mRecyclerEventsController;
        private final boolean mIgnoreLoadingUpdates;

        private RecyclerCollectionLoadEventsHandler(ComponentContext c, RecyclerEventsController recyclerEventsController, boolean ignoreLoadingUpdates) {
            this.mComponentContext = c;
            this.mRecyclerEventsController = recyclerEventsController;
            this.mIgnoreLoadingUpdates = ignoreLoadingUpdates;
        }

        public void setLoadEventsHandler(LoadEventsHandler delegate) {
            this.mDelegate = delegate;
        }

        private synchronized void updateState(LoadingState newState) {
            if (this.mIgnoreLoadingUpdates) {
                return;
            }
            if (this.mLastState != newState) {
                this.mLastState = newState;
                RecyclerCollectionComponent.updateLoadingStateAsync(this.mComponentContext, newState);
            }
        }

        public void onLoadStarted(boolean empty) {
            this.updateState(empty ? LoadingState.LOADING : LoadingState.LOADED);
            LoadEventsHandler delegate = this.mDelegate;
            if (delegate != null) {
                delegate.onLoadStarted(empty);
            }
        }

        public void onLoadSucceeded(boolean empty) {
            this.updateState(empty ? LoadingState.EMPTY : LoadingState.LOADED);
            this.mRecyclerEventsController.clearRefreshing();
            LoadEventsHandler delegate = this.mDelegate;
            if (delegate != null) {
                delegate.onLoadSucceeded(empty);
            }
        }

        public void onLoadFailed(boolean empty) {
            this.updateState(empty ? LoadingState.ERROR : LoadingState.LOADED);
            this.mRecyclerEventsController.clearRefreshing();
            LoadEventsHandler delegate = this.mDelegate;
            if (delegate != null) {
                delegate.onLoadFailed(empty);
            }
        }

        public void onInitialLoad() {
            LoadEventsHandler delegate = this.mDelegate;
            if (delegate != null) {
                delegate.onInitialLoad();
            }
        }
    }

    @VisibleForTesting
    public static enum LoadingState {
        LOADING,
        LOADED,
        EMPTY,
        ERROR;

    }

    private static class RecyclerCollectionOnScrollListener
    extends RecyclerView.OnScrollListener {
        private final RecyclerCollectionEventsController mEventsController;

        private RecyclerCollectionOnScrollListener(RecyclerCollectionEventsController eventsController) {
            this.mEventsController = eventsController;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            this.mEventsController.updateFirstLastFullyVisibleItemPositions(recyclerView.getLayoutManager());
        }
    }
}

