/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.IdRes;
import android.support.annotation.Px;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pools;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.sections.LoadEventsHandler;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.widget.RecyclerCollectionComponentSpec;
import com.facebook.litho.sections.widget.RecyclerCollectionEventsController;
import com.facebook.litho.sections.widget.RecyclerConfiguration;
import com.facebook.litho.sections.widget.ScrollEvent;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LithoRecylerView;
import com.facebook.litho.widget.PTRRefreshEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class RecyclerCollectionComponent
extends Component {
    static final Pools.SynchronizedPool<PTRRefreshEvent> sPTRRefreshEventPool = new Pools.SynchronizedPool(2);
    @Comparable(type=14)
    private RecyclerCollectionComponentStateContainer mStateContainer;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean asyncPropUpdates = RecyclerCollectionComponentSpec.asyncPropUpdates;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean asyncStateUpdates = RecyclerCollectionComponentSpec.asyncStateUpdates;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int bottomPadding;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean canMeasureRecycler;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean clipChildren = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean clipToPadding = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disablePTR;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=10)
    Component emptyComponent;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=10)
    Component errorComponent;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerCollectionEventsController eventsController;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int fadingEdgeLength;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean forceSyncStateUpdates;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean horizontalFadingEdgeEnabled;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean ignoreLoadingUpdates;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerView.ItemAnimator itemAnimator = RecyclerCollectionComponentSpec.itemAnimator;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerView.ItemDecoration itemDecoration;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int leftPadding;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    LoadEventsHandler loadEventsHandler;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=10)
    Component loadingComponent;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean nestedScrollingEnabled = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=5)
    List<RecyclerView.OnScrollListener> onScrollListeners;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int overScrollMode = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerConfiguration recyclerConfiguration = RecyclerCollectionComponentSpec.recyclerConfiguration;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=12)
    EventHandler<TouchEvent> recyclerTouchEventHandler;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    @IdRes
    int recyclerViewId = -1;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int refreshProgressBarColor = -12425294;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int rightPadding;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int scrollBarStyle = 0;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=15)
    Section section;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    String sectionTreeTag;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean setRootAsync = RecyclerCollectionComponentSpec.setRootAsync;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int topPadding;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    LithoRecylerView.TouchInterceptor touchInterceptor;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean verticalFadingEdgeEnabled;
    EventHandler pTRRefreshEventHandler;
    EventTrigger onScrollTrigger;

    private RecyclerCollectionComponent() {
        super("RecyclerCollectionComponent");
        this.mStateContainer = new RecyclerCollectionComponentStateContainer();
    }

    protected StateContainer getStateContainer() {
        return this.mStateContainer;
    }

    public boolean isEquivalentTo(Component other) {
        if (ComponentsConfiguration.useNewIsEquivalentTo) {
            return super.isEquivalentTo(other);
        }
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        RecyclerCollectionComponent recyclerCollectionComponentRef = (RecyclerCollectionComponent)other;
        if (this.getId() == recyclerCollectionComponentRef.getId()) {
            return true;
        }
        if (this.asyncPropUpdates != recyclerCollectionComponentRef.asyncPropUpdates) {
            return false;
        }
        if (this.asyncStateUpdates != recyclerCollectionComponentRef.asyncStateUpdates) {
            return false;
        }
        if (this.bottomPadding != recyclerCollectionComponentRef.bottomPadding) {
            return false;
        }
        if (this.canMeasureRecycler != recyclerCollectionComponentRef.canMeasureRecycler) {
            return false;
        }
        if (this.clipChildren != recyclerCollectionComponentRef.clipChildren) {
            return false;
        }
        if (this.clipToPadding != recyclerCollectionComponentRef.clipToPadding) {
            return false;
        }
        if (this.disablePTR != recyclerCollectionComponentRef.disablePTR) {
            return false;
        }
        if (this.emptyComponent != null ? !this.emptyComponent.isEquivalentTo(recyclerCollectionComponentRef.emptyComponent) : recyclerCollectionComponentRef.emptyComponent != null) {
            return false;
        }
        if (this.errorComponent != null ? !this.errorComponent.isEquivalentTo(recyclerCollectionComponentRef.errorComponent) : recyclerCollectionComponentRef.errorComponent != null) {
            return false;
        }
        if (this.eventsController != null ? !((Object)((Object)this.eventsController)).equals((Object)recyclerCollectionComponentRef.eventsController) : recyclerCollectionComponentRef.eventsController != null) {
            return false;
        }
        if (this.fadingEdgeLength != recyclerCollectionComponentRef.fadingEdgeLength) {
            return false;
        }
        if (this.forceSyncStateUpdates != recyclerCollectionComponentRef.forceSyncStateUpdates) {
            return false;
        }
        if (this.horizontalFadingEdgeEnabled != recyclerCollectionComponentRef.horizontalFadingEdgeEnabled) {
            return false;
        }
        if (this.ignoreLoadingUpdates != recyclerCollectionComponentRef.ignoreLoadingUpdates) {
            return false;
        }
        if (this.itemAnimator != null ? !this.itemAnimator.equals(recyclerCollectionComponentRef.itemAnimator) : recyclerCollectionComponentRef.itemAnimator != null) {
            return false;
        }
        if (this.itemDecoration != null ? !this.itemDecoration.equals(recyclerCollectionComponentRef.itemDecoration) : recyclerCollectionComponentRef.itemDecoration != null) {
            return false;
        }
        if (this.leftPadding != recyclerCollectionComponentRef.leftPadding) {
            return false;
        }
        if (this.loadEventsHandler != null ? !this.loadEventsHandler.equals(recyclerCollectionComponentRef.loadEventsHandler) : recyclerCollectionComponentRef.loadEventsHandler != null) {
            return false;
        }
        if (this.loadingComponent != null ? !this.loadingComponent.isEquivalentTo(recyclerCollectionComponentRef.loadingComponent) : recyclerCollectionComponentRef.loadingComponent != null) {
            return false;
        }
        if (this.nestedScrollingEnabled != recyclerCollectionComponentRef.nestedScrollingEnabled) {
            return false;
        }
        if (this.onScrollListeners != null ? !this.onScrollListeners.equals(recyclerCollectionComponentRef.onScrollListeners) : recyclerCollectionComponentRef.onScrollListeners != null) {
            return false;
        }
        if (this.overScrollMode != recyclerCollectionComponentRef.overScrollMode) {
            return false;
        }
        if (this.recyclerConfiguration != null ? !this.recyclerConfiguration.equals(recyclerCollectionComponentRef.recyclerConfiguration) : recyclerCollectionComponentRef.recyclerConfiguration != null) {
            return false;
        }
        if (this.recyclerTouchEventHandler != null ? !this.recyclerTouchEventHandler.isEquivalentTo(recyclerCollectionComponentRef.recyclerTouchEventHandler) : recyclerCollectionComponentRef.recyclerTouchEventHandler != null) {
            return false;
        }
        if (this.recyclerViewId != recyclerCollectionComponentRef.recyclerViewId) {
            return false;
        }
        if (this.refreshProgressBarColor != recyclerCollectionComponentRef.refreshProgressBarColor) {
            return false;
        }
        if (this.rightPadding != recyclerCollectionComponentRef.rightPadding) {
            return false;
        }
        if (this.scrollBarStyle != recyclerCollectionComponentRef.scrollBarStyle) {
            return false;
        }
        if (this.section != null ? !this.section.isEquivalentTo(recyclerCollectionComponentRef.section) : recyclerCollectionComponentRef.section != null) {
            return false;
        }
        if (this.sectionTreeTag != null ? !this.sectionTreeTag.equals(recyclerCollectionComponentRef.sectionTreeTag) : recyclerCollectionComponentRef.sectionTreeTag != null) {
            return false;
        }
        if (this.setRootAsync != recyclerCollectionComponentRef.setRootAsync) {
            return false;
        }
        if (this.topPadding != recyclerCollectionComponentRef.topPadding) {
            return false;
        }
        if (this.touchInterceptor != null ? !this.touchInterceptor.equals(recyclerCollectionComponentRef.touchInterceptor) : recyclerCollectionComponentRef.touchInterceptor != null) {
            return false;
        }
        if (this.verticalFadingEdgeEnabled != recyclerCollectionComponentRef.verticalFadingEdgeEnabled) {
            return false;
        }
        if (this.mStateContainer.binder != null ? !this.mStateContainer.binder.equals(recyclerCollectionComponentRef.mStateContainer.binder) : recyclerCollectionComponentRef.mStateContainer.binder != null) {
            return false;
        }
        if (this.mStateContainer.hasSetSectionTreeRoot != recyclerCollectionComponentRef.mStateContainer.hasSetSectionTreeRoot) {
            return false;
        }
        if (this.mStateContainer.internalEventsController != null ? !((Object)((Object)this.mStateContainer.internalEventsController)).equals((Object)recyclerCollectionComponentRef.mStateContainer.internalEventsController) : recyclerCollectionComponentRef.mStateContainer.internalEventsController != null) {
            return false;
        }
        if (this.mStateContainer.loadingState != null ? !this.mStateContainer.loadingState.equals((Object)recyclerCollectionComponentRef.mStateContainer.loadingState) : recyclerCollectionComponentRef.mStateContainer.loadingState != null) {
            return false;
        }
        if (this.mStateContainer.recyclerCollectionLoadEventsHandler != null ? !((Object)((Object)this.mStateContainer.recyclerCollectionLoadEventsHandler)).equals((Object)recyclerCollectionComponentRef.mStateContainer.recyclerCollectionLoadEventsHandler) : recyclerCollectionComponentRef.mStateContainer.recyclerCollectionLoadEventsHandler != null) {
            return false;
        }
        if (this.mStateContainer.sectionTree != null ? !this.mStateContainer.sectionTree.equals(recyclerCollectionComponentRef.mStateContainer.sectionTree) : recyclerCollectionComponentRef.mStateContainer.sectionTree != null) {
            return false;
        }
        return !(this.mStateContainer.snapHelper != null ? !this.mStateContainer.snapHelper.equals(recyclerCollectionComponentRef.mStateContainer.snapHelper) : recyclerCollectionComponentRef.mStateContainer.snapHelper != null);
    }

    private UpdateLoadingStateStateUpdate createUpdateLoadingStateStateUpdate(RecyclerCollectionComponentSpec.LoadingState currentLoadingState) {
        return new UpdateLoadingStateStateUpdate(currentLoadingState);
    }

    public RecyclerCollectionComponent makeShallowCopy() {
        RecyclerCollectionComponent component = (RecyclerCollectionComponent)super.makeShallowCopy();
        component.emptyComponent = component.emptyComponent != null ? component.emptyComponent.makeShallowCopy() : null;
        component.errorComponent = component.errorComponent != null ? component.errorComponent.makeShallowCopy() : null;
        component.loadingComponent = component.loadingComponent != null ? component.loadingComponent.makeShallowCopy() : null;
        component.section = component.section != null ? component.section.makeShallowCopy() : null;
        component.mStateContainer = new RecyclerCollectionComponentStateContainer();
        return component;
    }

    protected Component onCreateLayout(ComponentContext c) {
        Component _result = RecyclerCollectionComponentSpec.onCreateLayout(c, this.section, this.loadingComponent, this.emptyComponent, this.errorComponent, this.onScrollListeners, this.loadEventsHandler, this.clipToPadding, this.clipChildren, this.nestedScrollingEnabled, this.scrollBarStyle, this.itemDecoration, this.itemAnimator, this.recyclerViewId, this.overScrollMode, this.leftPadding, this.rightPadding, this.topPadding, this.bottomPadding, this.recyclerTouchEventHandler, this.horizontalFadingEdgeEnabled, this.verticalFadingEdgeEnabled, this.fadingEdgeLength, this.refreshProgressBarColor, this.touchInterceptor, this.setRootAsync, this.disablePTR, this.recyclerConfiguration, this.mStateContainer.hasSetSectionTreeRoot, this.mStateContainer.internalEventsController, this.mStateContainer.loadingState, this.mStateContainer.binder, this.mStateContainer.sectionTree, this.mStateContainer.recyclerCollectionLoadEventsHandler, this.mStateContainer.snapHelper);
        return _result;
    }

    protected void createInitialState(ComponentContext c) {
        StateValue snapHelper = new StateValue();
        StateValue sectionTree = new StateValue();
        StateValue recyclerCollectionLoadEventsHandler = new StateValue();
        StateValue binder = new StateValue();
        StateValue loadingState = new StateValue();
        StateValue internalEventsController = new StateValue();
        RecyclerCollectionComponentSpec.createInitialState(c, this.section, this.recyclerConfiguration, this.eventsController, this.asyncPropUpdates, this.asyncStateUpdates, this.forceSyncStateUpdates, this.ignoreLoadingUpdates, this.sectionTreeTag, this.canMeasureRecycler, (StateValue<SnapHelper>)snapHelper, (StateValue<SectionTree>)sectionTree, (StateValue<RecyclerCollectionComponentSpec.RecyclerCollectionLoadEventsHandler>)recyclerCollectionLoadEventsHandler, (StateValue<Binder<RecyclerView>>)binder, (StateValue<RecyclerCollectionComponentSpec.LoadingState>)loadingState, (StateValue<RecyclerCollectionEventsController>)internalEventsController);
        if (snapHelper.get() != null) {
            this.mStateContainer.snapHelper = (SnapHelper)snapHelper.get();
        }
        if (sectionTree.get() != null) {
            this.mStateContainer.sectionTree = (SectionTree)sectionTree.get();
        }
        if (recyclerCollectionLoadEventsHandler.get() != null) {
            this.mStateContainer.recyclerCollectionLoadEventsHandler = (RecyclerCollectionComponentSpec.RecyclerCollectionLoadEventsHandler)((Object)recyclerCollectionLoadEventsHandler.get());
        }
        if (binder.get() != null) {
            this.mStateContainer.binder = (Binder)binder.get();
        }
        if (loadingState.get() != null) {
            this.mStateContainer.loadingState = (RecyclerCollectionComponentSpec.LoadingState)((Object)loadingState.get());
        }
        if (internalEventsController.get() != null) {
            this.mStateContainer.internalEventsController = (RecyclerCollectionEventsController)((Object)internalEventsController.get());
        }
    }

    public static EventHandler getPTRRefreshEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((RecyclerCollectionComponent)context.getComponentScope()).pTRRefreshEventHandler;
    }

    static Boolean dispatchPTRRefreshEvent(EventHandler _eventHandler) {
        PTRRefreshEvent _eventState = (PTRRefreshEvent)sPTRRefreshEventPool.acquire();
        if (_eventState == null) {
            _eventState = new PTRRefreshEvent();
        }
        EventDispatcher _lifecycle = _eventHandler.mHasEventDispatcher.getEventDispatcher();
        Boolean result = (Boolean)_lifecycle.dispatchOnEvent(_eventHandler, (Object)_eventState);
        sPTRRefreshEventPool.release((Object)_eventState);
        return result;
    }

    private boolean onRefresh(HasEventDispatcher _abstract, ComponentContext c, SectionTree sectionTree) {
        RecyclerCollectionComponent _ref = (RecyclerCollectionComponent)_abstract;
        boolean _result = RecyclerCollectionComponentSpec.onRefresh(c, sectionTree, _ref.ignoreLoadingUpdates);
        return _result;
    }

    public static EventHandler<PTRRefreshEvent> onRefresh(ComponentContext c, SectionTree sectionTree) {
        return RecyclerCollectionComponent.newEventHandler((ComponentContext)c, (int)-1873243140, (Object[])new Object[]{c, sectionTree});
    }

    public Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
        int id = eventHandler.id;
        switch (id) {
            case -1873243140: {
                PTRRefreshEvent _event = (PTRRefreshEvent)eventState;
                return this.onRefresh(eventHandler.mHasEventDispatcher, (ComponentContext)eventHandler.params[0], (SectionTree)eventHandler.params[1]);
            }
            case -1048037474: {
                RecyclerCollectionComponent.dispatchErrorEvent((ComponentContext)((ComponentContext)eventHandler.params[0]), (ErrorEvent)((ErrorEvent)eventState));
                return null;
            }
        }
        return null;
    }

    public static EventTrigger onScrollTrigger(ComponentContext c, String key) {
        int methodId = -1505688212;
        return RecyclerCollectionComponent.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private void onScroll(EventTriggerTarget _abstract, int position, boolean animate) {
        RecyclerCollectionComponent _ref = (RecyclerCollectionComponent)_abstract;
        RecyclerCollectionComponentSpec.onScroll(_ref.getScopedContext(), position, animate, _ref.mStateContainer.sectionTree);
    }

    public static void onScroll(ComponentContext c, String key, int position, boolean animate) {
        int methodId = -1505688212;
        EventTrigger trigger = RecyclerCollectionComponent.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        ScrollEvent _eventState = new ScrollEvent();
        _eventState.position = position;
        _eventState.animate = animate;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    public static void onScroll(EventTrigger trigger, int position, boolean animate) {
        ScrollEvent _eventState = new ScrollEvent();
        _eventState.position = position;
        _eventState.animate = animate;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    static void onScroll(ComponentContext c, int position, boolean animate) {
        RecyclerCollectionComponent component = (RecyclerCollectionComponent)c.getComponentScope();
        component.onScroll((EventTriggerTarget)component, position, animate);
    }

    public Object acceptTriggerEvent(EventTrigger eventTrigger, Object eventState, Object[] params) {
        int id = eventTrigger.mId;
        switch (id) {
            case -1505688212: {
                ScrollEvent _event = (ScrollEvent)eventState;
                this.onScroll(eventTrigger.mTriggerTarget, _event.position, _event.animate);
                return null;
            }
        }
        return null;
    }

    public void recordEventTrigger(EventTriggersContainer container) {
        if (this.onScrollTrigger != null) {
            this.onScrollTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.onScrollTrigger);
        }
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(ComponentContext context, StateContainer _prevStateContainer) {
        RecyclerCollectionComponentStateContainer prevStateContainer = (RecyclerCollectionComponentStateContainer)_prevStateContainer;
        this.mStateContainer.binder = prevStateContainer.binder;
        this.mStateContainer.hasSetSectionTreeRoot = prevStateContainer.hasSetSectionTreeRoot;
        this.mStateContainer.internalEventsController = prevStateContainer.internalEventsController;
        this.mStateContainer.loadingState = prevStateContainer.loadingState;
        this.mStateContainer.recyclerCollectionLoadEventsHandler = prevStateContainer.recyclerCollectionLoadEventsHandler;
        this.mStateContainer.sectionTree = prevStateContainer.sectionTree;
        this.mStateContainer.snapHelper = prevStateContainer.snapHelper;
    }

    protected static void updateLoadingState(ComponentContext c, RecyclerCollectionComponentSpec.LoadingState currentLoadingState) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        UpdateLoadingStateStateUpdate _stateUpdate = ((RecyclerCollectionComponent)_component).createUpdateLoadingStateStateUpdate(currentLoadingState);
        c.updateStateSync((ComponentLifecycle.StateUpdate)_stateUpdate, "RecyclerCollectionComponent.updateLoadingState");
    }

    protected static void updateLoadingStateAsync(ComponentContext c, RecyclerCollectionComponentSpec.LoadingState currentLoadingState) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        UpdateLoadingStateStateUpdate _stateUpdate = ((RecyclerCollectionComponent)_component).createUpdateLoadingStateStateUpdate(currentLoadingState);
        c.updateStateAsync((ComponentLifecycle.StateUpdate)_stateUpdate, "RecyclerCollectionComponent.updateLoadingState");
    }

    protected static void updateLoadingStateSync(ComponentContext c, RecyclerCollectionComponentSpec.LoadingState currentLoadingState) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        UpdateLoadingStateStateUpdate _stateUpdate = ((RecyclerCollectionComponent)_component).createUpdateLoadingStateStateUpdate(currentLoadingState);
        c.updateStateSync((ComponentLifecycle.StateUpdate)_stateUpdate, "RecyclerCollectionComponent.updateLoadingState");
    }

    protected static void lazyUpdateHasSetSectionTreeRoot(ComponentContext c, final boolean lazyUpdateValue) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        ComponentLifecycle.StateUpdate _stateUpdate = new ComponentLifecycle.StateUpdate(){

            public void updateState(StateContainer _stateContainer, Component newComponent) {
                RecyclerCollectionComponent newComponentStateUpdate = (RecyclerCollectionComponent)newComponent;
                StateValue hasSetSectionTreeRoot = new StateValue();
                hasSetSectionTreeRoot.set((Object)lazyUpdateValue);
                ((RecyclerCollectionComponent)newComponentStateUpdate).mStateContainer.hasSetSectionTreeRoot = (Boolean)hasSetSectionTreeRoot.get();
            }
        };
        c.updateStateLazy(_stateUpdate);
    }

    public static Builder create(ComponentContext context) {
        return RecyclerCollectionComponent.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        RecyclerCollectionComponent instance = new RecyclerCollectionComponent();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static class Builder
    extends Component.Builder<Builder> {
        RecyclerCollectionComponent mRecyclerCollectionComponent;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"section"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, RecyclerCollectionComponent recyclerCollectionComponentRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)recyclerCollectionComponentRef);
            this.mRecyclerCollectionComponent = recyclerCollectionComponentRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder asyncPropUpdates(boolean asyncPropUpdates) {
            this.mRecyclerCollectionComponent.asyncPropUpdates = asyncPropUpdates;
            return this;
        }

        public Builder asyncStateUpdates(boolean asyncStateUpdates) {
            this.mRecyclerCollectionComponent.asyncStateUpdates = asyncStateUpdates;
            return this;
        }

        public Builder bottomPaddingPx(@Px int bottomPadding) {
            this.mRecyclerCollectionComponent.bottomPadding = bottomPadding;
            return this;
        }

        public Builder bottomPaddingRes(@DimenRes int resId) {
            this.mRecyclerCollectionComponent.bottomPadding = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder bottomPaddingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerCollectionComponent.bottomPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder bottomPaddingAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.bottomPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder bottomPaddingDip(@Dimension(unit=0) float dip) {
            this.mRecyclerCollectionComponent.bottomPadding = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        public Builder canMeasureRecycler(boolean canMeasureRecycler) {
            this.mRecyclerCollectionComponent.canMeasureRecycler = canMeasureRecycler;
            return this;
        }

        public Builder clipChildren(boolean clipChildren) {
            this.mRecyclerCollectionComponent.clipChildren = clipChildren;
            return this;
        }

        public Builder clipToPadding(boolean clipToPadding) {
            this.mRecyclerCollectionComponent.clipToPadding = clipToPadding;
            return this;
        }

        public Builder disablePTR(boolean disablePTR) {
            this.mRecyclerCollectionComponent.disablePTR = disablePTR;
            return this;
        }

        public Builder emptyComponent(Component emptyComponent) {
            this.mRecyclerCollectionComponent.emptyComponent = emptyComponent == null ? null : emptyComponent.makeShallowCopy();
            return this;
        }

        public Builder emptyComponent(Component.Builder<?> emptyComponentBuilder) {
            this.mRecyclerCollectionComponent.emptyComponent = emptyComponentBuilder == null ? null : emptyComponentBuilder.build();
            return this;
        }

        public Builder errorComponent(Component errorComponent) {
            this.mRecyclerCollectionComponent.errorComponent = errorComponent == null ? null : errorComponent.makeShallowCopy();
            return this;
        }

        public Builder errorComponent(Component.Builder<?> errorComponentBuilder) {
            this.mRecyclerCollectionComponent.errorComponent = errorComponentBuilder == null ? null : errorComponentBuilder.build();
            return this;
        }

        public Builder eventsController(RecyclerCollectionEventsController eventsController) {
            this.mRecyclerCollectionComponent.eventsController = eventsController;
            return this;
        }

        public Builder fadingEdgeLengthPx(@Px int fadingEdgeLength) {
            this.mRecyclerCollectionComponent.fadingEdgeLength = fadingEdgeLength;
            return this;
        }

        public Builder fadingEdgeLengthRes(@DimenRes int resId) {
            this.mRecyclerCollectionComponent.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerCollectionComponent.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder fadingEdgeLengthDip(@Dimension(unit=0) float dip) {
            this.mRecyclerCollectionComponent.fadingEdgeLength = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        public Builder forceSyncStateUpdates(boolean forceSyncStateUpdates) {
            this.mRecyclerCollectionComponent.forceSyncStateUpdates = forceSyncStateUpdates;
            return this;
        }

        public Builder horizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
            this.mRecyclerCollectionComponent.horizontalFadingEdgeEnabled = horizontalFadingEdgeEnabled;
            return this;
        }

        public Builder ignoreLoadingUpdates(boolean ignoreLoadingUpdates) {
            this.mRecyclerCollectionComponent.ignoreLoadingUpdates = ignoreLoadingUpdates;
            return this;
        }

        public Builder itemAnimator(RecyclerView.ItemAnimator itemAnimator) {
            this.mRecyclerCollectionComponent.itemAnimator = itemAnimator;
            return this;
        }

        public Builder itemDecoration(RecyclerView.ItemDecoration itemDecoration) {
            this.mRecyclerCollectionComponent.itemDecoration = itemDecoration;
            return this;
        }

        public Builder leftPaddingPx(@Px int leftPadding) {
            this.mRecyclerCollectionComponent.leftPadding = leftPadding;
            return this;
        }

        public Builder leftPaddingRes(@DimenRes int resId) {
            this.mRecyclerCollectionComponent.leftPadding = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder leftPaddingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerCollectionComponent.leftPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder leftPaddingAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.leftPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder leftPaddingDip(@Dimension(unit=0) float dip) {
            this.mRecyclerCollectionComponent.leftPadding = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        public Builder loadEventsHandler(LoadEventsHandler loadEventsHandler) {
            this.mRecyclerCollectionComponent.loadEventsHandler = loadEventsHandler;
            return this;
        }

        public Builder loadingComponent(Component loadingComponent) {
            this.mRecyclerCollectionComponent.loadingComponent = loadingComponent == null ? null : loadingComponent.makeShallowCopy();
            return this;
        }

        public Builder loadingComponent(Component.Builder<?> loadingComponentBuilder) {
            this.mRecyclerCollectionComponent.loadingComponent = loadingComponentBuilder == null ? null : loadingComponentBuilder.build();
            return this;
        }

        public Builder nestedScrollingEnabled(boolean nestedScrollingEnabled) {
            this.mRecyclerCollectionComponent.nestedScrollingEnabled = nestedScrollingEnabled;
            return this;
        }

        public Builder onScrollListener(RecyclerView.OnScrollListener onScrollListener) {
            if (onScrollListener == null) {
                return this;
            }
            if (this.mRecyclerCollectionComponent.onScrollListeners == null) {
                this.mRecyclerCollectionComponent.onScrollListeners = new ArrayList<RecyclerView.OnScrollListener>();
            }
            this.mRecyclerCollectionComponent.onScrollListeners.add(onScrollListener);
            return this;
        }

        public Builder onScrollListeners(List<RecyclerView.OnScrollListener> onScrollListeners) {
            if (onScrollListeners == null) {
                return this;
            }
            if (this.mRecyclerCollectionComponent.onScrollListeners == null || this.mRecyclerCollectionComponent.onScrollListeners.isEmpty()) {
                this.mRecyclerCollectionComponent.onScrollListeners = onScrollListeners;
            } else {
                this.mRecyclerCollectionComponent.onScrollListeners.addAll(onScrollListeners);
            }
            return this;
        }

        public Builder overScrollMode(int overScrollMode) {
            this.mRecyclerCollectionComponent.overScrollMode = overScrollMode;
            return this;
        }

        public Builder recyclerConfiguration(RecyclerConfiguration recyclerConfiguration) {
            this.mRecyclerCollectionComponent.recyclerConfiguration = recyclerConfiguration;
            return this;
        }

        public Builder recyclerTouchEventHandler(EventHandler<TouchEvent> recyclerTouchEventHandler) {
            this.mRecyclerCollectionComponent.recyclerTouchEventHandler = recyclerTouchEventHandler;
            return this;
        }

        public Builder recyclerViewId(@IdRes int recyclerViewId) {
            this.mRecyclerCollectionComponent.recyclerViewId = recyclerViewId;
            return this;
        }

        public Builder refreshProgressBarColor(@ColorInt int refreshProgressBarColor) {
            this.mRecyclerCollectionComponent.refreshProgressBarColor = refreshProgressBarColor;
            return this;
        }

        public Builder refreshProgressBarColorRes(@ColorRes int resId) {
            this.mRecyclerCollectionComponent.refreshProgressBarColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mRecyclerCollectionComponent.refreshProgressBarColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.refreshProgressBarColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder rightPaddingPx(@Px int rightPadding) {
            this.mRecyclerCollectionComponent.rightPadding = rightPadding;
            return this;
        }

        public Builder rightPaddingRes(@DimenRes int resId) {
            this.mRecyclerCollectionComponent.rightPadding = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder rightPaddingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerCollectionComponent.rightPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder rightPaddingAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.rightPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder rightPaddingDip(@Dimension(unit=0) float dip) {
            this.mRecyclerCollectionComponent.rightPadding = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        public Builder scrollBarStyle(int scrollBarStyle) {
            this.mRecyclerCollectionComponent.scrollBarStyle = scrollBarStyle;
            return this;
        }

        public Builder section(Section section) {
            this.mRecyclerCollectionComponent.section = section;
            this.mRequired.set(0);
            return this;
        }

        public Builder section(Section.Builder<?> sectionBuilder) {
            this.mRecyclerCollectionComponent.section = sectionBuilder == null ? null : sectionBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        public Builder sectionTreeTag(String sectionTreeTag) {
            this.mRecyclerCollectionComponent.sectionTreeTag = sectionTreeTag;
            return this;
        }

        public Builder setRootAsync(boolean setRootAsync) {
            this.mRecyclerCollectionComponent.setRootAsync = setRootAsync;
            return this;
        }

        public Builder topPaddingPx(@Px int topPadding) {
            this.mRecyclerCollectionComponent.topPadding = topPadding;
            return this;
        }

        public Builder topPaddingRes(@DimenRes int resId) {
            this.mRecyclerCollectionComponent.topPadding = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder topPaddingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerCollectionComponent.topPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder topPaddingAttr(@AttrRes int attrResId) {
            this.mRecyclerCollectionComponent.topPadding = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder topPaddingDip(@Dimension(unit=0) float dip) {
            this.mRecyclerCollectionComponent.topPadding = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        public Builder touchInterceptor(LithoRecylerView.TouchInterceptor touchInterceptor) {
            this.mRecyclerCollectionComponent.touchInterceptor = touchInterceptor;
            return this;
        }

        public Builder verticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
            this.mRecyclerCollectionComponent.verticalFadingEdgeEnabled = verticalFadingEdgeEnabled;
            return this;
        }

        public Builder pTRRefreshEventHandler(EventHandler pTRRefreshEventHandler) {
            this.mRecyclerCollectionComponent.pTRRefreshEventHandler = pTRRefreshEventHandler;
            return this;
        }

        public Builder onScrollTrigger(EventTrigger onScrollTrigger) {
            this.mRecyclerCollectionComponent.onScrollTrigger = onScrollTrigger;
            return this;
        }

        private void onScrollTrigger(String key) {
            EventTrigger onScrollTrigger = this.mRecyclerCollectionComponent.onScrollTrigger;
            if (onScrollTrigger == null) {
                onScrollTrigger = RecyclerCollectionComponent.onScrollTrigger(this.mContext, key);
            }
            this.onScrollTrigger(onScrollTrigger);
        }

        public Builder key(String key) {
            super.key(key);
            this.onScrollTrigger(key);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public RecyclerCollectionComponent build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            RecyclerCollectionComponent recyclerCollectionComponentRef = this.mRecyclerCollectionComponent;
            this.release();
            return recyclerCollectionComponentRef;
        }

        protected void release() {
            super.release();
            this.mRecyclerCollectionComponent = null;
            this.mContext = null;
        }
    }

    private static class UpdateLoadingStateStateUpdate
    implements ComponentLifecycle.StateUpdate {
        private RecyclerCollectionComponentSpec.LoadingState mCurrentLoadingState;

        UpdateLoadingStateStateUpdate(RecyclerCollectionComponentSpec.LoadingState currentLoadingState) {
            this.mCurrentLoadingState = currentLoadingState;
        }

        public void updateState(StateContainer _stateContainer, Component newComponent) {
            RecyclerCollectionComponentStateContainer stateContainer = (RecyclerCollectionComponentStateContainer)_stateContainer;
            RecyclerCollectionComponent newComponentStateUpdate = (RecyclerCollectionComponent)newComponent;
            StateValue loadingState = new StateValue();
            loadingState.set((Object)stateContainer.loadingState);
            RecyclerCollectionComponentSpec.updateLoadingState((StateValue<RecyclerCollectionComponentSpec.LoadingState>)loadingState, this.mCurrentLoadingState);
            ((RecyclerCollectionComponent)newComponentStateUpdate).mStateContainer.loadingState = (RecyclerCollectionComponentSpec.LoadingState)((Object)loadingState.get());
        }
    }

    @VisibleForTesting(otherwise=2)
    static class RecyclerCollectionComponentStateContainer
    implements StateContainer {
        @State
        @Comparable(type=13)
        Binder<RecyclerView> binder;
        @State
        @Comparable(type=3)
        boolean hasSetSectionTreeRoot;
        @State
        @Comparable(type=13)
        RecyclerCollectionEventsController internalEventsController;
        @State
        @Comparable(type=13)
        RecyclerCollectionComponentSpec.LoadingState loadingState;
        @State
        @Comparable(type=13)
        RecyclerCollectionComponentSpec.RecyclerCollectionLoadEventsHandler recyclerCollectionLoadEventsHandler;
        @State
        @Comparable(type=13)
        SectionTree sectionTree;
        @State
        @Comparable(type=13)
        SnapHelper snapHelper;

        RecyclerCollectionComponentStateContainer() {
        }
    }
}

