/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.annotation.Nullable;
import com.facebook.litho.ComponentLogParams;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;
import com.facebook.litho.sections.config.SectionsConfiguration;
import com.facebook.litho.widget.LayoutHandlerFactory;
import java.util.List;

public class RecyclerBinderConfiguration {
    private final float mRangeRatio;
    @Nullable
    private final LayoutHandlerFactory mLayoutHandlerFactory;
    private final boolean mCanPrefetchDisplayLists;
    private final boolean mIsCircular;
    private final boolean mIsWrapContent;
    private boolean mHasDynamicItemHeight;
    private boolean mUseBackgroundChangeSets = SectionsConfiguration.useBackgroundChangeSets;
    private boolean mHScrollAsyncMode;
    private boolean mEnableStableIds;
    private boolean mUseSharedLayoutStateFuture = ComponentsConfiguration.useSharedLayoutStateFuture;
    private LayoutThreadPoolConfiguration mThreadPoolConfiguration = ComponentsConfiguration.threadPoolConfiguration;
    private boolean mAsyncInitRange = ComponentsConfiguration.asyncInitRange;
    @Nullable
    private String mSplitLayoutTag;
    @Nullable
    private List<ComponentLogParams> mInvalidStateLogParamsList;

    public static Builder create() {
        return new Builder();
    }

    @Deprecated
    public RecyclerBinderConfiguration(double rangeRatio) {
        this(rangeRatio, null, false);
    }

    @Deprecated
    public RecyclerBinderConfiguration(double rangeRatio, @Nullable LayoutHandlerFactory idleExecutor) {
        this(rangeRatio, idleExecutor, false);
    }

    @Deprecated
    public RecyclerBinderConfiguration(double rangeRatio, @Nullable LayoutHandlerFactory idleExecutor, boolean canPrefetchDisplayLists) {
        this(rangeRatio, idleExecutor, canPrefetchDisplayLists, false);
    }

    @Deprecated
    public RecyclerBinderConfiguration(double rangeRatio, @Nullable LayoutHandlerFactory idleExecutor, boolean canPrefetchDisplayLists, boolean isCircular) {
        this(rangeRatio, idleExecutor, canPrefetchDisplayLists, isCircular, false);
    }

    @Deprecated
    public RecyclerBinderConfiguration(double rangeRatio, @Nullable LayoutHandlerFactory idleExecutor, boolean canPrefetchDisplayLists, boolean isCircular, boolean isWrapContent) {
        this.mRangeRatio = rangeRatio > 0.0 ? (float)rangeRatio : 4.0f;
        this.mLayoutHandlerFactory = idleExecutor;
        this.mCanPrefetchDisplayLists = canPrefetchDisplayLists;
        this.mIsCircular = isCircular;
        this.mIsWrapContent = isWrapContent;
    }

    RecyclerBinderConfiguration(float rangeRatio, @Nullable LayoutHandlerFactory layoutHandlerFactory, boolean canPrefetchDisplayLists, boolean circular, boolean wrapContent, @Nullable List<ComponentLogParams> invalidStateLogParamsList, @Nullable String splitLayoutTag, LayoutThreadPoolConfiguration threadPoolConfiguration, boolean dynamicItemHeight, boolean useBackgroundChangeSets, boolean hScrollAsyncMode, boolean enableStableIds, boolean useSharedLayoutStateFuture, boolean asyncInitRange) {
        this.mRangeRatio = rangeRatio;
        this.mLayoutHandlerFactory = layoutHandlerFactory;
        this.mCanPrefetchDisplayLists = canPrefetchDisplayLists;
        this.mIsCircular = circular;
        this.mIsWrapContent = wrapContent;
        this.mInvalidStateLogParamsList = invalidStateLogParamsList;
        this.mSplitLayoutTag = splitLayoutTag;
        this.mThreadPoolConfiguration = threadPoolConfiguration;
        this.mHasDynamicItemHeight = dynamicItemHeight;
        this.mUseBackgroundChangeSets = useBackgroundChangeSets;
        this.mHScrollAsyncMode = hScrollAsyncMode;
        this.mEnableStableIds = enableStableIds;
        this.mUseSharedLayoutStateFuture = useSharedLayoutStateFuture;
        this.mAsyncInitRange = asyncInitRange;
    }

    public float getRangeRatio() {
        return this.mRangeRatio;
    }

    @Nullable
    public LayoutHandlerFactory getLayoutHandlerFactory() {
        return this.mLayoutHandlerFactory;
    }

    public boolean canPrefetchDisplayLists() {
        return this.mCanPrefetchDisplayLists;
    }

    public boolean isCircular() {
        return this.mIsCircular;
    }

    public boolean isWrapContent() {
        return this.mIsWrapContent;
    }

    boolean hasDynamicItemHeight() {
        return this.mHasDynamicItemHeight;
    }

    public String getSplitLayoutTag() {
        return this.mSplitLayoutTag;
    }

    public boolean getUseBackgroundChangeSets() {
        return this.mUseBackgroundChangeSets;
    }

    public boolean getHScrollAsyncMode() {
        return this.mHScrollAsyncMode;
    }

    public boolean getUseSharedLayoutStateFuture() {
        return this.mUseSharedLayoutStateFuture;
    }

    public LayoutThreadPoolConfiguration getThreadPoolConfiguration() {
        return this.mThreadPoolConfiguration;
    }

    public boolean getAsyncInitRange() {
        return this.mAsyncInitRange;
    }

    public boolean getEnableStableIds() {
        return this.mEnableStableIds;
    }

    @Nullable
    public List<ComponentLogParams> getInvalidStateLogParamsList() {
        return this.mInvalidStateLogParamsList;
    }

    public static class Builder {
        public static final LayoutThreadPoolConfiguration DEFAULT_THREAD_POOL_CONFIG = ComponentsConfiguration.threadPoolConfiguration;
        static final float DEFAULT_RANGE = 4.0f;
        @Nullable
        private LayoutHandlerFactory mLayoutHandlerFactory;
        @Nullable
        private List<ComponentLogParams> mInvalidStateLogParamsList;
        @Nullable
        private String mSplitLayoutTag;
        private LayoutThreadPoolConfiguration mThreadPoolConfiguration = DEFAULT_THREAD_POOL_CONFIG;
        private float mRangeRatio = 4.0f;
        private boolean mCanPrefetchDisplayLists = false;
        private boolean mCircular = false;
        private boolean mWrapContent = false;
        private boolean mDynamicItemHeight = false;
        private boolean mHScrollAsyncMode = false;
        private boolean mEnableStableIds = false;
        private boolean mUseBackgroundChangeSets = SectionsConfiguration.useBackgroundChangeSets;
        private boolean mUseSharedLayoutStateFuture = ComponentsConfiguration.useSharedLayoutStateFuture;
        private boolean mAsyncInitRange = ComponentsConfiguration.asyncInitRange;

        Builder() {
        }

        public Builder idleExecutor(@Nullable LayoutHandlerFactory idleExecutor) {
            this.mLayoutHandlerFactory = idleExecutor;
            return this;
        }

        public Builder invalidStateLogParamsList(@Nullable List<ComponentLogParams> invalidStateLogParamsList) {
            this.mInvalidStateLogParamsList = invalidStateLogParamsList;
            return this;
        }

        public Builder splitLayoutTag(@Nullable String splitLayoutTag) {
            this.mSplitLayoutTag = splitLayoutTag;
            return this;
        }

        public Builder threadPoolConfiguration(@Nullable LayoutThreadPoolConfiguration threadPoolConfiguration) {
            this.mThreadPoolConfiguration = threadPoolConfiguration != null ? threadPoolConfiguration : DEFAULT_THREAD_POOL_CONFIG;
            return this;
        }

        public Builder rangeRatio(float rangeRatio) {
            this.mRangeRatio = rangeRatio > 0.0f ? rangeRatio : 4.0f;
            return this;
        }

        public Builder canPrefetchDisplayLists(boolean canPrefetchDisplayLists) {
            this.mCanPrefetchDisplayLists = canPrefetchDisplayLists;
            return this;
        }

        public Builder isCircular(boolean isCircular) {
            this.mCircular = isCircular;
            return this;
        }

        public Builder wrapContent(boolean isWrapContent) {
            this.mWrapContent = isWrapContent;
            return this;
        }

        public Builder hasDynamicItemHeight(boolean hasDynamicItemHeight) {
            this.mDynamicItemHeight = hasDynamicItemHeight;
            return this;
        }

        public Builder useBackgroundChangeSets(boolean useBackgroundChangeSets) {
            this.mUseBackgroundChangeSets = useBackgroundChangeSets;
            return this;
        }

        public Builder hScrollAsyncMode(boolean hScrollAsyncMode) {
            this.mHScrollAsyncMode = hScrollAsyncMode;
            return this;
        }

        public Builder enableStableIds(boolean enableStableIds) {
            this.mEnableStableIds = enableStableIds;
            return this;
        }

        public Builder useSharedLayoutStateFuture(boolean useSharedLayoutStateFuture) {
            this.mUseSharedLayoutStateFuture = useSharedLayoutStateFuture;
            return this;
        }

        public Builder asyncInitRange(boolean asyncInitRange) {
            this.mAsyncInitRange = asyncInitRange;
            return this;
        }

        public RecyclerBinderConfiguration build() {
            return new RecyclerBinderConfiguration(this.mRangeRatio, this.mLayoutHandlerFactory, this.mCanPrefetchDisplayLists, this.mCircular, this.mWrapContent, this.mInvalidStateLogParamsList, this.mSplitLayoutTag, this.mThreadPoolConfiguration, this.mDynamicItemHeight, this.mUseBackgroundChangeSets, this.mHScrollAsyncMode, this.mEnableStableIds, this.mUseSharedLayoutStateFuture, this.mAsyncInitRange);
        }
    }
}

