/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.widget.LinearLayoutInfoFactory;
import com.facebook.litho.sections.widget.RecyclerBinderConfiguration;
import com.facebook.litho.sections.widget.RecyclerConfiguration;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LinearLayoutInfo;
import com.facebook.litho.widget.SnapUtil;
import javax.annotation.Nullable;

public class ListRecyclerConfiguration<T extends SectionTree.Target & Binder<RecyclerView>>
implements RecyclerConfiguration {
    private final int mOrientation;
    private final boolean mReverseLayout;
    private final int mSnapMode;
    private final RecyclerBinderConfiguration mRecyclerBinderConfiguration;
    private final LinearLayoutInfoFactory mLinearLayoutInfoFactory;

    public static Builder create() {
        return new Builder();
    }

    @Deprecated
    public static ListRecyclerConfiguration createWithRecyclerBinderConfiguration(RecyclerBinderConfiguration recyclerBinderConfiguration) {
        return new ListRecyclerConfiguration(1, false, Integer.MIN_VALUE, recyclerBinderConfiguration, Builder.LINEAR_LAYOUT_INFO_FACTORY);
    }

    @Deprecated
    public ListRecyclerConfiguration() {
        this(1, false, Integer.MIN_VALUE);
    }

    @Deprecated
    public ListRecyclerConfiguration(int orientation, boolean reverseLayout) {
        this(orientation, reverseLayout, Integer.MIN_VALUE);
    }

    @Deprecated
    public ListRecyclerConfiguration(int orientation, boolean reverseLayout, int snapMode) {
        this(orientation, reverseLayout, snapMode, Builder.RECYCLER_BINDER_CONFIGURATION);
    }

    @Deprecated
    public ListRecyclerConfiguration(int orientation, boolean reverseLayout, int snapMode, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        this(orientation, reverseLayout, snapMode, recyclerBinderConfiguration, Builder.LINEAR_LAYOUT_INFO_FACTORY);
    }

    @Deprecated
    public ListRecyclerConfiguration(int orientation, boolean reverseLayout, int snapMode, @Nullable RecyclerBinderConfiguration recyclerBinderConfiguration, @Nullable LinearLayoutInfoFactory linearLayoutInfoFactory) {
        if (orientation == 1 && snapMode != Integer.MIN_VALUE && snapMode != -1) {
            throw new UnsupportedOperationException("Only snap to start is implemented for vertical lists");
        }
        this.mOrientation = orientation;
        this.mReverseLayout = reverseLayout;
        this.mSnapMode = snapMode;
        this.mRecyclerBinderConfiguration = recyclerBinderConfiguration == null ? Builder.RECYCLER_BINDER_CONFIGURATION : recyclerBinderConfiguration;
        this.mLinearLayoutInfoFactory = linearLayoutInfoFactory == null ? Builder.LINEAR_LAYOUT_INFO_FACTORY : linearLayoutInfoFactory;
    }

    @Override
    @Nullable
    public SnapHelper getSnapHelper() {
        return SnapUtil.getSnapHelper((int)this.mSnapMode);
    }

    @Override
    public int getSnapMode() {
        return this.mSnapMode;
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public LayoutInfo getLayoutInfo(ComponentContext c) {
        return this.mLinearLayoutInfoFactory.createLinearLayoutInfo(c.getAndroidContext(), this.mOrientation, this.mReverseLayout);
    }

    @Override
    public RecyclerBinderConfiguration getRecyclerBinderConfiguration() {
        return this.mRecyclerBinderConfiguration;
    }

    public static class Builder {
        static final RecyclerBinderConfiguration RECYCLER_BINDER_CONFIGURATION = RecyclerBinderConfiguration.create().build();
        static final LinearLayoutInfoFactory LINEAR_LAYOUT_INFO_FACTORY = new DefaultLinearLayoutInfoFactory();
        private int mOrientation = 1;
        private boolean mReverseLayout = false;
        private int mSnapMode = Integer.MIN_VALUE;
        private RecyclerBinderConfiguration mRecyclerBinderConfiguration = RECYCLER_BINDER_CONFIGURATION;
        private LinearLayoutInfoFactory mLinearLayoutInfoFactory = LINEAR_LAYOUT_INFO_FACTORY;

        Builder() {
        }

        public Builder orientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public Builder reverseLayout(boolean reverseLayout) {
            this.mReverseLayout = reverseLayout;
            return this;
        }

        public Builder snapMode(int snapMode) {
            this.mSnapMode = snapMode;
            return this;
        }

        public Builder recyclerBinderConfiguration(RecyclerBinderConfiguration recyclerBinderConfiguration) {
            this.mRecyclerBinderConfiguration = recyclerBinderConfiguration;
            return this;
        }

        public Builder linearLayoutInfoFactory(LinearLayoutInfoFactory linearLayoutInfoFactory) {
            this.mLinearLayoutInfoFactory = linearLayoutInfoFactory;
            return this;
        }

        private static void validate(ListRecyclerConfiguration configuration) {
            int snapMode = configuration.getSnapMode();
            if (configuration.getOrientation() == 1 && snapMode != Integer.MIN_VALUE && snapMode != -1) {
                throw new UnsupportedOperationException("Only snap to start is implemented for vertical lists");
            }
        }

        public ListRecyclerConfiguration build() {
            ListRecyclerConfiguration configuration = new ListRecyclerConfiguration(this.mOrientation, this.mReverseLayout, this.mSnapMode, this.mRecyclerBinderConfiguration, this.mLinearLayoutInfoFactory);
            Builder.validate(configuration);
            return configuration;
        }
    }

    private static class DefaultLinearLayoutInfoFactory
    implements LinearLayoutInfoFactory {
        private DefaultLinearLayoutInfoFactory() {
        }

        @Override
        public LinearLayoutInfo createLinearLayoutInfo(Context c, int orientation, boolean reverseLayout) {
            return new LinearLayoutInfo(c, orientation, reverseLayout);
        }
    }
}

