/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.sections.widget;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.sections.SectionTree;
import com.facebook.litho.sections.widget.RecyclerBinderConfiguration;
import com.facebook.litho.sections.widget.RecyclerConfiguration;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.GridLayoutInfo;
import com.facebook.litho.widget.LayoutInfo;
import javax.annotation.Nullable;

public class GridRecyclerConfiguration<T extends SectionTree.Target & Binder<RecyclerView>>
implements RecyclerConfiguration {
    private final int mOrientation;
    private final int mNumColumns;
    private final boolean mReverseLayout;
    private final RecyclerBinderConfiguration mRecyclerBinderConfiguration;
    private final boolean mAllowMeasureOverride;

    public static Builder create() {
        return new Builder();
    }

    @Deprecated
    public static GridRecyclerConfiguration createWithRecyclerBinderConfiguration(int numColumns, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        return new GridRecyclerConfiguration(1, numColumns, false, recyclerBinderConfiguration);
    }

    @Deprecated
    public GridRecyclerConfiguration(int numColumns) {
        this(1, numColumns, false);
    }

    @Deprecated
    public GridRecyclerConfiguration(int orientation, int numColumns, boolean reverseLayout) {
        this(orientation, numColumns, reverseLayout, Builder.RECYCLER_BINDER_CONFIGURATION);
    }

    @Deprecated
    public GridRecyclerConfiguration(int orientation, int numColumns, boolean reverseLayout, RecyclerBinderConfiguration recyclerBinderConfiguration) {
        this(orientation, numColumns, reverseLayout, recyclerBinderConfiguration, false);
    }

    @Deprecated
    public GridRecyclerConfiguration(int orientation, int numColumns, boolean reverseLayout, RecyclerBinderConfiguration recyclerBinderConfiguration, boolean allowMeasureOverride) {
        this.mOrientation = orientation;
        this.mNumColumns = numColumns;
        this.mReverseLayout = reverseLayout;
        this.mRecyclerBinderConfiguration = recyclerBinderConfiguration == null ? Builder.RECYCLER_BINDER_CONFIGURATION : recyclerBinderConfiguration;
        this.mAllowMeasureOverride = allowMeasureOverride;
    }

    @Override
    @Nullable
    public SnapHelper getSnapHelper() {
        return null;
    }

    @Override
    public int getSnapMode() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public LayoutInfo getLayoutInfo(ComponentContext c) {
        return new GridLayoutInfo(c.getAndroidContext(), this.mNumColumns, this.mOrientation, this.mReverseLayout, this.mAllowMeasureOverride);
    }

    @Override
    public RecyclerBinderConfiguration getRecyclerBinderConfiguration() {
        return this.mRecyclerBinderConfiguration;
    }

    public static class Builder {
        static final RecyclerBinderConfiguration RECYCLER_BINDER_CONFIGURATION = RecyclerBinderConfiguration.create().build();
        private int mOrientation = 1;
        private int mNumColumns = 2;
        private boolean mReverseLayout = false;
        private boolean mAllowMeasureOverride = false;
        private RecyclerBinderConfiguration mRecyclerBinderConfiguration = RECYCLER_BINDER_CONFIGURATION;

        Builder() {
        }

        public Builder orientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public Builder numColumns(int numColumns) {
            this.mNumColumns = numColumns;
            return this;
        }

        public Builder reverseLayout(boolean reverseLayout) {
            this.mReverseLayout = reverseLayout;
            return this;
        }

        public Builder recyclerBinderConfiguration(RecyclerBinderConfiguration recyclerBinderConfiguration) {
            this.mRecyclerBinderConfiguration = recyclerBinderConfiguration;
            return this;
        }

        public Builder allowMeasureOverride(boolean allowMeasureOverride) {
            this.mAllowMeasureOverride = allowMeasureOverride;
            return this;
        }

        public GridRecyclerConfiguration build() {
            return new GridRecyclerConfiguration(this.mOrientation, this.mNumColumns, this.mReverseLayout, this.mRecyclerBinderConfiguration, this.mAllowMeasureOverride);
        }
    }
}

